/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.WorkflowModel;
import org.alfresco.mobile.android.api.model.Process;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.impl.PersonImpl;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class ProcessImpl
implements Process {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String definitionIdentifier;
    private GregorianCalendar startedAt;
    private GregorianCalendar endedAt;
    private GregorianCalendar dueAt;
    private String key;
    private int priority;
    private String initiatorIdentifier;
    private String name;
    private String description;
    private boolean hasAllVariables;
    private Map<String, Property> variables = new HashMap<String, Property>();
    private HashMap<String, Serializable> data;
    private static final String SUFFIX_WORKFLOW_DEFINITION = "api/workflow-definitions/";
    private static final String PROP_WORKFLOW_PRIORITY_ENCODED = WorkflowModel.PROP_WORKFLOW_PRIORITY.replaceAll(":", "_");
    private static final String PROP_WORKFLOW_DESCRIPTION_ENCODED = WorkflowModel.PROP_WORKFLOW_DESCRIPTION.replaceAll(":", "_");
    private static final String PROP_WORKFLOW_DUE_DATE_ENCODED = WorkflowModel.PROP_WORKFLOW_DUE_DATE.replaceAll(":", "_");

    public static Process parseJson(Map<String, Object> json) {
        ProcessImpl process = new ProcessImpl();
        process.identifier = JSONConverter.getString(json, (String)"id");
        String definitionIdentifier = JSONConverter.getString(json, (String)"definitionUrl");
        process.definitionIdentifier = definitionIdentifier.replace(SUFFIX_WORKFLOW_DEFINITION, "");
        process.key = JSONConverter.getString(json, (String)"name");
        process.name = JSONConverter.getString(json, (String)"title");
        process.priority = JSONConverter.getInteger(json, (String)"priority").intValue();
        process.description = JSONConverter.getString(json, (String)"message");
        String date = JSONConverter.getString(json, (String)"startDate");
        GregorianCalendar g = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        if (date != null) {
            g.setTime(DateUtils.parseDate(date, sdf));
            process.startedAt = g;
        }
        if ((date = JSONConverter.getString(json, (String)"endDate")) != null) {
            g = new GregorianCalendar();
            g.setTime(DateUtils.parseDate(date, sdf));
            process.endedAt = g;
        }
        Map initiator = (Map)json.get("initiator");
        PersonImpl p = PersonImpl.parseJson(initiator);
        process.initiatorIdentifier = p.getIdentifier();
        process.data = new HashMap();
        process.data.put("initiator", p);
        date = JSONConverter.getString(json, (String)"dueDate");
        if (date != null) {
            g = new GregorianCalendar();
            g.setTime(DateUtils.parseDate(date, sdf));
            process.dueAt = g;
        }
        process.data.put("dueDate", g);
        process.data.put("description", (Serializable)((Object)JSONConverter.getString(json, (String)"description")));
        process.data.put("isActive", JSONConverter.getBoolean(json, (String)"isActive"));
        process.hasAllVariables = true;
        return process;
    }

    public static Process refreshProcess(Process process, Map<String, Property> properties) {
        if (process == null) {
            return null;
        }
        if (properties == null) {
            return process;
        }
        ProcessImpl refreshedProcess = new ProcessImpl();
        refreshedProcess.identifier = process.getIdentifier();
        refreshedProcess.definitionIdentifier = process.getDefinitionIdentifier();
        refreshedProcess.key = process.getKey();
        refreshedProcess.startedAt = process.getStartedAt();
        refreshedProcess.endedAt = process.getEndedAt();
        refreshedProcess.description = process.getDescription();
        refreshedProcess.priority = process.getPriority();
        refreshedProcess.initiatorIdentifier = process.getInitiatorIdentifier();
        refreshedProcess.name = process.getName();
        refreshedProcess.variables = properties;
        refreshedProcess.hasAllVariables = true;
        return refreshedProcess;
    }

    public static Process parsePublicAPIJson(Map<String, Object> json) {
        String endedAt;
        ProcessImpl process = new ProcessImpl();
        process.identifier = JSONConverter.getString(json, (String)"id");
        process.definitionIdentifier = JSONConverter.getString(json, (String)"processDefinitionId");
        process.key = JSONConverter.getString(json, (String)"processDefinitionKey");
        process.initiatorIdentifier = JSONConverter.getString(json, (String)"startUserId");
        GregorianCalendar g = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        String startedAt = JSONConverter.getString(json, (String)"startedAt");
        if (startedAt != null) {
            g.setTime(DateUtils.parseDate(startedAt, sdf));
            process.startedAt = g;
        }
        if ((endedAt = JSONConverter.getString(json, (String)"endedAt")) != null) {
            g = new GregorianCalendar();
            g.setTime(DateUtils.parseDate(endedAt, sdf));
            process.endedAt = g;
        }
        process.hasAllVariables = false;
        process.data = new HashMap();
        if (json.containsKey("durationInMs")) {
            process.data.put("durationInMs", Integer.valueOf(JSONConverter.getInteger(json, (String)"durationInMs").intValue()));
        }
        process.data.put("startActivityId", (Serializable)((Object)JSONConverter.getString(json, (String)"startActivityId")));
        process.data.put("endActivityId", (Serializable)((Object)JSONConverter.getString(json, (String)"endActivityId")));
        process.data.put("completed", JSONConverter.getBoolean(json, (String)"completed"));
        process.data.put("deleteReason", (Serializable)((Object)JSONConverter.getString(json, (String)"deleteReason")));
        if (json.containsKey("processVariables")) {
            ArrayList jo = (ArrayList)json.get("processVariables");
            for (Map item : jo) {
                String dueDateValue;
                if (item.containsKey("name") && PROP_WORKFLOW_PRIORITY_ENCODED.equals(item.get("name"))) {
                    process.priority = JSONConverter.getInteger((Map)item, (String)"value").intValue();
                }
                if (item.containsKey("name") && PROP_WORKFLOW_DESCRIPTION_ENCODED.equals(item.get("name"))) {
                    process.description = JSONConverter.getString((Map)item, (String)"value");
                }
                if (!item.containsKey("name") || !PROP_WORKFLOW_DUE_DATE_ENCODED.equals(item.get("name")) || (dueDateValue = JSONConverter.getString((Map)item, (String)"value")) == null) continue;
                g = new GregorianCalendar();
                g.setTime(DateUtils.parseDate(dueDateValue, sdf));
                process.dueAt = g;
            }
            process.hasAllVariables = true;
        }
        return process;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getDefinitionIdentifier() {
        return this.definitionIdentifier;
    }

    @Override
    public GregorianCalendar getStartedAt() {
        return this.startedAt;
    }

    public Map<String, Serializable> getData() {
        return this.data;
    }

    @Override
    public GregorianCalendar getEndedAt() {
        return this.endedAt;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public GregorianCalendar getDueAt() {
        return this.dueAt;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public String getInitiatorIdentifier() {
        return this.initiatorIdentifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean hasAllVariables() {
        return this.hasAllVariables;
    }

    @Override
    public Property getVariable(String name) {
        return this.variables.get(name);
    }

    @Override
    public Map<String, Property> getVariables() {
        return new HashMap<String, Property>(this.variables);
    }

    @Override
    public <T> T getVariableValue(String name) {
        if (this.variables.get(name) != null) {
            return this.variables.get(name).getValue();
        }
        return null;
    }

    @Override
    public boolean hasCompleted() {
        return this.endedAt != null;
    }
}

