/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Company;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.impl.CompanyImpl;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class PersonImpl
implements Person {
    private static final long serialVersionUID = 1L;
    private String avatarIdentifier;
    private String username;
    private String firstName;
    private String lastName;
    private boolean isCloud = false;
    private Map<String, String> properties;
    private boolean hasAllProperties = true;
    private Company company;
    private static final ArrayList<String> ONPREMISE = new ArrayList<String>(9){
        private static final long serialVersionUID = 1L;
        {
            this.add("jobtitle");
            this.add("location");
            this.add("persondescription");
            this.add("telephone");
            this.add("mobile");
            this.add("email");
            this.add("skype");
            this.add("instantmsg");
            this.add("googleusername");
        }
    };
    private static final ArrayList<String> CLOUD = new ArrayList<String>(9){
        private static final long serialVersionUID = 1L;
        {
            this.add("jobTitle");
            this.add("location");
            this.add("description");
            this.add("telephone");
            this.add("mobile");
            this.add("email");
            this.add("skypeId");
            this.add("instantMessageId");
            this.add("googleId");
        }
    };

    public static PersonImpl parseJson(Map<String, Object> json) {
        return PersonImpl.parseJson(json, true);
    }

    public static PersonImpl parseJson(Map<String, Object> json, boolean hasAllProperties) {
        String separatorInternal = "Store/";
        PersonImpl person = new PersonImpl();
        if (json == null) {
            return null;
        }
        person.avatarIdentifier = JSONConverter.getString(json, (String)"avatarRef");
        if (person.avatarIdentifier == null) {
            person.avatarIdentifier = JSONConverter.getString(json, (String)"avatar");
            if (person.avatarIdentifier != null && person.avatarIdentifier.length() > 0) {
                int beginIndex = person.avatarIdentifier.lastIndexOf(separatorInternal) + separatorInternal.length();
                int endIndex = beginIndex + 36;
                person.avatarIdentifier = NodeRefUtils.createNodeRefByIdentifier(person.avatarIdentifier.subSequence(beginIndex, endIndex).toString());
            }
        }
        person.username = JSONConverter.getString(json, (String)"username");
        if (person.username == null || person.username.length() == 0) {
            person.username = JSONConverter.getString(json, (String)"userName");
        }
        person.firstName = JSONConverter.getString(json, (String)"firstName");
        person.lastName = JSONConverter.getString(json, (String)"lastName");
        HashMap<String, String> props = new HashMap<String, String>(9);
        for (String key : ONPREMISE) {
            props.put(key, JSONConverter.getString(json, (String)key));
        }
        person.properties = props;
        person.company = CompanyImpl.parseJson(json, props.get("location"));
        person.hasAllProperties = hasAllProperties;
        return person;
    }

    public static PersonImpl parsePublicAPIJson(Map<String, Object> json) {
        return PersonImpl.parsePublicAPIJson(json, true);
    }

    public static PersonImpl parsePublicAPIJson(Map<String, Object> json, boolean hasAllProperties) {
        if (json == null) {
            return null;
        }
        PersonImpl person = new PersonImpl();
        person.avatarIdentifier = JSONConverter.getString(json, (String)"avatarId");
        person.username = JSONConverter.getString(json, (String)"id");
        person.firstName = JSONConverter.getString(json, (String)"firstName");
        person.lastName = JSONConverter.getString(json, (String)"lastName");
        person.isCloud = true;
        HashMap<String, String> props = new HashMap<String, String>(9);
        for (String key : CLOUD) {
            props.put(key, JSONConverter.getString(json, (String)key));
        }
        props.put("email", person.username);
        person.properties = props;
        person.company = CompanyImpl.parsePublicAPIJson((Map)json.get("company"), props.get("location"));
        person.hasAllProperties = hasAllProperties;
        return person;
    }

    static Person parsePublicAPIJson(String identifier) {
        if (identifier == null) {
            return null;
        }
        PersonImpl person = new PersonImpl();
        person.username = identifier;
        person.hasAllProperties = false;
        return person;
    }

    @Override
    public String getAvatarIdentifier() {
        return this.avatarIdentifier;
    }

    @Override
    public String getIdentifier() {
        return this.username;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getFullName() {
        StringBuilder builder = new StringBuilder();
        if (this.firstName != null && this.firstName.length() != 0) {
            builder.append(this.firstName);
        }
        if (this.lastName != null && this.lastName.length() != 0) {
            if (builder.length() != 0) {
                builder.append(" ");
                builder.append(this.lastName);
            } else {
                builder.append(this.lastName);
            }
        }
        if (builder.length() == 0) {
            return this.username;
        }
        return builder.toString();
    }

    @Override
    public String getJobTitle() {
        if (this.isCloud) {
            return this.properties.get("jobTitle");
        }
        return this.properties.get("jobtitle");
    }

    @Override
    public String getLocation() {
        return this.properties.get("location");
    }

    @Override
    public String getSummary() {
        if (this.isCloud) {
            return this.properties.get("description");
        }
        return this.properties.get("persondescription");
    }

    @Override
    public String getTelephoneNumber() {
        return this.properties.get("telephone");
    }

    @Override
    public String getMobileNumber() {
        return this.properties.get("mobile");
    }

    @Override
    public String getEmail() {
        return this.properties.get("email");
    }

    @Override
    public String getSkypeId() {
        if (this.isCloud) {
            return this.properties.get("skypeId");
        }
        return this.properties.get("skype");
    }

    @Override
    public String getInstantMessageId() {
        if (this.isCloud) {
            return this.properties.get("instantMessageId");
        }
        return this.properties.get("instantmsg");
    }

    @Override
    public String getGoogleId() {
        if (this.isCloud) {
            return this.properties.get("googleId");
        }
        return this.properties.get("googleusername");
    }

    @Override
    public Company getCompany() {
        return this.company;
    }

    @Override
    public boolean hasAllProperties() {
        return this.hasAllProperties;
    }
}

