/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.Permissions;
import org.alfresco.mobile.android.api.model.impl.NodeImpl;
import org.apache.chemistry.opencmis.commons.enums.Action;

public class PermissionsImpl
implements Permissions {
    private static final long serialVersionUID = 1L;
    private NodeImpl node;

    public PermissionsImpl() {
    }

    public PermissionsImpl(Node node) {
        this.node = (NodeImpl)node;
    }

    @Override
    public boolean canDelete() {
        if (this.node.isDocument()) {
            return this.node.hasAllowableAction(Action.CAN_DELETE_OBJECT);
        }
        if (this.node.isFolder()) {
            return this.node.hasAllowableAction(Action.CAN_DELETE_TREE);
        }
        return false;
    }

    @Override
    public boolean canEdit() {
        return this.node.hasAllowableAction(Action.CAN_UPDATE_PROPERTIES);
    }

    @Override
    public boolean canAddChildren() {
        return this.node.hasAllowableAction(Action.CAN_CREATE_FOLDER) && this.node.hasAllowableAction(Action.CAN_CREATE_DOCUMENT);
    }

    @Override
    public boolean canComment() {
        return this.canEdit() || this.canAddChildren();
    }
}

