/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ModelDefinition;
import org.alfresco.mobile.android.api.model.NodeTypeDefinition;
import org.alfresco.mobile.android.api.model.PropertyDefinition;
import org.alfresco.mobile.android.api.model.impl.ModelDefinitionImpl;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;

public class NodeTypeDefinitionImpl
extends ModelDefinitionImpl
implements NodeTypeDefinition {
    private static final long serialVersionUID = 1L;
    protected Map<String, ModelDefinition> aspectModel;
    private HashMap<String, PropertyDefinition> propertiesIndex;

    public NodeTypeDefinitionImpl() {
    }

    public NodeTypeDefinitionImpl(ObjectType typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    public NodeTypeDefinitionImpl(ObjectType typeDefinition, Map<String, ModelDefinition> aspectModels) {
        this.typeDefinition = typeDefinition;
        this.aspectModel = aspectModels;
        this.propertiesIndex = new HashMap();
        if (this.aspectModel != null) {
            ModelDefinition aspectDefinition = null;
            for (Map.Entry<String, ModelDefinition> aspectDefinitionEntry : this.aspectModel.entrySet()) {
                aspectDefinition = aspectDefinitionEntry.getValue();
                for (String propertyName : aspectDefinition.getPropertyNames()) {
                    this.propertiesIndex.put(propertyName, aspectDefinition.getPropertyDefinition(propertyName));
                }
            }
        }
    }

    @Override
    public List<String> getMandatoryAspects() {
        return this.aspectModel != null ? new ArrayList<String>(this.aspectModel.keySet()) : new ArrayList(0);
    }

    public Map<String, ModelDefinition> getAspectsDefinition() {
        return this.aspectModel != null ? this.aspectModel : new HashMap(0);
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String propertyKey) {
        PropertyDefinition def = super.getPropertyDefinition(propertyKey);
        if (def != null) {
            return def;
        }
        if (this.propertiesIndex == null) {
            return null;
        }
        return this.propertiesIndex.get(propertyKey);
    }

    @Override
    protected String getPrefix() {
        if (BaseTypeId.CMIS_DOCUMENT.equals((Object)this.typeDefinition.getBaseTypeId())) {
            return "D:";
        }
        if (BaseTypeId.CMIS_FOLDER.equals((Object)this.typeDefinition.getBaseTypeId())) {
            return "F:";
        }
        return super.getPrefix();
    }
}

