/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.cmis.client.AlfrescoAspects;
import org.alfresco.mobile.android.api.constants.ContentModel;
import org.alfresco.mobile.android.api.constants.ModelMappingUtils;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.impl.PropertyImpl;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;

public class NodeImpl
implements Node {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private Map<String, Property> properties;
    private List<String> aspects;
    private List<String> allowableActions;
    private transient CmisObject object;
    private boolean hasAllProperties = true;
    public static final Parcelable.Creator<NodeImpl> CREATOR = new Parcelable.Creator<NodeImpl>(){

        public NodeImpl createFromParcel(Parcel in) {
            return new NodeImpl(in);
        }

        public NodeImpl[] newArray(int size) {
            return new NodeImpl[size];
        }
    };

    public NodeImpl() {
    }

    public NodeImpl(CmisObject o) {
        this.object = o;
        this.hasAllProperties = true;
    }

    public NodeImpl(CmisObject o, boolean hasAllProperties) {
        this.object = o;
        this.hasAllProperties = hasAllProperties;
    }

    @Override
    public String getIdentifier() {
        return (String)this.getPropertyValue("cmis:objectId");
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue("cmis:name");
    }

    @Override
    public String getTitle() {
        return (String)this.getPropertyValue(ContentModel.PROP_TITLE);
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue(ContentModel.PROP_DESCRIPTION);
    }

    @Override
    public String getType() {
        if (this.getPropertyValue("cmis:objectTypeId") != null) {
            if (((String)this.getPropertyValue("cmis:objectTypeId")).startsWith("D:")) {
                return ((String)this.getPropertyValue("cmis:objectTypeId")).replaceFirst("D:", "");
            }
            if (((String)this.getPropertyValue("cmis:objectTypeId")).startsWith("F:")) {
                return ((String)this.getPropertyValue("cmis:objectTypeId")).replaceFirst("F:", "");
            }
            if (BaseTypeId.CMIS_DOCUMENT.value().equals(this.getPropertyValue("cmis:objectTypeId"))) {
                return ContentModel.TYPE_CONTENT;
            }
            if (BaseTypeId.CMIS_FOLDER.value().equals(this.getPropertyValue("cmis:objectTypeId"))) {
                return ContentModel.TYPE_FOLDER;
            }
            return (String)this.getPropertyValue("cmis:objectTypeId");
        }
        return null;
    }

    @Override
    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    @Override
    public GregorianCalendar getCreatedAt() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    @Override
    public String getModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    @Override
    public GregorianCalendar getModifiedAt() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    @Override
    public Property getProperty(String name) {
        return this.getProp(ModelMappingUtils.getPropertyName(name));
    }

    @Override
    public Map<String, Property> getProperties() {
        if (this.object != null) {
            List props = this.object.getProperties();
            HashMap<String, Property> s = new HashMap<String, Property>(props.size());
            for (org.apache.chemistry.opencmis.client.api.Property property : props) {
                s.put(property.getId(), new PropertyImpl(property));
            }
            return s;
        }
        if (this.properties != null) {
            return this.properties;
        }
        return null;
    }

    @Override
    public <T> T getPropertyValue(String name) {
        if (this.getProp(name) != null) {
            return this.getProp(name).getValue();
        }
        return null;
    }

    private Property getProp(String name) {
        if (this.object != null) {
            return new PropertyImpl(this.object.getProperty(name));
        }
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public boolean hasAspect(String aspectName) {
        String tmpAspectName = aspectName;
        if (!aspectName.startsWith("P:")) {
            tmpAspectName = "P:" + aspectName;
        }
        if (this.object != null) {
            AlfrescoAspects alf = (AlfrescoAspects)this.object;
            return alf.hasAspect(tmpAspectName);
        }
        if (this.aspects != null) {
            if (!this.aspects.contains(tmpAspectName)) {
                return this.aspects.contains(aspectName);
            }
            return this.aspects.contains(tmpAspectName);
        }
        return false;
    }

    @Override
    public List<String> getAspects() {
        if (this.object != null) {
            AlfrescoAspects alf = (AlfrescoAspects)this.object;
            Collection c = alf.getAspects();
            ArrayList<String> list = new ArrayList<String>(c.size());
            for (ObjectType objectType : c) {
                if (objectType.getId() == null || objectType.getId().isEmpty()) continue;
                list.add(objectType.getId().replaceFirst("P:", ""));
            }
            return list;
        }
        if (this.aspects != null) {
            return this.aspects;
        }
        return new ArrayList<String>(0);
    }

    @Override
    public boolean hasAllProperties() {
        return this.hasAllProperties;
    }

    @Override
    public boolean isFolder() {
        return BaseTypeId.CMIS_FOLDER.value().equals(this.getPropertyValue("cmis:baseTypeId"));
    }

    @Override
    public boolean isDocument() {
        return BaseTypeId.CMIS_DOCUMENT.value().equals(this.getPropertyValue("cmis:baseTypeId"));
    }

    public boolean hasAllowableAction(Action action) {
        if (this.object != null && this.object.getAllowableActions() != null) {
            return this.object.getAllowableActions().getAllowableActions().contains(action);
        }
        if (this.allowableActions != null) {
            return this.allowableActions.contains(action.value());
        }
        return false;
    }

    public boolean hasAllowableAction(String action) {
        if (this.object != null && this.object.getAllowableActions() != null && this.object.getAllowableActions().getAllowableActions() != null) {
            for (Action c : this.object.getAllowableActions().getAllowableActions()) {
                if (!c.value().equals(action)) continue;
                return true;
            }
            return false;
        }
        if (this.allowableActions != null) {
            return this.allowableActions.contains(action);
        }
        return false;
    }

    public Set<String> getAllowableActions() {
        HashSet<String> s = new HashSet<String>();
        if (this.object != null && this.object.getAllowableActions() != null && this.object.getAllowableActions().getAllowableActions() != null) {
            Set actions = this.object.getAllowableActions().getAllowableActions();
            s = new HashSet(actions.size());
            for (Action action : actions) {
                s.add(action.value());
            }
        } else if (this.allowableActions != null) {
            s = new HashSet<String>(this.allowableActions);
        }
        return s;
    }

    public String getPath() {
        if (this.getProperty("cmis:path") != null && this.getProperty("cmis:path").getValue() != null) {
            return this.getProperty("cmis:path").getValue().toString();
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int arg1) {
        if (this.object != null) {
            this.identifier = this.getIdentifier();
            this.properties = this.getProperties();
            this.aspects = this.getAspects();
            this.allowableActions = new ArrayList<String>(this.getAllowableActions());
        }
        dest.writeString(this.identifier);
        dest.writeMap(this.properties);
        dest.writeList(this.aspects);
        dest.writeList(this.allowableActions);
        dest.writeString(Boolean.toString(this.hasAllProperties));
    }

    public NodeImpl(Parcel o) {
        this.identifier = o.readString();
        this.properties = new HashMap<String, Property>();
        o.readMap(this.properties, this.getClass().getClassLoader());
        this.aspects = new ArrayList<String>();
        o.readList(this.aspects, this.getClass().getClassLoader());
        this.allowableActions = new ArrayList<String>();
        o.readList(this.allowableActions, this.getClass().getClassLoader());
        this.hasAllProperties = Boolean.parseBoolean(o.readString());
    }
}

