/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.mobile.android.api.constants.ModelMappingUtils;
import org.alfresco.mobile.android.api.model.ModelDefinition;
import org.alfresco.mobile.android.api.model.PropertyDefinition;
import org.alfresco.mobile.android.api.model.impl.PropertyDefinitionImpl;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;

public class ModelDefinitionImpl
implements ModelDefinition {
    private static final long serialVersionUID = 1L;
    protected TypeDefinition typeDefinition;

    public ModelDefinitionImpl() {
    }

    public ModelDefinitionImpl(ObjectType typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    @Override
    public String getName() {
        if (this.typeDefinition.getId() != null && this.typeDefinition.getId().startsWith(this.getPrefix())) {
            return this.typeDefinition.getId().replaceFirst(this.getPrefix(), "");
        }
        return this.typeDefinition.getId();
    }

    @Override
    public String getTitle() {
        if (this.typeDefinition.getDisplayName() != null && this.typeDefinition.getDisplayName().startsWith(this.getPrefix())) {
            return this.typeDefinition.getDisplayName().replaceFirst(this.getPrefix(), "");
        }
        return this.typeDefinition.getDisplayName();
    }

    @Override
    public String getDescription() {
        if (this.typeDefinition != null) {
            return this.typeDefinition.getDescription();
        }
        return null;
    }

    @Override
    public String getParent() {
        if (this.typeDefinition != null) {
            if (this.typeDefinition.getParentTypeId() != null && this.typeDefinition.getParentTypeId().startsWith(this.getPrefix())) {
                return this.typeDefinition.getParentTypeId().replaceFirst(this.getPrefix(), "");
            }
            return this.typeDefinition.getParentTypeId();
        }
        return null;
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.typeDefinition == null || this.typeDefinition.getPropertyDefinitions() == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.typeDefinition.getPropertyDefinitions().keySet());
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String propertyKey) {
        if (TextUtils.isEmpty((CharSequence)propertyKey)) {
            return null;
        }
        boolean isCmis = propertyKey.startsWith("cmis:");
        String prop = ModelMappingUtils.getPropertyName(propertyKey);
        if (this.typeDefinition != null && this.typeDefinition.getPropertyDefinitions() != null && this.typeDefinition.getPropertyDefinitions().containsKey(prop)) {
            return new PropertyDefinitionImpl(isCmis, (org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition)this.typeDefinition.getPropertyDefinitions().get(prop));
        }
        return null;
    }

    protected String getPrefix() {
        return "";
    }
}

