/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Company;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class CompanyImpl
implements Company {
    private static final long serialVersionUID = 1L;
    private Map<String, String> properties;
    private boolean isCloud = false;
    private static final ArrayList<String> ONPREMISE = new ArrayList<String>(8){
        private static final long serialVersionUID = 1L;
        {
            this.add("organization");
            this.add("companyaddress1");
            this.add("companyaddress2");
            this.add("companyaddress3");
            this.add("companypostcode");
            this.add("companytelephone");
            this.add("companyfax");
            this.add("companyemail");
        }
    };
    private static final ArrayList<String> CLOUD = new ArrayList<String>(8){
        private static final long serialVersionUID = 1L;
        {
            this.add("organization");
            this.add("address1");
            this.add("address2");
            this.add("address3");
            this.add("postcode");
            this.add("telephone");
            this.add("fax");
            this.add("email");
        }
    };

    public static Company parseJson(Map<String, Object> json, String location) {
        CompanyImpl company = new CompanyImpl();
        HashMap<String, String> props = new HashMap<String, String>(8);
        for (String key : ONPREMISE) {
            props.put(key, JSONConverter.getString(json, (String)key));
        }
        props.put("location", location);
        company.properties = props;
        company.isCloud = false;
        return company;
    }

    public static Company parsePublicAPIJson(Map<String, Object> json, String location) {
        CompanyImpl company = new CompanyImpl();
        HashMap<String, String> props = new HashMap<String, String>(8);
        for (String key : CLOUD) {
            props.put(key, JSONConverter.getString(json, (String)key));
        }
        props.put("location", location);
        company.properties = props;
        company.isCloud = true;
        return company;
    }

    @Override
    public String getName() {
        if (this.isCloud) {
            return this.properties.get("organization");
        }
        return this.properties.get("organization");
    }

    @Override
    public String getAddress1() {
        if (this.isCloud) {
            return this.properties.get("address1");
        }
        return this.properties.get("companyaddress1");
    }

    @Override
    public String getAddress2() {
        if (this.isCloud) {
            return this.properties.get("address2");
        }
        return this.properties.get("companyaddress2");
    }

    @Override
    public String getAddress3() {
        if (this.isCloud) {
            return this.properties.get("address3");
        }
        return this.properties.get("companyaddress3");
    }

    @Override
    public String getPostCode() {
        if (this.isCloud) {
            return this.properties.get("postcode");
        }
        return this.properties.get("companypostcode");
    }

    @Override
    public String getTelephoneNumber() {
        if (this.isCloud) {
            return this.properties.get("telephone");
        }
        return this.properties.get("companytelephone");
    }

    @Override
    public String getFaxNumber() {
        if (this.isCloud) {
            return this.properties.get("fax");
        }
        return this.properties.get("companyfax");
    }

    @Override
    public String getEmail() {
        if (this.isCloud) {
            return this.properties.get("email");
        }
        return this.properties.get("companyemail");
    }

    private String getLocation() {
        return this.properties.get("location");
    }

    public boolean isEmpty() {
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            if (prop.getValue() == null || prop.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getFullAddress() {
        StringBuilder sb = new StringBuilder();
        if (this.getAddress1() != null) {
            sb.append(this.getAddress1());
            sb.append(", ");
        }
        if (this.getAddress2() != null) {
            sb.append(this.getAddress2());
            sb.append(", ");
        }
        if (this.getAddress3() != null) {
            sb.append(this.getAddress3());
            sb.append(", ");
        }
        if (this.getPostCode() != null) {
            sb.append(this.getPostCode());
            sb.append(" ");
        }
        if (this.getLocation() != null) {
            sb.append(this.getLocation());
        }
        if (sb.lastIndexOf(", ") == sb.length() - 2) {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

