/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Comment;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.impl.PersonImpl;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class CommentImpl
implements Comment {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String title;
    private String name;
    private String creationDate;
    private String modificationDate;
    private Person author;
    private boolean edit;
    private boolean delete;
    private boolean isUpdated;
    private String content;

    public static CommentImpl parseJson(Map<String, Object> json) {
        CommentImpl comment = new CommentImpl();
        comment.identifier = JSONConverter.getString(json, (String)"nodeRef");
        comment.name = JSONConverter.getString(json, (String)"name");
        comment.title = JSONConverter.getString(json, (String)"title");
        comment.content = JSONConverter.getString(json, (String)"content");
        comment.creationDate = JSONConverter.getString(json, (String)"createdOn");
        comment.modificationDate = JSONConverter.getString(json, (String)"modifiedOn");
        comment.author = PersonImpl.parseJson((Map)json.get("author"));
        comment.isUpdated = JSONConverter.getBoolean(json, (String)"isUpdated");
        Map jo = (Map)json.get("permissions");
        comment.edit = JSONConverter.getBoolean((Map)jo, (String)"edit");
        comment.delete = JSONConverter.getBoolean((Map)jo, (String)"delete");
        return comment;
    }

    public static CommentImpl parsePublicAPIJson(Map<String, Object> json) {
        CommentImpl comment = new CommentImpl();
        comment.identifier = JSONConverter.getString(json, (String)"id");
        if (json.containsKey("title")) {
            comment.title = JSONConverter.getString(json, (String)"title");
        }
        comment.content = JSONConverter.getString(json, (String)"content");
        comment.creationDate = JSONConverter.getString(json, (String)"createdAt");
        comment.modificationDate = JSONConverter.getString(json, (String)"modifiedAt");
        comment.author = CommentImpl.createPerson(json.get("createdBy"));
        comment.isUpdated = JSONConverter.getBoolean(json, (String)"edited");
        if (json.containsKey("canEdit")) {
            comment.edit = JSONConverter.getBoolean(json, (String)"canEdit");
        }
        if (json.containsKey("canDelete")) {
            comment.delete = JSONConverter.getBoolean(json, (String)"canDelete");
        }
        return comment;
    }

    private static Person createPerson(Object json) {
        if (json instanceof Map) {
            return PersonImpl.parsePublicAPIJson(JSONConverter.getMap((Object)json));
        }
        if (json instanceof String) {
            return PersonImpl.parsePublicAPIJson((String)json);
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public GregorianCalendar getCreatedAt() {
        Date d;
        GregorianCalendar g = null;
        if (this.creationDate != null && (d = DateUtils.parseDate(this.creationDate)) != null) {
            g = new GregorianCalendar();
            g.setTime(d);
        }
        return g;
    }

    @Override
    public GregorianCalendar getModifiedAt() {
        Date d;
        GregorianCalendar g = null;
        if (this.modificationDate != null && (d = DateUtils.parseDate(this.modificationDate)) != null) {
            g = new GregorianCalendar();
            g.setTime(d);
        }
        return g;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getCreatedBy() {
        return this.author != null ? this.author.getIdentifier() : null;
    }

    @Override
    public boolean isEdited() {
        return this.isUpdated;
    }

    @Override
    public boolean canEdit() {
        return this.edit;
    }

    @Override
    public boolean canDelete() {
        return this.delete;
    }

    public Person getCreatedByPerson() {
        return this.author;
    }
}

