/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ActivityEntry;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class ActivityEntryImpl
implements ActivityEntry {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String siteShortName;
    private String postUserId;
    private GregorianCalendar postDate;
    private String type;
    private Map<String, String> data;

    public static ActivityEntryImpl parseJson(Map<String, Object> jo) {
        ActivityEntryImpl activityItem = new ActivityEntryImpl();
        activityItem.identifier = JSONConverter.getString(jo, (String)"id");
        activityItem.siteShortName = JSONConverter.getString(jo, (String)"siteNetwork");
        activityItem.postUserId = JSONConverter.getString(jo, (String)"postUserId");
        String postDate = JSONConverter.getString(jo, (String)"postDate");
        GregorianCalendar g = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        g.setTime(DateUtils.parseDate(postDate, sdf));
        activityItem.postDate = g;
        activityItem.type = JSONConverter.getString(jo, (String)"activityType");
        String activitySummaryValue = JSONConverter.getString(jo, (String)"activitySummary");
        Map<String, Object> activitySummary = JsonUtils.parseObject(activitySummaryValue);
        activityItem.data = new HashMap<String, String>();
        activityItem.data.put("feedUserId", JSONConverter.getString(jo, (String)"feedUserId"));
        activityItem.data.put("activitySummaryFormat", JSONConverter.getString(jo, (String)"activitySummaryFormat"));
        activityItem.data.put("lastName", JSONConverter.getString(activitySummary, (String)"lastName"));
        activityItem.data.put("firstName", JSONConverter.getString(activitySummary, (String)"firstName"));
        activityItem.data.put("title", JSONConverter.getString(activitySummary, (String)"title"));
        activityItem.data.put("page", JSONConverter.getString(activitySummary, (String)"page"));
        activityItem.data.put("nodeRef", JSONConverter.getString(activitySummary, (String)"nodeRef"));
        activityItem.data.put("memberLastName", JSONConverter.getString(activitySummary, (String)"memberLastName"));
        activityItem.data.put("role", JSONConverter.getString(activitySummary, (String)"role"));
        activityItem.data.put("status", JSONConverter.getString(activitySummary, (String)"status"));
        activityItem.data.put("memberFirstName", JSONConverter.getString(activitySummary, (String)"memberFirstName"));
        activityItem.data.put("memberUserName", JSONConverter.getString(activitySummary, (String)"memberUserName"));
        activityItem.data.put("followerUserName", JSONConverter.getString(activitySummary, (String)"followerUserName"));
        activityItem.data.put("subscriberFirstName", JSONConverter.getString(activitySummary, (String)"subscriberFirstName"));
        activityItem.data.put("subscriberLastName", JSONConverter.getString(activitySummary, (String)"subscriberLastName"));
        activityItem.data.put("userFirstName", JSONConverter.getString(activitySummary, (String)"userFirstName"));
        activityItem.data.put("userUserName", JSONConverter.getString(activitySummary, (String)"userUserName"));
        activityItem.data.put("userLastName", JSONConverter.getString(activitySummary, (String)"userLastName"));
        activityItem.data.put("memberPersonId", JSONConverter.getString(activitySummary, (String)"memberPersonId"));
        return activityItem;
    }

    public static ActivityEntryImpl parsePublicAPIJson(Map<String, Object> jo) {
        ActivityEntryImpl activityItem = new ActivityEntryImpl();
        activityItem.identifier = JSONConverter.getString(jo, (String)"id");
        activityItem.siteShortName = JSONConverter.getString(jo, (String)"siteId");
        activityItem.postUserId = JSONConverter.getString(jo, (String)"postPersonId");
        String postDate = JSONConverter.getString(jo, (String)"postedAt");
        GregorianCalendar g = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        g.setTime(DateUtils.parseDate(postDate, sdf));
        activityItem.postDate = g;
        activityItem.type = JSONConverter.getString(jo, (String)"activityType");
        Map activitySummary = (Map)jo.get("activitySummary");
        activityItem.data = new HashMap<String, String>();
        activityItem.data.put("feedUserId", JSONConverter.getString(jo, (String)"feedUserId"));
        activityItem.data.put("activitySummaryFormat", JSONConverter.getString(jo, (String)"activitySummaryFormat"));
        activityItem.data.put("lastName", JSONConverter.getString((Map)activitySummary, (String)"lastName"));
        activityItem.data.put("firstName", JSONConverter.getString((Map)activitySummary, (String)"firstName"));
        activityItem.data.put("title", JSONConverter.getString((Map)activitySummary, (String)"title"));
        activityItem.data.put("page", JSONConverter.getString((Map)activitySummary, (String)"page"));
        activityItem.data.put("objectId", JSONConverter.getString((Map)activitySummary, (String)"objectId"));
        activityItem.data.put("networkId", JSONConverter.getString((Map)activitySummary, (String)"networkId"));
        activityItem.data.put("memberLastName", JSONConverter.getString((Map)activitySummary, (String)"memberLastName"));
        activityItem.data.put("role", JSONConverter.getString((Map)activitySummary, (String)"role"));
        activityItem.data.put("status", JSONConverter.getString((Map)activitySummary, (String)"status"));
        activityItem.data.put("memberFirstName", JSONConverter.getString((Map)activitySummary, (String)"memberFirstName"));
        activityItem.data.put("memberUserName", JSONConverter.getString((Map)activitySummary, (String)"memberUserName"));
        activityItem.data.put("followerUserName", JSONConverter.getString((Map)activitySummary, (String)"followerUserName"));
        activityItem.data.put("subscriberFirstName", JSONConverter.getString((Map)activitySummary, (String)"subscriberFirstName"));
        activityItem.data.put("subscriberLastName", JSONConverter.getString((Map)activitySummary, (String)"subscriberLastName"));
        activityItem.data.put("userFirstName", JSONConverter.getString((Map)activitySummary, (String)"userFirstName"));
        activityItem.data.put("userUserName", JSONConverter.getString((Map)activitySummary, (String)"userUserName"));
        activityItem.data.put("userLastName", JSONConverter.getString((Map)activitySummary, (String)"userLastName"));
        activityItem.data.put("memberPersonId", JSONConverter.getString((Map)activitySummary, (String)"memberPersonId"));
        return activityItem;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public String getData(String key) {
        if (this.data == null || !this.data.containsKey(key)) {
            return null;
        }
        return this.data.get(key);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getSiteShortName() {
        return this.siteShortName;
    }

    @Override
    public String getCreatedBy() {
        return this.postUserId;
    }

    @Override
    public GregorianCalendar getCreatedAt() {
        return this.postDate;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

