/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.exceptions.impl;

import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoErrorContent;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class OAuthErrorContent
implements AlfrescoErrorContent {
    private String message;
    private String description;

    public static OAuthErrorContent parseJson(String errorContentValue) {
        Map<String, Object> json = null;
        try {
            json = JsonUtils.parseObject(errorContentValue);
        }
        catch (Exception e) {
            return null;
        }
        OAuthErrorContent errorContent = null;
        if (json.containsKey("error") || json.containsKey("error_description")) {
            errorContent = new OAuthErrorContent();
            errorContent.message = JSONConverter.getString(json, (String)"error");
            errorContent.description = JSONConverter.getString(json, (String)"error_description");
        }
        return errorContent;
    }

    @Override
    public int getCode() {
        return 401;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getStackTrace() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }
}

