/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.exceptions.impl;

import org.alfresco.mobile.android.api.exceptions.AlfrescoErrorContent;
import org.alfresco.mobile.android.api.exceptions.AlfrescoException;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.exceptions.AlfrescoSessionException;
import org.alfresco.mobile.android.api.exceptions.impl.CloudErrorContent;
import org.alfresco.mobile.android.api.exceptions.impl.OAuthErrorContent;
import org.alfresco.mobile.android.api.exceptions.impl.OnPremiseErrorContent;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;

public final class ExceptionHelper {
    private ExceptionHelper() {
    }

    public static void convertException(Exception exception) {
        try {
            throw exception;
        }
        catch (AlfrescoException e) {
            throw e;
        }
        catch (CmisUnauthorizedException e) {
            throw new AlfrescoServiceException(3, (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            if (e.getErrorContent() != null && e.getErrorContent().contains("cannot be null or empty.")) {
                throw new IllegalArgumentException(e);
            }
            if (e.getErrorContent() != null && e.getErrorContent().contains("Access is denied.")) {
                throw new AlfrescoServiceException(3, (Throwable)e);
            }
            throw new AlfrescoServiceException(0, (Throwable)e);
        }
        catch (CmisConstraintException e) {
            if (e.getMessage().contains("Conflict")) {
                throw new AlfrescoServiceException(601, (Throwable)e);
            }
            throw new IllegalArgumentException(e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new AlfrescoServiceException(2, (Throwable)e);
        }
        catch (CmisContentAlreadyExistsException e) {
            throw new AlfrescoServiceException(601, (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new AlfrescoServiceException(3, (Throwable)e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CmisBaseException cmisException) {
            throw new AlfrescoServiceException(0, (Throwable)cmisException);
        }
        catch (Exception e) {
            throw new AlfrescoServiceException(0, (Throwable)e);
        }
    }

    public static void convertStatusCode(AlfrescoSession session, Response resp, int serviceErrorCode) {
        AlfrescoErrorContent er = null;
        if (session instanceof RepositorySession) {
            if (resp.getResponseCode() == 401) {
                throw new CmisUnauthorizedException();
            }
            try {
                er = OnPremiseErrorContent.parseJson(resp.getErrorContent());
            }
            catch (Exception ee) {
                er = null;
            }
        } else if (session instanceof CloudSession || session == null) {
            if (resp.getResponseCode() == 401) {
                er = OAuthErrorContent.parseJson(resp.getErrorContent());
            } else {
                if (resp.getResponseCode() == 400 && session == null) {
                    throw new AlfrescoSessionException(serviceErrorCode, OAuthErrorContent.parseJson(resp.getErrorContent()));
                }
                if (resp.getResponseCode() == 503 && session == null) {
                    throw new AlfrescoSessionException(1, "503 " + resp.getErrorContent());
                }
            }
            if (er == null) {
                try {
                    er = CloudErrorContent.parseJson(resp.getErrorContent());
                    if (er == null) {
                        er = OnPremiseErrorContent.parseJson(resp.getErrorContent());
                    }
                }
                catch (Exception e) {
                    try {
                        er = OnPremiseErrorContent.parseJson(resp.getErrorContent());
                    }
                    catch (Exception ee) {
                        er = null;
                    }
                }
            }
        }
        if (er != null) {
            if (er instanceof OAuthErrorContent) {
                throw new AlfrescoSessionException(104, er);
            }
            throw new AlfrescoServiceException(serviceErrorCode, er);
        }
        throw new AlfrescoServiceException(serviceErrorCode, resp.getErrorContent());
    }
}

