/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.exceptions.impl;

import java.math.BigInteger;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoErrorContent;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class CloudErrorContent
implements AlfrescoErrorContent {
    private int code;
    private String message;
    private String callstack;
    private String descriptionURL;

    public static CloudErrorContent parseJson(String errorContentValue) {
        Map json = null;
        try {
            json = JsonUtils.parseObject(errorContentValue);
            json = (Map)json.get("error");
        }
        catch (Exception e) {
            return null;
        }
        CloudErrorContent errorContent = new CloudErrorContent();
        BigInteger code = JSONConverter.getInteger((Map)json, (String)"statusCode");
        if (code == null) {
            return null;
        }
        errorContent.code = code.intValue();
        errorContent.message = JSONConverter.getString((Map)json, (String)"briefSummary");
        errorContent.callstack = JSONConverter.getString((Map)json, (String)"stackTrace");
        errorContent.descriptionURL = JSONConverter.getString((Map)json, (String)"descriptionURL");
        return errorContent;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getStackTrace() {
        return this.callstack;
    }

    public String getDescriptionURL() {
        return this.descriptionURL;
    }
}

