/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.constants;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.mobile.android.api.constants.ContentModel;

public class ModelMappingUtils {
    public static final String CMISPREFIX_ASPECTS = "P:";
    public static final String CMISPREFIX_DOCUMENT = "D:";
    public static final String CMISPREFIX_FOLDER = "F:";
    public static final Set<String> CMISMODEL_KEYS = new HashSet<String>();
    public static final Map<String, String> ALFRESCO_TO_CMIS;
    public static final Map<String, String> CMIS_TO_ALFRESCO;
    public static final Map<String, String> ALFRESCO_ASPECTS;

    private ModelMappingUtils() {
    }

    public static String getPropertyName(String name) {
        String tmpName = name;
        if (ALFRESCO_TO_CMIS.containsKey(tmpName)) {
            tmpName = ALFRESCO_TO_CMIS.get(tmpName);
        }
        return tmpName;
    }

    public static String getAlfrescoPropertyName(String name) {
        String tmpName = name;
        if (CMIS_TO_ALFRESCO.containsKey(tmpName)) {
            tmpName = CMIS_TO_ALFRESCO.get(tmpName);
        }
        return tmpName;
    }

    static {
        CMISMODEL_KEYS.add("cmis:name");
        CMISMODEL_KEYS.add("cmis:objectId");
        CMISMODEL_KEYS.add("cmis:objectTypeId");
        CMISMODEL_KEYS.add("cmis:baseTypeId");
        CMISMODEL_KEYS.add("cmis:createdBy");
        CMISMODEL_KEYS.add("cmis:creationDate");
        CMISMODEL_KEYS.add("cmis:lastModifiedBy");
        CMISMODEL_KEYS.add("cmis:lastModificationDate");
        CMISMODEL_KEYS.add("cmis:changeToken");
        CMISMODEL_KEYS.add("cmis:isImmutable");
        CMISMODEL_KEYS.add("cmis:isLatestVersion");
        CMISMODEL_KEYS.add("cmis:isMajorVersion");
        CMISMODEL_KEYS.add("cmis:isLatestMajorVersion");
        CMISMODEL_KEYS.add("cmis:versionLabel");
        CMISMODEL_KEYS.add("cmis:versionSeriesId");
        CMISMODEL_KEYS.add("cmis:isVersionSeriesCheckedOut");
        CMISMODEL_KEYS.add("cmis:versionSeriesCheckedOutBy");
        CMISMODEL_KEYS.add("cmis:versionSeriesCheckedOutId");
        CMISMODEL_KEYS.add("cmis:checkinComment");
        CMISMODEL_KEYS.add("cmis:contentStreamLength");
        CMISMODEL_KEYS.add("cmis:contentStreamMimeType");
        CMISMODEL_KEYS.add("cmis:contentStreamFileName");
        CMISMODEL_KEYS.add("cmis:contentStreamId");
        CMISMODEL_KEYS.add("cmis:parentId");
        CMISMODEL_KEYS.add("cmis:allowedChildObjectTypeIds");
        CMISMODEL_KEYS.add("cmis:sourceId");
        CMISMODEL_KEYS.add("cmis:targetId");
        CMISMODEL_KEYS.add("cmis:policyText");
        ALFRESCO_TO_CMIS = new HashMap<String, String>();
        ALFRESCO_TO_CMIS.put(ContentModel.PROP_NAME, "cmis:name");
        ALFRESCO_TO_CMIS.put(ContentModel.PROP_CREATED, "cmis:creationDate");
        ALFRESCO_TO_CMIS.put(ContentModel.PROP_CREATOR, "cmis:createdBy");
        ALFRESCO_TO_CMIS.put(ContentModel.PROP_MODIFIED, "cmis:lastModificationDate");
        ALFRESCO_TO_CMIS.put(ContentModel.PROP_MODIFIER, "cmis:lastModifiedBy");
        ALFRESCO_TO_CMIS.put(ContentModel.PROP_VERSION_LABEL, "cmis:versionLabel");
        ALFRESCO_TO_CMIS.put("size", "cmis:contentStreamLength");
        ALFRESCO_TO_CMIS.put("mimetype", "cmis:contentStreamMimeType");
        ALFRESCO_TO_CMIS.put("path", "cmis:path");
        CMIS_TO_ALFRESCO = new HashMap<String, String>();
        CMIS_TO_ALFRESCO.put("cmis:name", ContentModel.PROP_NAME);
        CMIS_TO_ALFRESCO.put("cmis:creationDate", ContentModel.PROP_CREATED);
        CMIS_TO_ALFRESCO.put("cmis:createdBy", ContentModel.PROP_CREATOR);
        CMIS_TO_ALFRESCO.put("cmis:lastModificationDate", ContentModel.PROP_MODIFIED);
        CMIS_TO_ALFRESCO.put("cmis:lastModifiedBy", ContentModel.PROP_MODIFIER);
        CMIS_TO_ALFRESCO.put("cmis:versionLabel", ContentModel.PROP_VERSION_LABEL);
        CMIS_TO_ALFRESCO.put("cmis:contentStreamLength", "size");
        CMIS_TO_ALFRESCO.put("cmis:contentStreamMimeType", "mimetype");
        CMIS_TO_ALFRESCO.put("cmis:path", "path");
        ALFRESCO_ASPECTS = new HashMap<String, String>();
        ALFRESCO_ASPECTS.put(ContentModel.PROP_TITLE, CMISPREFIX_ASPECTS + ContentModel.ASPECT_TITLED);
        ALFRESCO_ASPECTS.put(ContentModel.PROP_DESCRIPTION, CMISPREFIX_ASPECTS + ContentModel.ASPECT_TITLED);
        ALFRESCO_ASPECTS.put(ContentModel.PROP_TAGS, CMISPREFIX_ASPECTS + ContentModel.ASPECT_TAGGABLE);
        for (String prop : ContentModel.ASPECT_GEOGRAPHIC_PROPS) {
            ALFRESCO_ASPECTS.put(prop, CMISPREFIX_ASPECTS + ContentModel.ASPECT_GEOGRAPHIC);
        }
        for (String prop : ContentModel.ASPECT_EXIF_PROPS) {
            ALFRESCO_ASPECTS.put(prop, CMISPREFIX_ASPECTS + ContentModel.ASPECT_EXIF);
        }
        for (String prop : ContentModel.ASPECT_AUDIO_PROPS) {
            ALFRESCO_ASPECTS.put(prop, CMISPREFIX_ASPECTS + ContentModel.ASPECT_AUDIO);
        }
        ALFRESCO_ASPECTS.put(ContentModel.PROP_AUTHOR, CMISPREFIX_ASPECTS + ContentModel.ASPECT_AUTHOR);
        for (String prop : ContentModel.ASPECT_RESTRICTABLE_PROPS) {
            ALFRESCO_ASPECTS.put(prop, CMISPREFIX_ASPECTS + ContentModel.ASPECT_RESTRICTABLE);
        }
    }
}

