/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.awe.tag;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.web.awe.tag.MarkedContent;

public class AlfrescoTagUtil {
    public static final String KEY_MARKER_ID_PREFIX = "awe_marker_id_prefix";
    public static final String KEY_EDITABLE_CONTENT = "awe_editable_content";

    public static List<MarkedContent> getMarkedContent(ServletRequest request) {
        ArrayList markedContent = (ArrayList)request.getAttribute(KEY_EDITABLE_CONTENT);
        if (markedContent == null) {
            markedContent = new ArrayList();
            request.setAttribute(KEY_EDITABLE_CONTENT, markedContent);
        }
        return markedContent;
    }

    public static void writeMarkContentHtml(Writer out, String urlPrefix, String redirectUrl, MarkedContent content) throws IOException, UnsupportedEncodingException {
        String contentId = content.getContentId();
        String contentTitle = content.getContentTitle();
        String formId = content.getFormId();
        String editMarkerId = content.getMarkerId();
        out.write("<span class=\"alfresco-content-marker\" style=\"display: none\" id=\"");
        out.write(editMarkerId);
        out.write("\">");
        out.write("<a class=\"alfresco-content-edit\" href=\"");
        out.write(urlPrefix);
        out.write("/page/metadata?nodeRef=");
        out.write(contentId);
        out.write("&js=off");
        if (contentTitle != null) {
            out.write("&title=");
            out.write(URLEncoder.encode(contentTitle, "UTF-8"));
        }
        if (redirectUrl != null) {
            out.write("&redirect=");
            out.write(redirectUrl);
        }
        if (formId != null) {
            out.write("&formId=");
            out.write(formId);
        }
        out.write("\"><img src=\"");
        out.write(urlPrefix);
        out.write("/res/awe/images/edit.png\" alt=\"");
        out.write(AlfrescoTagUtil.encode(contentTitle == null ? "" : contentTitle));
        out.write("\" title=\"");
        out.write(AlfrescoTagUtil.encode(contentTitle == null ? "" : contentTitle));
        out.write("\"border=\"0\" /></a>");
        out.write("<a class=\"alfresco-content-new\" href=\"");
        out.write(urlPrefix);
        out.write("/page/metadata?nodeRef=");
        out.write(contentId);
        out.write("&js=off");
        if (contentTitle != null) {
            out.write("&title=");
            out.write(URLEncoder.encode(contentTitle, "UTF-8"));
        }
        if (redirectUrl != null) {
            out.write("&redirect=");
            out.write(redirectUrl);
        }
        if (formId != null) {
            out.write("&formId=");
            out.write(formId);
        }
        out.write("\"><img src=\"");
        out.write(urlPrefix);
        out.write("/res/awe/images/new.png\" alt=\"");
        out.write(AlfrescoTagUtil.encode(contentTitle == null ? "" : contentTitle));
        out.write("\" title=\"");
        out.write(AlfrescoTagUtil.encode(contentTitle == null ? "" : contentTitle));
        out.write("\"border=\"0\" /></a>");
        out.write("<a class=\"alfresco-content-delete\" href=\"");
        out.write(urlPrefix);
        out.write("/page/metadata?nodeRef=");
        out.write(contentId);
        out.write("&js=off");
        if (contentTitle != null) {
            out.write("&title=");
            out.write(URLEncoder.encode(contentTitle, "UTF-8"));
        }
        if (redirectUrl != null) {
            out.write("&redirect=");
            out.write(redirectUrl);
        }
        if (formId != null) {
            out.write("&formId=");
            out.write(formId);
        }
        out.write("\"><img src=\"");
        out.write(urlPrefix);
        out.write("/res/awe/images/delete.png\" alt=\"");
        out.write(AlfrescoTagUtil.encode(contentTitle == null ? "" : contentTitle));
        out.write("\" title=\"");
        out.write(AlfrescoTagUtil.encode(contentTitle == null ? "" : contentTitle));
        out.write("\"border=\"0\" /></a>");
        out.write("</span>\n");
    }

    public static String calculateRedirectUrl(HttpServletRequest request) {
        String redirectUrl = null;
        try {
            StringBuffer url = request.getRequestURL();
            String queryString = request.getQueryString();
            if (queryString != null) {
                url.append("?").append(queryString);
            }
            redirectUrl = URLEncoder.encode(url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return redirectUrl;
    }

    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 16);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }
}

