/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of the Alfresco Web Quick Start module.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import org.alfresco.service.cmr.transfer.NodeCrawler;

public class WqsNodeCrawlerConfigurerImpl implements NodeCrawlerConfigurer
{
    @Override
    public void configure(NodeCrawler crawler)
    {
        crawler.setNodeFilters(new ExistingNodeFilter(),
                new CheckedOutNodeFilter());
        crawler.setNodeFinders(
                new IndexPageSectionFinder(),
                new CriticalSectionInfoFinder(),
                new WebAssetCollectionPublishingFinder(),
                new ArticleImageFinder(),
                new RenditionsFinder());
    }
}
