/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializer;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializerFactory;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.SiteHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class SectionGet
extends AbstractWebScript {
    private static final String PARAM_MODIFIED_TIME_ONLY = "modifiedTimeOnly";
    private static final String PARAM_SECTION_ID = "sectionId";
    private static final String PARAM_SITE_ID = "siteId";
    private static final String PARAM_INCLUDE_CHILDREN = "includeChildren";
    private static final QName PROP_PARENT_ID = QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"parentId");
    private NodeService nodeService;
    private SearchService searchService;
    private AssetSerializerFactory assetSerializerFactory;
    private SiteHelper siteHelper;
    private NamespaceService namespaceService;

    public void setAssetSerializerFactory(AssetSerializerFactory assetSerializerFactory) {
        this.assetSerializerFactory = assetSerializerFactory;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSiteHelper(SiteHelper siteHelper) {
        this.siteHelper = siteHelper;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            ArrayList<NodeRef> foundNodes = new ArrayList<NodeRef>(50);
            HashSet<NodeRef> foundNodesSet = new HashSet<NodeRef>(179);
            String[] sectionIds = req.getParameterValues(PARAM_SECTION_ID);
            boolean onlyModifiedTime = req.getParameter(PARAM_MODIFIED_TIME_ONLY) != null;
            boolean includeChildren = req.getParameter(PARAM_INCLUDE_CHILDREN) != null;
            String siteIdText = req.getParameter(PARAM_SITE_ID);
            if (sectionIds == null || sectionIds.length == 0) {
                res.setStatus(400);
                throw new WebScriptException("sectionid is a required parameter");
            }
            NodeRef siteId = null;
            siteId = siteIdText == null ? this.siteHelper.getRelevantWebSite(new NodeRef(sectionIds[0])) : new NodeRef(siteIdText);
            for (String nodeRefString : sectionIds) {
                try {
                    NodeRef nodeRef = new NodeRef(nodeRefString);
                    if (!this.nodeService.exists(nodeRef) || this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_UUID) == null || foundNodesSet.contains(nodeRef)) continue;
                    foundNodesSet.add(nodeRef);
                    foundNodes.add(nodeRef);
                    if (!includeChildren) continue;
                    List<NodeRef> descendants = this.findDescendants(siteId, nodeRef);
                    for (NodeRef descendant : descendants) {
                        if (foundNodesSet.contains(descendant)) continue;
                        foundNodesSet.add(descendant);
                        foundNodes.add(descendant);
                    }
                }
                catch (Exception nodeRef) {
                    // empty catch block
                }
            }
            res.setContentEncoding("UTF-8");
            Writer writer = res.getWriter();
            AssetSerializer assetSerializer = this.assetSerializerFactory.getAssetSerializer();
            res.setContentType(assetSerializer.getMimeType());
            assetSerializer.start(writer);
            for (NodeRef nodeRef : foundNodes) {
                Map<QName, Serializable> properties;
                QName typeName = this.nodeService.getType(nodeRef);
                if (onlyModifiedTime) {
                    properties = new HashMap(3);
                    properties.put(ContentModel.PROP_MODIFIED, this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED));
                } else {
                    properties = this.nodeService.getProperties(nodeRef);
                    properties.put(PROP_PARENT_ID, (Serializable)this.nodeService.getPrimaryParent(nodeRef).getParentRef());
                }
                assetSerializer.writeNode(nodeRef, typeName, properties);
            }
            assetSerializer.end();
        }
        catch (Throwable e) {
            throw this.createStatusException(e, req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeRef> findDescendants(NodeRef siteId, NodeRef rootSectionId) {
        ArrayList<NodeRef> foundNodes = new ArrayList<NodeRef>(200);
        String query = "+PATH:\"" + this.nodeService.getPath(siteId).toPrefixString((NamespacePrefixResolver)this.namespaceService) + "//*\" +TYPE:\"" + WebSiteModel.TYPE_SECTION + "\" +@ws\\:ancestorSections:\"" + rootSectionId + "\"";
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        searchParameters.setLanguage("lucene");
        searchParameters.setQuery(query);
        searchParameters.addSort("@" + WebSiteModel.PROP_ORDER_INDEX.toString(), true);
        try (ResultSet rs = null;){
            rs = this.searchService.query(searchParameters);
            for (ResultSetRow row : rs) {
                foundNodes.add(row.getNodeRef());
            }
            ArrayList<NodeRef> arrayList = foundNodes;
            return arrayList;
        }
    }
}

