/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.AssetCollectionDefinition;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.SectionHierarchyProcessor;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.PublishService;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser.ContextParserService;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionType
extends TransactionListenerAdapter
implements WebSiteModel {
    private static final String AFFECTED_CHILD_ASSOCS = "AFFECTED_CHILD_ASSOCS";
    private static final String COPY_NODES = "COPY_NODES";
    private static final Log log = LogFactory.getLog(SectionType.class);
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private PublishService publishService;
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private FileFolderService fileFolderService;
    private RenditionService renditionService;
    private TransactionService transactionService;
    private ContextParserService contextParserService;
    private NamespaceService namespaceService;
    private MimetypeMap mimetypeMap;
    private SectionHierarchyProcessor sectionHierarchyProcessor;
    private String sectionIndexPageName = "index.html";
    private String sectionCollectionsFolderName = "collections";
    private List<AssetCollectionDefinition> collectionDefinitions = Collections.emptyList();
    private Set<String> typesToIgnore = new TreeSet<String>();

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setFileFolderService(FileFolderService fileFolderSevice) {
        this.fileFolderService = fileFolderSevice;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setMimetypeMap(MimetypeMap mimetypeMap) {
        this.mimetypeMap = mimetypeMap;
    }

    public void setSectionIndexPageName(String sectionIndexPageName) {
        this.sectionIndexPageName = sectionIndexPageName;
    }

    public void setSectionCollectionsFolderName(String sectionCollectionsFolderName) {
        this.sectionCollectionsFolderName = sectionCollectionsFolderName;
    }

    public void setContextParserService(ContextParserService contextParserService) {
        this.contextParserService = contextParserService;
    }

    public void setSectionHierarchyProcessor(SectionHierarchyProcessor sectionHierarchyProcessor) {
        this.sectionHierarchyProcessor = sectionHierarchyProcessor;
    }

    public void setTypesToIgnore(Set<String> typesToIgnore) {
        this.typesToIgnore = typesToIgnore;
    }

    public void setAssetCollectionDefinitions(List<AssetCollectionDefinition> collectionDefinitions) {
        this.collectionDefinitions = collectionDefinitions == null ? Collections.emptyList() : collectionDefinitions;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, WebSiteModel.TYPE_SECTION, (Behaviour)new JavaBehaviour((Object)this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, WebSiteModel.TYPE_SECTION, (Behaviour)new JavaBehaviour((Object)this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentPropertyUpdatePolicy.QNAME, WebSiteModel.TYPE_SECTION, (Behaviour)new JavaBehaviour((Object)this, "onContentPropertyUpdate"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, WebSiteModel.TYPE_SECTION, (Behaviour)new JavaBehaviour((Object)this, "getCopyCallback", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, WebSiteModel.TYPE_SECTION, ContentModel.ASSOC_CONTAINS, (Behaviour)new JavaBehaviour((Object)this, "onCreateChildAssociationEveryEvent", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, WebSiteModel.TYPE_SECTION, ContentModel.ASSOC_CONTAINS, (Behaviour)new JavaBehaviour((Object)this, "onCreateChildAssociationTransactionCommit", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteChildAssociationPolicy.QNAME, WebSiteModel.TYPE_SECTION, ContentModel.ASSOC_CONTAINS, (Behaviour)new JavaBehaviour((Object)this, "onDeleteChildAssociationEveryEvent", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteChildAssociationPolicy.QNAME, WebSiteModel.TYPE_SECTION, ContentModel.ASSOC_CONTAINS, (Behaviour)new JavaBehaviour((Object)this, "onDeleteChildAssociationTransactionCommit", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
    }

    public void onCreateChildAssociationEveryEvent(ChildAssociationRef childAssoc, boolean isNewNode) {
        NodeRef childNode;
        QName childNodeType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("onCreateChildAssociationEveryEvent: ref == " + childAssoc + "; newNode == " + isNewNode));
        }
        if (ContentModel.TYPE_FOLDER.equals((Object)(childNodeType = this.nodeService.getType(childNode = childAssoc.getChildRef())))) {
            this.nodeService.setType(childNode, TYPE_SECTION);
            this.processCreateNode(childNode);
        }
        this.recordAffectedChild(childAssoc);
    }

    public void onCreateChildAssociationTransactionCommit(ChildAssociationRef childAssoc, boolean isNewNode) {
        this.processCommit(childAssoc);
    }

    public void onDeleteChildAssociationEveryEvent(ChildAssociationRef childAssoc) {
        this.recordAffectedChild(childAssoc);
    }

    public void onDeleteChildAssociationTransactionCommit(ChildAssociationRef childAssoc) {
        this.processCommit(childAssoc);
    }

    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        HashSet<NodeRef> copyNodeRefs = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource((Object)COPY_NODES);
        if (copyNodeRefs == null) {
            copyNodeRefs = new HashSet<NodeRef>(89);
            AlfrescoTransactionSupport.bindResource((Object)COPY_NODES, copyNodeRefs);
        }
        copyNodeRefs.add(copyDetails.getTargetNodeRef());
        return DefaultCopyBehaviourCallback.getInstance();
    }

    private void recordAffectedChild(ChildAssociationRef childAssoc) {
        HashSet<ChildAssociationRef> affectedChildAssocs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recording affected child of section " + childAssoc.getParentRef() + ":  " + childAssoc.getChildRef()));
        }
        if ((affectedChildAssocs = (HashSet<ChildAssociationRef>)AlfrescoTransactionSupport.getResource((Object)AFFECTED_CHILD_ASSOCS)) == null) {
            affectedChildAssocs = new HashSet<ChildAssociationRef>();
            AlfrescoTransactionSupport.bindResource((Object)AFFECTED_CHILD_ASSOCS, affectedChildAssocs);
        }
        affectedChildAssocs.add(childAssoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommit(ChildAssociationRef childNodeAssoc) {
        Set affectedNodeRefs = (Set)AlfrescoTransactionSupport.getResource((Object)AFFECTED_CHILD_ASSOCS);
        Set copyNodeRefs = (Set)AlfrescoTransactionSupport.getResource((Object)COPY_NODES);
        HashSet<NodeRef> affectedSections = new HashSet<NodeRef>();
        if (affectedNodeRefs != null && affectedNodeRefs.remove(childNodeAssoc)) {
            NodeRef childNode = childNodeAssoc.getChildRef();
            NodeRef parentNode = childNodeAssoc.getParentRef();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing commit of section child:  " + childNode));
            }
            if (this.nodeService.exists(childNode)) {
                if (copyNodeRefs == null || !copyNodeRefs.contains(parentNode)) {
                    String mimetype;
                    ContentReader reader;
                    QName childNodeType = this.nodeService.getType(childNode);
                    if (ContentModel.TYPE_CONTENT.equals((Object)childNodeType) && !this.typesToIgnore.contains(childNodeType.toPrefixString((NamespacePrefixResolver)this.namespaceService)) && (reader = this.contentService.getReader(childNode, ContentModel.PROP_CONTENT)) != null && reader.exists() && (mimetype = reader.getMimetype()) != null && mimetype.trim().length() != 0) {
                        if (this.isImageMimetype(reader.getMimetype())) {
                            this.nodeService.setType(childNode, TYPE_IMAGE);
                        } else if (this.mimetypeMap.isText(reader.getMimetype())) {
                            this.nodeService.setType(childNode, TYPE_ARTICLE);
                        }
                    }
                    if (this.dictionaryService.isSubClass(childNodeType, ContentModel.TYPE_CONTENT) && !this.typesToIgnore.contains(childNodeType.toPrefixString((NamespacePrefixResolver)this.namespaceService))) {
                        this.nodeService.addAspect(childNode, ASPECT_WEBASSET, null);
                    }
                }
                boolean childIsWebAsset = this.nodeService.hasAspect(childNode, ASPECT_WEBASSET);
                boolean childIsSection = this.dictionaryService.isSubClass(this.nodeService.getType(childNode), WebSiteModel.TYPE_SECTION);
                if (childIsSection) {
                    affectedSections.add(childNode);
                }
                if (childIsWebAsset) {
                    List parentAssocs = this.nodeService.getParentAssocs(childNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                    ArrayList<NodeRef> parentSections = new ArrayList<NodeRef>(parentAssocs.size());
                    HashSet<NodeRef> ancestorSections = new HashSet<NodeRef>();
                    for (ChildAssociationRef assoc : parentAssocs) {
                        NodeRef parent = assoc.getParentRef();
                        if (!this.dictionaryService.isSubClass(this.nodeService.getType(parent), WebSiteModel.TYPE_SECTION)) continue;
                        parentSections.add(parent);
                        Collection ancestors = (Collection)((Object)this.nodeService.getProperty(parent, PROP_ANCESTOR_SECTIONS));
                        if (ancestors == null) continue;
                        ancestorSections.addAll(ancestors);
                    }
                    try {
                        this.behaviourFilter.disableBehaviour(childNode, ASPECT_WEBASSET);
                        this.behaviourFilter.disableBehaviour(childNode, ContentModel.ASPECT_AUDITABLE);
                        ancestorSections.addAll(parentSections);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Section child is a web asset (" + childNode + "). Setting parent section ids:  " + parentSections));
                        }
                        this.nodeService.setProperty(childNode, PROP_PARENT_SECTIONS, parentSections);
                        this.nodeService.setProperty(childNode, PROP_ANCESTOR_SECTIONS, new ArrayList(ancestorSections));
                    }
                    finally {
                        this.behaviourFilter.enableBehaviour(childNode, ContentModel.ASPECT_AUDITABLE);
                        this.behaviourFilter.enableBehaviour(childNode, ASPECT_WEBASSET);
                    }
                }
            }
        }
        if (!affectedSections.isEmpty()) {
            AlfrescoTransactionSupport.bindListener((TransactionListener)new SectionCommitTransactionListener(affectedSections));
        }
    }

    public RenditionDefinition cloneRenditionDefinition(RenditionDefinition source, NodeRef context) {
        RenditionDefinition clone = this.renditionService.createRenditionDefinition(source.getRenditionName(), source.getActionDefinitionName());
        clone.setExecuteAsynchronously(source.getExecuteAsychronously());
        clone.setParameterValues(source.getParameterValues());
        String pathTemplate = (String)((Object)source.getParameterValue("destination-path-template"));
        if (pathTemplate != null) {
            String resolvedPath = this.contextParserService.parse(context, pathTemplate);
            clone.setParameterValue("destination-path-template", (Serializable)((Object)resolvedPath));
        }
        return clone;
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onCreateNode " + childAssocRef));
        }
        this.processCreateNode(childAssocRef.getChildRef());
        this.recordAffectedChild(childAssocRef);
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        this.publishService.enqueueRemovedNodes(nodeRef);
    }

    public void processCreateNode(NodeRef section) {
        Set copyNodeRefs = (Set)AlfrescoTransactionSupport.getResource((Object)COPY_NODES);
        if (copyNodeRefs != null && copyNodeRefs.contains(section)) {
            return;
        }
        FileInfo indexPage = this.fileFolderService.create(section, this.sectionIndexPageName, TYPE_INDEX_PAGE);
        ContentWriter writer = this.fileFolderService.getWriter(indexPage.getNodeRef());
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/html");
        writer.putContent("");
        this.nodeService.addAspect(indexPage.getNodeRef(), ASPECT_WEBASSET, null);
        this.recordAffectedChild(this.nodeService.getPrimaryParent(indexPage.getNodeRef()));
        FileInfo collectionFolder = this.fileFolderService.create(section, this.sectionCollectionsFolderName, TYPE_WEBASSET_COLLECTION_FOLDER);
        for (AssetCollectionDefinition collectionDef : this.collectionDefinitions) {
            HashMap<QName, Object> props = new HashMap<QName, Object>();
            props.put(ContentModel.PROP_NAME, collectionDef.getName());
            props.put(ContentModel.PROP_TITLE, collectionDef.getTitle());
            if (collectionDef.getQuery() != null) {
                props.put(WebSiteModel.PROP_QUERY, collectionDef.getQuery());
                props.put(WebSiteModel.PROP_QUERY_LANGUAGE, collectionDef.getQueryType().getEngineName());
                props.put(WebSiteModel.PROP_QUERY_RESULTS_MAX_SIZE, collectionDef.getMaxResults());
                props.put(WebSiteModel.PROP_MINS_TO_QUERY_REFRESH, collectionDef.getQueryIntervalMinutes());
            }
            this.nodeService.createNode(collectionFolder.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)collectionDef.getName()), WebSiteModel.TYPE_WEBASSET_COLLECTION, props);
        }
    }

    public void onContentPropertyUpdate(NodeRef nodeRef, QName propertyQName, ContentData beforeValue, ContentData afterValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onContentPropertyUpdate: " + nodeRef + ";  " + propertyQName + ";  " + afterValue.toString()));
        }
    }

    private boolean isImageMimetype(String mimetype) {
        return mimetype.startsWith("image");
    }

    private class SectionCommitTransactionListener
    extends TransactionListenerAdapter {
        private Set<NodeRef> sectionsToProcess = null;

        public SectionCommitTransactionListener(Set<NodeRef> affectedSections) {
            this.sectionsToProcess = affectedSections;
        }

        public void afterCommit() {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    SectionType.this.sectionHierarchyProcessor.process(SectionCommitTransactionListener.this.sectionsToProcess);
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){
                final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$work;
                {
                    this.val$work = retryingTransactionCallback;
                }

                public Object doWork() throws Exception {
                    SectionType.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.val$work, false, true);
                    return null;
                }
            }, (String)"System");
        }
    }
}

