/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.jobs;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.WebassetCollectionHelper;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicCollectionProcessor
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(DynamicCollectionProcessor.class);
    private static final String QUERY = "+ TYPE:\"ws:webassetCollection\" + @ws\\:isDynamic:true";
    private static final long LOCK_TTL = 60000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.DynamicCollectionProcessor");
    private TransactionService transactionService;
    private NodeService nodeService;
    private SearchService searchService;
    private WebassetCollectionHelper collectionHelper;
    private RepositoryState repositoryState;
    private JobLockService jobLockService;

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setRepositoryState(RepositoryState repositoryState) {
        this.repositoryState = repositoryState;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setCollectionHelper(WebassetCollectionHelper collectionHelper) {
        this.collectionHelper = collectionHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.repositoryState.isBootstrapping()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DynamicCollection processor can not be executed while the repository is bootstrapping");
            }
            return;
        }
        LockCallback lockCallback = new LockCallback();
        String lockToken = null;
        try {
            lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
            if (lockToken == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Can't get lock : " + LOCK_QNAME));
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities dynamicCollection processor started");
            }
            this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, (JobLockService.JobLockRefreshCallback)lockCallback);
            this.runInternal();
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities dynamicCollection processor completed");
            }
        }
        catch (LockAcquisitionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities dynamicCollection processor already underway");
            }
        }
        catch (VmShutdownListener.VmShutdownException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities dynamicCollection processor aborted");
            }
        }
        finally {
            lockCallback.running.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    private void runInternal() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                DynamicCollectionProcessor.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object execute() throws Throwable {
                        try (ResultSet rs = null;){
                            rs = DynamicCollectionProcessor.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", DynamicCollectionProcessor.QUERY);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Running dynamic collection refresh processor across " + rs.length() + " dynamic collection nodes"));
                            }
                            Calendar now = Calendar.getInstance();
                            for (NodeRef collection : rs.getNodeRefs()) {
                                String collectionName;
                                Date refreshAtDate = (Date)DynamicCollectionProcessor.this.nodeService.getProperty(collection, WebSiteModel.PROP_REFRESH_AT);
                                Calendar refreshAt = Calendar.getInstance();
                                if (refreshAtDate != null) {
                                    refreshAt.setTime(refreshAtDate);
                                }
                                if (refreshAtDate != null && !now.after(refreshAt)) continue;
                                if (log.isDebugEnabled() && (collectionName = (String)((Object)DynamicCollectionProcessor.this.nodeService.getProperty(collection, ContentModel.PROP_NAME))) != null) {
                                    log.debug((Object)("Refreshing dynamic collection " + collectionName));
                                }
                                DynamicCollectionProcessor.this.collectionHelper.refreshCollection(collection);
                            }
                        }
                        return null;
                    }
                });
                return null;
            }
        }, (String)"System");
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback() {
        }

        public boolean isActive() {
            return this.running.get();
        }

        public void lockReleased() {
            this.running.set(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock released : " + LOCK_QNAME));
            }
        }
    }
}

