/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser.ContextParserService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebassetCollectionHelper
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(WebassetCollectionHelper.class);
    private NodeService nodeService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private ContextParserService contextParserService;
    private String searchStore = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchStore(String searchStore) {
        this.searchStore = searchStore;
    }

    public void setContextParserService(ContextParserService contextParserService) {
        this.contextParserService = contextParserService;
    }

    public void clearCollection(NodeRef collection) {
        List assocs = this.nodeService.getTargetAssocs(collection, (QNamePattern)ASSOC_WEBASSETS);
        for (AssociationRef assoc : assocs) {
            this.nodeService.removeAssociation(collection, assoc.getTargetRef(), ASSOC_WEBASSETS);
        }
        this.nodeService.removeProperty(collection, PROP_CONTAINED_ASSETS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCollection(NodeRef collection) {
        String queryLanguage = (String)((Object)this.nodeService.getProperty(collection, PROP_QUERY_LANGUAGE));
        String query = (String)((Object)this.nodeService.getProperty(collection, PROP_QUERY));
        Integer minsToRefresh = (Integer)this.nodeService.getProperty(collection, PROP_MINS_TO_QUERY_REFRESH);
        minsToRefresh = minsToRefresh == null ? 30 : minsToRefresh;
        Integer maxQuerySize = (Integer)this.nodeService.getProperty(collection, PROP_QUERY_RESULTS_MAX_SIZE);
        maxQuerySize = maxQuerySize == null ? 5 : maxQuerySize;
        if (query != null && query.trim().length() != 0) {
            this.clearCollection(collection);
            query = this.contextParserService.parse(collection, query);
            SearchParameters searchParameters = new SearchParameters();
            if (queryLanguage.equals("lucene")) {
                String[] queryParts;
                for (String queryPart : queryParts = query.split("\\s")) {
                    QName property;
                    int firstColonIndex = queryPart.indexOf(58);
                    if (firstColonIndex == -1) continue;
                    String name = queryPart.substring(0, firstColonIndex);
                    String value = firstColonIndex < queryPart.length() + 1 ? queryPart.substring(firstColonIndex + 1) : "";
                    boolean orderAscending = "ORDER_ASC".equals(name) || "ORDER".equals(name);
                    boolean orderDescending = "ORDER_DESC".equals(name);
                    if (!orderAscending && !orderDescending || (property = this.parsePropertyName(value)) == null) continue;
                    String sort = "@" + property.toString();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding sort order: " + sort + (orderAscending ? " ASC" : " DESC")));
                    }
                    searchParameters.addSort(sort, orderAscending);
                }
            }
            searchParameters.addStore(new StoreRef(this.searchStore));
            searchParameters.setLanguage(queryLanguage);
            searchParameters.setMaxItems(maxQuerySize.intValue());
            searchParameters.setQuery(query);
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to run query for dynamic asset collection (" + collection + "): " + query));
            }
            try (ResultSet resultSet = null;){
                resultSet = this.searchService.query(searchParameters);
                int resultCount = 0;
                ArrayList<NodeRef> idList = new ArrayList<NodeRef>(maxQuerySize);
                for (NodeRef result : resultSet.getNodeRefs()) {
                    if (maxQuerySize >= 1 && resultCount >= maxQuerySize) break;
                    if (this.nodeService.hasAspect(result, ASPECT_WEBASSET)) {
                        this.nodeService.createAssociation(collection, result, ASSOC_WEBASSETS);
                    }
                    idList.add(result);
                    ++resultCount;
                }
                this.nodeService.setProperty(collection, PROP_CONTAINED_ASSETS, idList);
                Calendar now = Calendar.getInstance();
                now.add(12, minsToRefresh);
                this.nodeService.setProperty(collection, PROP_REFRESH_AT, (Serializable)now.getTime());
            }
        }
    }

    private QName parsePropertyName(String value) {
        QName result = null;
        try {
            char[] valueArray;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to parse property name: " + value));
            }
            StringBuilder sb = new StringBuilder();
            block5: for (char ch : valueArray = value.toCharArray()) {
                switch (ch) {
                    case '\"': {
                        continue block5;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            result = QName.createQName((String)sb.toString(), (NamespacePrefixResolver)this.namespaceService);
        }
        catch (InvalidQNameException invalidQNameException) {
            // empty catch block
        }
        return result;
    }
}

