/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.rendition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser.ContextParserService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.rendition.RenderCallback;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class RenditionHelper
implements WebSiteModel {
    private static final String CMIS_TYPE_DOCUMENT = "cmis:document";
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private RenditionService renditionService;
    private NamespaceService namespaceService;
    private ContextParserService contextParserService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setContextParserService(ContextParserService contextParserService) {
        this.contextParserService = contextParserService;
    }

    public void createRenditions(NodeRef nodeRef) {
        this.createRenditions(nodeRef, false);
    }

    public void createRenditions(NodeRef nodeRef, boolean clearRenditions) {
        if (this.nodeService.exists(nodeRef) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            String mimetype = null;
            ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
            if (reader != null && reader.getSize() != 0L) {
                NodeRef section = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                mimetype = reader.getMimetype();
                QName type = this.nodeService.getType(nodeRef).getPrefixedQName((NamespacePrefixResolver)this.namespaceService);
                if (clearRenditions) {
                    List renditions = this.renditionService.getRenditions(nodeRef);
                    for (ChildAssociationRef rendition : renditions) {
                        if (!"http://www.alfresco.org/model/website/1.0".equals(rendition.getQName().getNamespaceURI())) continue;
                        this.nodeService.deleteNode(rendition.getChildRef());
                    }
                }
                this.createRenditions(section, nodeRef, type, mimetype);
            }
        }
    }

    private void createRenditions(NodeRef section, NodeRef nodeRef, QName type, String mimetype) {
        Boolean inherit;
        Map<String, List<String>> renditionConfig = this.getRenditionConfig(section);
        if (!renditionConfig.isEmpty()) {
            this.createRenditions(nodeRef, renditionConfig.get(mimetype));
            this.createRenditions(nodeRef, this.getRenditionListForType(renditionConfig, type));
        }
        if (Boolean.TRUE.equals(inherit = (Boolean)this.nodeService.getProperty(section, PROP_INHERIT_RENDITION_CONFIG)) && !TYPE_WEB_SITE.equals((Object)type)) {
            NodeRef sectionParent = this.nodeService.getPrimaryParent(section).getParentRef();
            this.createRenditions(sectionParent, nodeRef, type, mimetype);
        }
    }

    private List<String> getRenditionListForType(Map<String, List<String>> renditionConfig, QName type) {
        ArrayList<String> result = new ArrayList<String>(7);
        if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT)) {
            QName parentType;
            TypeDefinition typeDef;
            String lookupType = this.getLookupType(type);
            List<String> temp = renditionConfig.get(lookupType);
            if (temp != null) {
                result.addAll(temp);
            }
            if (!ContentModel.TYPE_CONTENT.equals((Object)type) && (typeDef = this.dictionaryService.getType(type)) != null && (parentType = typeDef.getParentName()) != null && (temp = this.getRenditionListForType(renditionConfig, parentType)) != null) {
                result.addAll(temp);
            }
        }
        return result;
    }

    private String getLookupType(QName type) {
        String result = null;
        if (ContentModel.TYPE_CONTENT.equals((Object)type)) {
            result = CMIS_TYPE_DOCUMENT;
        } else {
            type = type.getPrefixedQName((NamespacePrefixResolver)this.namespaceService);
            result = type.getPrefixString();
        }
        return result;
    }

    private void createRenditions(NodeRef node, List<String> renditions) {
        if (renditions != null) {
            for (String renditionName : renditions) {
                QName finalRenditionQName;
                RenditionDefinition def;
                QName renditionQName = null;
                try {
                    renditionQName = QName.createQName((String)renditionName, (NamespacePrefixResolver)this.namespaceService);
                }
                catch (InvalidQNameException invalidQNameException) {
                    // empty catch block
                }
                if (renditionQName == null) {
                    renditionQName = QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)renditionName);
                }
                if (this.renditionService.getRenditionByName(node, renditionQName) != null || (def = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(finalRenditionQName = renditionQName){
                    final /* synthetic */ QName val$finalRenditionQName;
                    {
                        this.val$finalRenditionQName = qName;
                    }

                    public RenditionDefinition doWork() throws Exception {
                        return RenditionHelper.this.renditionService.loadRenditionDefinition(this.val$finalRenditionQName);
                    }
                }, (String)AuthenticationUtil.getSystemUserName())) == null) continue;
                String pathTemplate = (String)((Object)def.getParameterValue("destination-path-template"));
                if (pathTemplate != null) {
                    pathTemplate = this.contextParserService.parse(node, pathTemplate);
                    def.setParameterValue("destination-path-template", (Serializable)((Object)pathTemplate));
                }
                final RenditionDefinition callbackDef = def;
                RenderCallback renderCallback = new RenderCallback(){

                    public void handleSuccessfulRendition(ChildAssociationRef primaryParentOfNewRendition) {
                        ChildAssociationRef assocRef = (ChildAssociationRef)callbackDef.getParameterValue("result");
                        NodeRef rendition = assocRef.getChildRef();
                        RenditionHelper.this.nodeService.removeAspect(rendition, ContentModel.ASPECT_INDEX_CONTROL);
                    }

                    public void handleFailedRendition(Throwable t) {
                    }
                };
                this.renditionService.render(node, def, renderCallback);
            }
        }
    }

    private Map<String, List<String>> getRenditionConfig(NodeRef section) {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        List values = (List)((Object)this.nodeService.getProperty(section, PROP_RENDITION_CONFIG));
        if (values != null) {
            for (String value : values) {
                ArrayList<String> renditions;
                String[] split = value.split("=");
                if (split.length != 2) continue;
                String key = split[0];
                if (result.containsKey(key)) {
                    renditions = (ArrayList<String>)result.get(key);
                    renditions.add(split[1]);
                    continue;
                }
                renditions = new ArrayList<String>(3);
                renditions.add(split[1]);
                result.put(key, renditions);
            }
        }
        return result;
    }
}

