/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.SiteHelper;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemporaryMultilingualAspect
implements NodeServicePolicies.OnAddAspectPolicy {
    private static final Log log = LogFactory.getLog(TemporaryMultilingualAspect.class);
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private DictionaryService dictionaryService;
    private MultilingualContentService multilingualContentService;
    private SiteHelper siteHelper;
    private CopyService copyService;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public void setSiteHelper(SiteHelper siteHelper) {
        this.siteHelper = siteHelper;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, WebSiteModel.ASPECT_TEMPORARY_MULTILINGUAL, (Behaviour)new JavaBehaviour((Object)this, "onAddAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enabled behaviour on " + WebSiteModel.ASPECT_TEMPORARY_MULTILINGUAL));
        }
    }

    public Locale identifyLocale(NodeRef nodeRef) {
        Locale locale;
        if (nodeRef == null) {
            return null;
        }
        if (this.siteHelper.isTranslationParentLimitReached(nodeRef)) {
            return null;
        }
        String language = (String)((Object)this.nodeService.getProperty(nodeRef, WebSiteModel.PROP_LANGUAGE));
        if (language != null) {
            return new Locale(language);
        }
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT) && (locale = (Locale)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE)) != null && !"".equals(locale)) {
            return locale;
        }
        return this.identifyLocale(this.nodeService.getPrimaryParent(nodeRef).getParentRef());
    }

    private void copyResourcesForSection(NodeRef newSection, NodeRef sourceSection) {
        QName type = this.nodeService.getType(newSection);
        if (!this.dictionaryService.isSubClass(type, WebSiteModel.TYPE_SECTION)) {
            return;
        }
        Locale srcLocale = (Locale)this.nodeService.getProperty(sourceSection, ContentModel.PROP_LOCALE);
        Locale dstLocale = (Locale)this.nodeService.getProperty(newSection, ContentModel.PROP_LOCALE);
        if (srcLocale == null || dstLocale == null) {
            log.warn((Object)"One of the sections lacks a locale, this shouldn't happen!");
            return;
        }
        NodeRef srcCollection = this.nodeService.getChildByName(sourceSection, ContentModel.ASSOC_CONTAINS, "collections");
        NodeRef dstCollection = this.nodeService.getChildByName(newSection, ContentModel.ASSOC_CONTAINS, "collections");
        if (srcCollection != null && dstCollection != null) {
            for (ChildAssociationRef ref : this.nodeService.getChildAssocs(srcCollection)) {
                if (!ref.isPrimary()) continue;
                String name = (String)((Object)this.nodeService.getProperty(ref.getChildRef(), ContentModel.PROP_NAME));
                if (this.nodeService.getChildByName(dstCollection, ref.getTypeQName(), name) != null) continue;
                NodeRef copy = this.copyService.copy(ref.getChildRef(), dstCollection, ref.getTypeQName(), ref.getQName(), true);
                this.nodeService.setProperty(copy, ContentModel.PROP_NAME, (Serializable)((Object)name));
            }
        } else {
            log.warn((Object)"Missing collections on WCM Section! Unable to migrate assets");
        }
        NodeRef srcIndex = this.nodeService.getChildByName(sourceSection, ContentModel.ASSOC_CONTAINS, "index.html");
        NodeRef dstIndex = this.nodeService.getChildByName(newSection, ContentModel.ASSOC_CONTAINS, "index.html");
        if (srcIndex != null && dstIndex != null) {
            if (!this.multilingualContentService.isTranslation(srcIndex)) {
                this.multilingualContentService.makeTranslation(srcIndex, srcLocale);
            }
            this.multilingualContentService.addTranslation(dstIndex, srcIndex, dstLocale);
        } else {
            log.warn((Object)"Missing index page on WCM Section! Unable to associate index pages");
        }
    }

    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        NodeRef translationOf = (NodeRef)this.nodeService.getProperty(nodeRef, WebSiteModel.PROP_TRANSLATION_OF);
        Boolean initiallyOrphaned = (Boolean)this.nodeService.getProperty(nodeRef, WebSiteModel.PROP_INITIALLY_ORPHANED);
        Locale locale = this.identifyLocale(nodeRef);
        if (locale == null) {
            log.warn((Object)("Asked to setup multilingual for " + nodeRef + " but no language given and no translated parent found, no translation added"));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Enabling translation in " + locale + " for " + nodeRef));
        }
        if (translationOf != null) {
            if (!this.multilingualContentService.isTranslation(translationOf)) {
                throw new AlfrescoRuntimeException("Can't make a document a translation of node without a language");
            }
            if (locale != null) {
                this.multilingualContentService.addTranslation(nodeRef, translationOf, locale);
                this.copyResourcesForSection(nodeRef, translationOf);
            }
        } else if (locale != null) {
            this.multilingualContentService.makeTranslation(nodeRef, locale);
        }
        if (initiallyOrphaned != null && initiallyOrphaned.booleanValue() && translationOf != null) {
            ChildAssociationRef orphanRef = this.nodeService.getPrimaryParent(nodeRef);
            NodeRef orphanParent = orphanRef.getParentRef();
            Locale originalLocale = (Locale)this.nodeService.getProperty(translationOf, ContentModel.PROP_LOCALE);
            ArrayList<Pair> parents = new ArrayList<Pair>();
            NodeRef parent = this.nodeService.getPrimaryParent(translationOf).getParentRef();
            while (!(parent == null || this.siteHelper.isTranslationParentLimitReached(parent) || this.multilingualContentService.isTranslation(parent) && this.multilingualContentService.getTranslations(parent).values().contains(orphanParent))) {
                String parentName = (String)((Object)this.nodeService.getProperty(parent, ContentModel.PROP_NAME));
                parents.add(new Pair((Object)parent, (Object)parentName));
                parent = this.nodeService.getPrimaryParent(parent).getParentRef();
            }
            Collections.reverse(parents);
            NodeRef transParent = orphanParent;
            for (Pair create : parents) {
                NodeRef transFolder;
                if (!this.multilingualContentService.isTranslation((NodeRef)create.getFirst())) {
                    this.multilingualContentService.makeTranslation((NodeRef)create.getFirst(), originalLocale);
                }
                if ((transFolder = this.nodeService.getChildByName(transParent, ContentModel.ASSOC_CONTAINS, (String)create.getSecond())) == null) {
                    transFolder = this.nodeService.createNode(transParent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)((String)create.getSecond())), this.nodeService.getType((NodeRef)create.getFirst())).getChildRef();
                    this.nodeService.setProperty(transFolder, ContentModel.PROP_NAME, (Serializable)create.getSecond());
                }
                this.multilingualContentService.addTranslation(transFolder, (NodeRef)create.getFirst(), locale);
                this.copyResourcesForSection(transFolder, (NodeRef)create.getFirst());
                transParent = transFolder;
            }
            this.nodeService.moveNode(nodeRef, transParent, orphanRef.getTypeQName(), orphanRef.getQName());
        }
        this.nodeService.removeAspect(nodeRef, WebSiteModel.ASPECT_TEMPORARY_MULTILINGUAL);
    }
}

