/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArticleType
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(ArticleType.class);
    private PolicyComponent policyComponent;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteAssociationPolicy.QNAME, WebSiteModel.TYPE_VISITOR_FEEDBACK, WebSiteModel.ASSOC_RELEVANT_ASSET, (Behaviour)new JavaBehaviour((Object)this, "onDeleteAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    public void onDeleteAssociation(AssociationRef nodeAssocRef) {
        NodeRef sourceRef = nodeAssocRef.getSourceRef();
        if (this.nodeService.exists(sourceRef) && !this.nodeService.hasAspect(sourceRef, ContentModel.ASPECT_PENDING_DELETE)) {
            this.nodeService.deleteNode(sourceRef);
        }
    }

    public void onDeleteAssociationEveryEvent(AssociationRef nodeAssocRef) {
        NodeRef sourceNode = nodeAssocRef.getSourceRef();
        if (this.nodeService.exists(sourceNode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clearing relevant article property on node " + sourceNode));
            }
            this.nodeService.removeProperty(sourceNode, WebSiteModel.PROP_RELEVANT_ASSET);
        }
    }
}

