/*
 * #%L
 * Alfresco Sharepoint Protocol
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.module.vti.metadata.model;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Represents Sharepoint document work space after creation. </p>
 * 
 * @author AndreyAk
 *
 */
public class DwsBean implements Serializable
{

    private static final long serialVersionUID = -1659680970545671188L;

    private String url;
    private String doclibUrl;
    private String parentWeb;
    private List<String> failedUsers;
    private String addUsersUrl = "";
    private String addUsersRole = "";

    public DwsBean()
    {
        super();
    }
    
    /**
     * @param url
     * @param doclibUrl
     * @param parentWeb
     * @param failedUsers
     * @param addUsersUrl TODO
     * @param addUsersRole TODO
     */
    public DwsBean(String url, String doclibUrl, String parentWeb, List<String> failedUsers, String addUsersUrl, String addUsersRole)
    {
        this.url = url;
        this.doclibUrl = doclibUrl;
        this.parentWeb = parentWeb;
        this.failedUsers = failedUsers;
        this.addUsersUrl = addUsersUrl;
        this.addUsersRole = addUsersRole;
    }

    /**
     * @return the url
     */
    public String getUrl()
    {
        return url;
    }

    /**
     * <p>Sets the dws url.</p>
     * 
     * @param url the url to set
     */
    public void setUrl(String url)
    {
        this.url = url;
    }

    /**
     * @return the doclibUrl
     */
    public String getDoclibUrl()
    {
        return doclibUrl;
    }

    /**
     * <p>Sets the document library url for current dws.</p>
     * 
     * @param doclibUrl the doclibUrl to set
     */
    public void setDoclibUrl(String doclibUrl)
    {
        this.doclibUrl = doclibUrl;
    }

    /**
     * @return the parentWeb
     */
    public String getParentWeb()
    {
        return parentWeb;
    }

    /**
     * <p>Sets the url of the parent site.</p>
     * 
     * @param parentWeb the parentWeb to set
     */
    public void setParentWeb(String parentWeb)
    {
        this.parentWeb = parentWeb;
    }

    /**
     * @return the failedUsers
     */
    public List<String> getFailedUsers()
    {
        return failedUsers;
    }

    /**
     * @param failedUsers the failedUsers to set
     */
    public void setFailedUsers(List<String> failedUsers)
    {
        this.failedUsers = failedUsers;
    }
        
    /**
     * @return the addUsersRole
     */
    public String getAddUsersRole()
    {
        return addUsersRole;
    }
    
    /**
     * @return the addUsersUrl
     */
    public String getAddUsersUrl()
    {
        return addUsersUrl;
    }
}
