/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.solr.InformationServerCollectionProvider;
import org.alfresco.solr.adapters.ISimpleOrderedMap;
import org.alfresco.util.Pair;

public class TrackerStats {
    public static final int TIME_SCALE = 1000000;
    ConcurrentHashMap<String, IncrementalStats> modelTimes = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> aclTimes = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> changeSetAcls = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> txDocs = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> docTransformationTimes = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> nodeTimes = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> elapsedNodeTimes = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> elapsedAclTimes = new ConcurrentHashMap();
    ConcurrentHashMap<String, IncrementalStats> elapsedContentTimes = new ConcurrentHashMap();
    private InformationServerCollectionProvider infoSrv;

    public TrackerStats(InformationServerCollectionProvider server) {
        this.infoSrv = server;
    }

    public SimpleStats getModelTimes() {
        return this.aggregateResults(this.modelTimes);
    }

    private SimpleStats aggregateResults(ConcurrentHashMap<String, IncrementalStats> all) {
        SimpleStats answer = null;
        for (String key : all.keySet()) {
            IncrementalStats next = all.get(key);
            IncrementalStats stats = next.copy();
            if (answer == null) {
                answer = new SimpleStats(stats.scale, this.infoSrv);
                answer.start = stats.start;
                answer.moments[0] = stats.moments[0];
                answer.moments[1] = stats.moments[1];
                answer.moments[2] = stats.moments[2];
                answer.max = stats.max;
                answer.min = stats.min;
                answer.copies.put(key, stats);
                continue;
            }
            SimpleStats newAnswer = new SimpleStats(answer.scale, this.infoSrv);
            newAnswer.moments[0] = answer.moments[0] + stats.moments[0];
            newAnswer.moments[1] = answer.moments[1] * answer.moments[0] + stats.moments[1] * stats.moments[0];
            newAnswer.moments[1] = newAnswer.moments[1] / (answer.moments[0] + stats.moments[0]);
            newAnswer.moments[2] = answer.moments[2] * answer.moments[0];
            newAnswer.moments[2] = newAnswer.moments[2] + (answer.moments[1] - newAnswer.moments[1]) * (answer.moments[1] - newAnswer.moments[1]) * answer.moments[0];
            newAnswer.moments[2] = newAnswer.moments[2] + stats.moments[2] * stats.moments[0];
            newAnswer.moments[2] = newAnswer.moments[2] + (stats.moments[1] - newAnswer.moments[1]) * (stats.moments[1] - newAnswer.moments[1]) * stats.moments[0];
            newAnswer.moments[2] = newAnswer.moments[2] / (answer.moments[0] + stats.moments[0]);
            newAnswer.min = stats.min < answer.min ? stats.min : answer.min;
            newAnswer.max = stats.max > answer.max ? stats.max : answer.max;
            newAnswer.start = stats.start.compareTo(answer.start) < 1 ? stats.start : answer.start;
            newAnswer.copies.putAll(answer.copies);
            newAnswer.copies.put(key, stats);
            answer = newAnswer;
        }
        if (answer == null) {
            answer = new SimpleStats(1, this.infoSrv);
        }
        return answer;
    }

    public SimpleStats getAclTimes() {
        return this.aggregateResults(this.aclTimes);
    }

    public SimpleStats getChangeSetAcls() {
        return this.aggregateResults(this.changeSetAcls);
    }

    public SimpleStats getNodeTimes() {
        return this.aggregateResults(this.nodeTimes);
    }

    public SimpleStats getTxDocs() {
        return this.aggregateResults(this.txDocs);
    }

    public SimpleStats getDocTransformationTimes() {
        return this.aggregateResults(this.docTransformationTimes);
    }

    public double getMeanModelSyncTime() {
        return this.aggregateResults(this.modelTimes).getMean();
    }

    public double getMeanNodeIndexTime() {
        return this.aggregateResults(this.nodeTimes).getMean();
    }

    public double getMeanNodeElapsedIndexTime() {
        return this.aggregateResults(this.elapsedNodeTimes).getMean();
    }

    public double getMeanAclElapsedIndexTime() {
        return this.aggregateResults(this.elapsedAclTimes).getMean();
    }

    public double getMeanContentElapsedIndexTime() {
        return this.aggregateResults(this.elapsedContentTimes).getMean();
    }

    public double getNodeIndexingThreadCount() {
        return this.nodeTimes.size();
    }

    public double getMeanAclIndexTime() {
        return this.aggregateResults(this.nodeTimes).getMean();
    }

    public double getMeanDocsPerTx() {
        return this.aggregateResults(this.txDocs).getMean();
    }

    public double getMeanAclsPerChangeSet() {
        return this.aggregateResults(this.changeSetAcls).getMean();
    }

    public void addModelTime(long time) {
        IncrementalStats stats = this.modelTimes.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1000000, 50, this.infoSrv);
            this.modelTimes.put(Thread.currentThread().getName(), stats);
        }
        stats.add(time);
    }

    public void addAclTime(long time) {
        IncrementalStats stats = this.aclTimes.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1000000, 50, this.infoSrv);
            this.aclTimes.put(Thread.currentThread().getName(), stats);
        }
        stats.add(time);
    }

    public void addNodeTime(long time) {
        IncrementalStats stats = this.nodeTimes.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1000000, 50, this.infoSrv);
            this.nodeTimes.put(Thread.currentThread().getName(), stats);
        }
        stats.add(time);
    }

    public void addElapsedNodeTime(int docCount, long time) {
        if (docCount < 1) {
            return;
        }
        IncrementalStats stats = this.elapsedNodeTimes.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1000000, 50, this.infoSrv);
            this.elapsedNodeTimes.put(Thread.currentThread().getName(), stats);
        }
        long meanTime = time / (long)docCount;
        for (int i = 0; i < docCount; ++i) {
            stats.add(meanTime);
        }
    }

    public void addElapsedAclTime(int docCount, long time) {
        if (docCount < 1) {
            return;
        }
        IncrementalStats stats = this.elapsedAclTimes.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1000000, 50, this.infoSrv);
            this.elapsedAclTimes.put(Thread.currentThread().getName(), stats);
        }
        long meanTime = time / (long)docCount;
        for (int i = 0; i < docCount; ++i) {
            stats.add(meanTime);
        }
    }

    public void addElapsedContentTime(int docCount, long time) {
        if (docCount < 1) {
            return;
        }
        IncrementalStats stats = this.elapsedContentTimes.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1000000, 50, this.infoSrv);
            this.elapsedContentTimes.put(Thread.currentThread().getName(), stats);
        }
        long meanTime = time / (long)docCount;
        for (int i = 0; i < docCount; ++i) {
            stats.add(meanTime);
        }
    }

    public void addTxDocs(int size) {
        IncrementalStats stats = this.txDocs.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1, 50, this.infoSrv);
            this.txDocs.put(Thread.currentThread().getName(), stats);
        }
        stats.add(size);
    }

    public void addChangeSetAcls(int size) {
        IncrementalStats stats = this.changeSetAcls.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1, 50, this.infoSrv);
            this.changeSetAcls.put(Thread.currentThread().getName(), stats);
        }
        stats.add(size);
    }

    public void addDocTransformationTime(long time) {
        IncrementalStats stats = this.docTransformationTimes.get(Thread.currentThread().getName());
        if (stats == null) {
            stats = new IncrementalStats(1000000, 50, this.infoSrv);
            this.docTransformationTimes.put(Thread.currentThread().getName(), stats);
        }
        stats.add(time);
    }

    public String toString() {
        return "TrackerStats [modelTimes=" + this.modelTimes + ", aclTimes=" + this.aclTimes + ", changeSetAcls=" + this.changeSetAcls + ", txDocs=" + this.txDocs + ", docTransformationTimes=" + this.docTransformationTimes + ", nodeTimes=" + this.nodeTimes + "]";
    }

    public void reset() {
        this.modelTimes.clear();
        this.aclTimes.clear();
        this.changeSetAcls.clear();
        this.txDocs.clear();
        this.docTransformationTimes.clear();
        this.nodeTimes.clear();
    }

    public static class IncrementalStats {
        Date start = new Date();
        int scale;
        int buckets;
        double[] moments = new double[5];
        double min = 0.0;
        double max = 0.0;
        List<Double> values;
        List<Bucket> hist;
        InformationServerCollectionProvider server;

        public IncrementalStats(int scale, int buckets, InformationServerCollectionProvider infoSrv) {
            this.scale = scale;
            this.buckets = buckets;
            this.values = new ArrayList<Double>(buckets);
            this.hist = new ArrayList<Bucket>(buckets + 1);
            this.server = infoSrv;
        }

        public ISimpleOrderedMap<Object> getNamedList(boolean includeHist, boolean includeValues) {
            int i;
            ISimpleOrderedMap<Object> map = this.server.getSimpleOrderedMapInstance();
            map.add("Start", this.start);
            map.add("N", this.getN());
            map.add("Min", this.getMin());
            map.add("Max", this.getMax());
            map.add("Mean", this.getMean());
            map.add("Varience", this.getVarience());
            map.add("StdDev", this.getStandardDeviation());
            map.add("Skew", this.getSkew());
            map.add("Kurtosis", this.getKurtosis());
            if (includeHist) {
                i = 0;
                ISimpleOrderedMap<String> buckets = this.server.getSimpleOrderedMapInstance();
                for (Bucket b : this.hist) {
                    double mark = (b.leftBoundary + b.rightBoundary) / 2.0;
                    double width = b.rightBoundary - b.leftBoundary;
                    buckets.add("" + i++, (b.leftBoundary + mark) / 2.0 + "," + b.countLeft / (double)b.incrementalStats.getN() / width);
                    buckets.add("" + i++, (mark + b.rightBoundary) / 2.0 + "," + b.countRight / (double)b.incrementalStats.getN() / width);
                }
                map.add("Buckets", buckets);
            }
            if (includeValues) {
                i = 0;
                ISimpleOrderedMap<Double> valuesMap = this.server.getSimpleOrderedMapInstance();
                for (Double value : this.values) {
                    valuesMap.add("" + i++, value);
                }
                map.add("Values", valuesMap);
            }
            return map;
        }

        public synchronized void reset() {
            this.moments = new double[5];
            this.min = 0.0;
            this.max = 0.0;
            this.values = new ArrayList<Double>(this.buckets);
            this.hist = new ArrayList<Bucket>(this.buckets + 1);
            this.start = new Date();
        }

        public synchronized void add(double xUnscaled) {
            double x = xUnscaled / (double)this.scale;
            if (this.moments[0] == 0.0 || x > this.max) {
                this.max = x;
            }
            if (this.moments[0] == 0.0 || x < this.min) {
                this.min = x;
            }
            double n = this.moments[0];
            double nPlus1 = n + 1.0;
            double n2 = n * n;
            double d = (this.moments[1] - x) / nPlus1;
            double d2 = d * d;
            double d3 = d2 * d;
            double n_nPlus1 = n / nPlus1;
            this.moments[4] = this.moments[4] + (4.0 * d * this.moments[3] + 6.0 * d2 * this.moments[2] + (1.0 + n * n2) * d2 * d2);
            this.moments[4] = this.moments[4] * n_nPlus1;
            this.moments[3] = this.moments[3] + (3.0 * d * this.moments[2] + (1.0 - n2) * d3);
            this.moments[3] = this.moments[3] * n_nPlus1;
            this.moments[2] = this.moments[2] + (1.0 + n) * d2;
            this.moments[2] = this.moments[2] * n_nPlus1;
            this.moments[1] = this.moments[1] - d;
            this.moments[0] = nPlus1;
            if (this.buckets > 1) {
                if (this.moments[0] < (double)this.buckets) {
                    this.values.add(x);
                } else if (this.moments[0] == (double)this.buckets) {
                    this.values.add(x);
                    this.buildInitialBuckets();
                } else {
                    this.values.set((int)this.moments[0] % this.buckets, x);
                    if (x < this.hist.get((int)0).leftBoundary) {
                        double delta = (this.hist.get((int)0).leftBoundary - x) / 3.0;
                        Bucket b = new Bucket(this, x - delta, this.hist.get((int)0).leftBoundary);
                        this.hist.add(0, b);
                        b.add(x);
                        Pair<Integer, Double> bestToMerge = this.findBestToMerge();
                        if (this.hist.size() > this.buckets) {
                            this.merge((Integer)bestToMerge.getFirst());
                        }
                    } else if (x >= this.hist.get((int)(this.hist.size() - 1)).rightBoundary) {
                        double delta = (x - this.hist.get((int)(this.hist.size() - 1)).rightBoundary) / 3.0;
                        Bucket b = new Bucket(this, this.hist.get((int)(this.hist.size() - 1)).rightBoundary, x + delta);
                        this.hist.add(b);
                        b.add(x);
                        Pair<Integer, Double> bestToMerge = this.findBestToMerge();
                        if (this.hist.size() > this.buckets) {
                            this.merge((Integer)bestToMerge.getFirst());
                        }
                    } else {
                        for (Bucket b : this.hist) {
                            if (!(b.leftBoundary <= x) || !(x < b.rightBoundary)) continue;
                            b.add(x);
                            break;
                        }
                        Pair<Integer, Double> bestToMerge = this.findBestToMerge();
                        Pair<Integer, Double> bestToSplit = this.findBestToSplit();
                        if ((Double)bestToMerge.getSecond() - (Double)bestToSplit.getSecond() < 0.0) {
                            if (this.hist.size() < this.buckets) {
                                this.split((Integer)bestToSplit.getFirst());
                            } else {
                                this.merge((Integer)bestToMerge.getFirst());
                                this.split((Integer)bestToMerge.getFirst() < (Integer)bestToSplit.getFirst() ? (Integer)bestToSplit.getFirst() - 1 : (Integer)bestToSplit.getFirst());
                            }
                        }
                    }
                }
            }
        }

        private void buildInitialBuckets() {
            Collections.sort(this.values);
            block0: for (int i = 0; i < this.values.size(); ++i) {
                for (Bucket b : this.hist) {
                    if (!(b.leftBoundary <= this.values.get(i)) || !(this.values.get(i) < b.rightBoundary)) continue;
                    b.add(this.values.get(i));
                    continue block0;
                }
                if (i < this.values.size() - 1) {
                    double start = this.values.get(i);
                    double end = start + 1.0;
                    for (int j = i + 1; j < this.values.size(); ++j) {
                        if (!(this.values.get(j) > start)) continue;
                        end = this.values.get(j);
                        break;
                    }
                    Bucket b = new Bucket(this, start, end);
                    b.add(this.values.get(i));
                    this.hist.add(b);
                    continue;
                }
                double first = this.values.get(0);
                double last = this.values.get(this.values.size() - 1);
                double width = 1.0;
                if (this.values.size() > 1) {
                    width = (last - first) / (double)(this.values.size() - 1);
                }
                Bucket b = new Bucket(this, last, last + width);
                b.add(this.values.get(i));
                this.hist.add(b);
            }
        }

        void merge(int position) {
            Bucket lower = this.hist.get(position);
            Bucket upper = this.hist.get(position + 1);
            Bucket merged = new Bucket(this, lower.leftBoundary, upper.rightBoundary, lower.countLeft + lower.countRight, upper.countLeft + upper.countRight);
            this.hist.remove(position);
            this.hist.set(position, merged);
        }

        void split(int position) {
            Bucket toSplit = this.hist.get(position);
            double mark = (toSplit.leftBoundary + toSplit.rightBoundary) / 2.0;
            Bucket lower = new Bucket(this, toSplit.leftBoundary, mark, toSplit.countLeft / 2.0, toSplit.countLeft / 2.0);
            Bucket upper = new Bucket(this, mark, toSplit.rightBoundary, toSplit.countRight / 2.0, toSplit.countRight / 2.0);
            this.hist.set(position, upper);
            this.hist.add(position, lower);
        }

        Pair<Integer, Double> findBestToMerge() {
            double minMergeError = Double.MAX_VALUE;
            int bucket = 0;
            for (int i = 0; i < this.hist.size() - 1; ++i) {
                double mergeError = this.hist.get(i).mergeError(this.hist.get(i + 1));
                if (!(mergeError < minMergeError)) continue;
                minMergeError = mergeError;
                bucket = i;
            }
            return new Pair((Object)bucket, (Object)minMergeError);
        }

        Pair<Integer, Double> findBestToSplit() {
            double maxError = Double.MIN_VALUE;
            int bucket = 0;
            for (int i = 0; i < this.hist.size(); ++i) {
                double error = this.hist.get(i).error();
                if (!(error > maxError)) continue;
                maxError = error;
                bucket = i;
            }
            return new Pair((Object)bucket, (Object)maxError);
        }

        public synchronized long getN() {
            return (long)this.moments[0];
        }

        public synchronized double getMin() {
            return this.min;
        }

        public synchronized double getMax() {
            return this.max;
        }

        public synchronized double getMean() {
            return this.moments[1];
        }

        public synchronized double getVarience() {
            if (this.moments[0] > 1.0) {
                return this.moments[2] * this.moments[0] / (this.moments[0] - 1.0);
            }
            return Double.NaN;
        }

        public synchronized double getStandardDeviation() {
            return Math.sqrt(this.getVarience());
        }

        public synchronized double getSkew() {
            if (this.moments[0] > 2.0) {
                double v = this.getVarience();
                return this.moments[3] * this.moments[0] * this.moments[0] / (Math.sqrt(v) * v * (this.moments[0] - 1.0) * (this.moments[0] - 2.0));
            }
            return Double.NaN;
        }

        public synchronized double getKurtosis() {
            if (this.moments[0] > 3.0) {
                double div = (this.moments[0] - 2.0) * (this.moments[0] - 3.0);
                double nMinus1 = this.moments[0] - 1.0;
                double v = this.getVarience();
                double z = this.moments[4] * this.moments[0] * this.moments[0] * (this.moments[0] + 1.0) / (v * v * nMinus1);
                z -= 3.0 * nMinus1 * nMinus1;
                return z /= div;
            }
            return Double.NaN;
        }

        public synchronized List<Bucket> getHistogram() {
            if (this.hist.size() == 0) {
                this.buildInitialBuckets();
            }
            return this.hist;
        }

        synchronized IncrementalStats copy() {
            IncrementalStats copy = new IncrementalStats(this.scale, this.buckets, this.server);
            copy.start = this.start;
            copy.max = this.max;
            copy.min = this.min;
            copy.moments[0] = this.moments[0];
            copy.moments[1] = this.moments[1];
            copy.moments[2] = this.moments[2];
            copy.moments[3] = this.moments[3];
            copy.moments[4] = this.moments[4];
            for (Double x : this.values) {
                copy.values.add(x);
            }
            for (Bucket b : this.hist) {
                copy.hist.add(new Bucket(copy, b.leftBoundary, b.rightBoundary, b.countLeft, b.countRight));
            }
            return copy;
        }

        public String toString() {
            return "IncrementalStats [getN()=" + this.getN() + ", getMin()=" + this.getMin() + ", getMax()=" + this.getMax() + ", getMean()=" + this.getMean() + ", getVarience()=" + this.getVarience() + ", getStandardDeviation()=" + this.getStandardDeviation() + ", getSkew()=" + this.getSkew() + ", getKurtosis()=" + this.getKurtosis() + ", values=" + this.values + ", hist=" + this.hist + "]";
        }
    }

    public static class Bucket {
        IncrementalStats incrementalStats;
        public double leftBoundary;
        public double rightBoundary;
        public double countLeft;
        public double countRight;

        Bucket(IncrementalStats incrementalStats, double leftBoundary, double rightBoundary) {
            this(incrementalStats, leftBoundary, rightBoundary, 0.0, 0.0);
        }

        Bucket(IncrementalStats incrementalStats, double leftBoundary, double rightBoundary, double countLeft, double countRight) {
            this.incrementalStats = incrementalStats;
            this.leftBoundary = leftBoundary;
            this.rightBoundary = rightBoundary;
            this.countLeft = countLeft;
            this.countRight = countRight;
        }

        public void add(double x) {
            if (x - this.leftBoundary < this.rightBoundary - x) {
                this.countLeft += 1.0;
            } else {
                this.countRight += 1.0;
            }
        }

        public double mergeError(Bucket o) {
            double f_m = (this.countLeft + this.countRight + o.countLeft + o.countRight) / 4.0;
            double t1 = this.countLeft - f_m;
            double t2 = this.countRight - f_m;
            double o1 = o.countLeft - f_m;
            double o2 = o.countRight - f_m;
            return t1 * t1 + t2 * t2 + o1 * o1 + o2 * o2;
        }

        public double error() {
            double f_m = (this.countLeft + this.countRight) / 2.0;
            double t1 = this.countLeft - f_m;
            double t2 = this.countRight - f_m;
            return t1 * t1 + t2 * t2;
        }

        public String toString() {
            double mark = (this.leftBoundary + this.rightBoundary) / 2.0;
            double width = this.rightBoundary - this.leftBoundary;
            return "Bucket [(" + this.leftBoundary + " TO " + mark + " = " + this.countLeft / (double)this.incrementalStats.getN() / width + ") : (" + mark + " TO " + this.rightBoundary + " = " + this.countRight / (double)this.incrementalStats.getN() / width + "]";
        }
    }

    public static class SimpleStats {
        HashMap<String, IncrementalStats> copies = new HashMap();
        private InformationServerCollectionProvider server;
        int scale;
        double[] moments = new double[3];
        double min = 0.0;
        double max = 0.0;
        Date start = null;

        SimpleStats(int scale, InformationServerCollectionProvider server) {
            this.scale = scale;
            this.server = server;
        }

        synchronized long getN() {
            return (long)this.moments[0];
        }

        synchronized double getMin() {
            return this.min;
        }

        synchronized double getMax() {
            return this.max;
        }

        synchronized double getMean() {
            return this.moments[1];
        }

        synchronized double getVarience() {
            if (this.moments[0] > 1.0) {
                return this.moments[2] * this.moments[0] / (this.moments[0] - 1.0);
            }
            return Double.NaN;
        }

        synchronized double getStandardDeviation() {
            return Math.sqrt(this.getVarience());
        }

        public synchronized ISimpleOrderedMap<Object> getNamedList(boolean incdludeDetail, boolean includeHist, boolean includeValues) {
            ISimpleOrderedMap<Object> map = this.server.getSimpleOrderedMapInstance();
            map.add("Start", this.start);
            map.add("N", this.getN());
            map.add("Min", this.getMin());
            map.add("Max", this.getMax());
            map.add("Mean", this.getMean());
            map.add("Varience", this.getVarience());
            map.add("StdDev", this.getStandardDeviation());
            if (incdludeDetail) {
                for (String key : this.copies.keySet()) {
                    IncrementalStats value = this.copies.get(key);
                    map.add(key, value.getNamedList(includeHist, includeValues));
                }
            }
            return map;
        }

        public String toString() {
            return "SimpleStats [\n             getN()=" + this.getN() + ",\n             getMin()=" + this.getMin() + ",\n             getMax()=" + this.getMax() + ",\n             getMean()=" + this.getMean() + ",\n             getVarience()=" + this.getVarience() + ",\n             getStandardDeviation()=" + this.getStandardDeviation() + ",\n             copies=" + this.copies + ",\n]";
        }
    }
}

