/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.Response;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.apache.commons.codec.EncoderException;
import org.json.JSONException;

public class SOLRAPIQueueClient
extends SOLRAPIClient {
    public static List<AclChangeSet> aclChangeSetQueue = Collections.synchronizedList(new ArrayList());
    public static Map<Long, List<Acl>> aclMap = Collections.synchronizedMap(new HashMap());
    public static Map<Long, AclReaders> aclReadersMap = Collections.synchronizedMap(new HashMap());
    public static List<Transaction> transactionQueue = Collections.synchronizedList(new ArrayList());
    public static Map<Long, List<Node>> nodeMap = Collections.synchronizedMap(new HashMap());
    public static Map<Long, NodeMetaData> nodeMetaDataMap = Collections.synchronizedMap(new HashMap());
    public static Map<Long, String> nodeContentMap = Collections.synchronizedMap(new HashMap());
    private static boolean throwException;

    public SOLRAPIQueueClient(NamespaceDAO namespaceDAO) {
        super(null, null, namespaceDAO);
    }

    public static void setThrowException(boolean _throwException) {
        throwException = _throwException;
    }

    @Override
    public AclChangeSets getAclChangeSets(Long fromCommitTime, Long minAclChangeSetId, Long toCommitTime, Long maxAclChangeSetId, int maxResults) throws AuthenticationException, IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        int size = aclChangeSetQueue.size();
        long maxTime = 0L;
        long maxId = 0L;
        if (fromCommitTime == null && toCommitTime == null) {
            ArrayList<AclChangeSet> aclChangeSetList = new ArrayList<AclChangeSet>();
            for (int i = 0; i < size; ++i) {
                AclChangeSet aclChangeSet = aclChangeSetQueue.get(i);
                if (aclChangeSet.getId() >= minAclChangeSetId && aclChangeSet.getId() < maxAclChangeSetId) {
                    aclChangeSetList.add(aclChangeSet);
                    maxTime = Math.max(aclChangeSet.getCommitTimeMs(), maxTime);
                    maxId = Math.max(aclChangeSet.getId(), maxId);
                }
                if (aclChangeSetList.size() == maxResults) break;
            }
            return new AclChangeSets(aclChangeSetList, maxTime, maxId);
        }
        ArrayList<AclChangeSet> aclChangeSetList = new ArrayList<AclChangeSet>();
        for (int i = 0; i < size; ++i) {
            AclChangeSet aclChangeSet = aclChangeSetQueue.get(i);
            if (aclChangeSet.getCommitTimeMs() < fromCommitTime) continue;
            if (aclChangeSet.getCommitTimeMs() > toCommitTime) break;
            aclChangeSetList.add(aclChangeSet);
            maxTime = aclChangeSet.getCommitTimeMs();
            maxId = aclChangeSet.getId();
            if (aclChangeSetList.size() == maxResults) break;
        }
        return new AclChangeSets(aclChangeSetList, maxTime, maxId);
    }

    @Override
    public List<Acl> getAcls(List<AclChangeSet> aclChangeSets, Long minAclId, int maxResults) throws AuthenticationException, IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        ArrayList<Acl> allAcls = new ArrayList<Acl>();
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            List<Acl> aclList = aclMap.get(aclChangeSet.getId());
            allAcls.addAll(aclList);
        }
        return allAcls;
    }

    @Override
    public List<AclReaders> getAclReaders(List<Acl> acls) throws AuthenticationException, IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        ArrayList<AclReaders> allAclReaders = new ArrayList<AclReaders>();
        for (Acl acl : acls) {
            AclReaders aclReaders = aclReadersMap.get(acl.getId());
            allAclReaders.add(aclReaders);
        }
        return allAclReaders;
    }

    @Override
    public List<AlfrescoModelDiff> getModelsDiff(String coreName, List<AlfrescoModel> currentModels) throws AuthenticationException, IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        return new ArrayList<AlfrescoModelDiff>();
    }

    @Override
    public Transactions getTransactions(Long fromCommitTime, Long minTxnId, Long toCommitTime, Long maxTxnId, int maxResults) throws AuthenticationException, IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        try {
            return this.getTransactions(fromCommitTime, minTxnId, toCommitTime, maxTxnId, maxResults, null);
        }
        catch (EncoderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Transactions getTransactions(Long fromCommitTime, Long minTxnId, Long toCommitTime, Long maxTxnId, int maxResults, ShardState shardState) throws AuthenticationException, IOException, JSONException, EncoderException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        int size = transactionQueue.size();
        long maxTime = 0L;
        long maxId = 0L;
        if (fromCommitTime == null && toCommitTime == null) {
            ArrayList<Transaction> transactionList = new ArrayList<Transaction>();
            for (int i = 0; i < size; ++i) {
                Transaction txn = transactionQueue.get(i);
                if (txn.getId() >= minTxnId && txn.getId() < maxTxnId) {
                    transactionList.add(txn);
                    maxTime = Math.max(txn.getCommitTimeMs(), maxTime);
                    maxId = Math.max(txn.getId(), maxId);
                }
                if (transactionList.size() == maxResults) break;
            }
            return new Transactions(transactionList, maxTime, maxId);
        }
        ArrayList<Transaction> transactionList = new ArrayList<Transaction>();
        for (int i = 0; i < size; ++i) {
            Transaction txn = transactionQueue.get(i);
            if (txn.getCommitTimeMs() < fromCommitTime) continue;
            if (txn.getCommitTimeMs() > toCommitTime) break;
            transactionList.add(txn);
            maxTime = txn.getCommitTimeMs();
            maxId = txn.getId();
            if (transactionList.size() == maxResults) break;
        }
        return new Transactions(transactionList, maxTime, maxId);
    }

    @Override
    public List<Node> getNodes(GetNodesParameters parameters, int maxResults) throws AuthenticationException, IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        List<Long> txnIds = parameters.getTransactionIds();
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (long txnId : txnIds) {
            List<Node> nodes = nodeMap.get(txnId);
            allNodes.addAll(nodes);
        }
        return allNodes;
    }

    @Override
    public List<NodeMetaData> getNodesMetaData(NodeMetaDataParameters params, int maxResults) throws AuthenticationException, IOException, JSONException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        List<Long> nodeIds = params.getNodeIds();
        if (nodeIds != null) {
            for (long nodeId : nodeIds) {
                NodeMetaData nodeMetaData = nodeMetaDataMap.get(nodeId);
                nodeMetaDatas.add(nodeMetaData);
            }
        } else {
            Long fromId = params.getFromNodeId();
            NodeMetaData nodeMetaData = nodeMetaDataMap.get(fromId);
            nodeMetaDatas.add(nodeMetaData);
        }
        return nodeMetaDatas;
    }

    @Override
    public SOLRAPIClient.GetTextContentResponse getTextContent(Long nodeId, QName propertyQName, Long modifiedSince) throws AuthenticationException, IOException {
        if (throwException) {
            throw new ConnectException("THROWING EXCEPTION, better be ready!");
        }
        if (nodeContentMap.containsKey(nodeId)) {
            return new SOLRAPIClient.GetTextContentResponse(new DummyResponse(nodeContentMap.get(nodeId)));
        }
        return new SOLRAPIClient.GetTextContentResponse(new DummyResponse("Hello world " + nodeId));
    }

    @Override
    public void close() {
    }

    private class DummyResponse
    implements Response {
        private String text;

        public DummyResponse(String text) {
            this.text = text;
        }

        public InputStream getContentAsStream() {
            return new ByteArrayInputStream(this.text.getBytes());
        }

        public int getStatus() {
            return 200;
        }

        public void release() {
        }

        public String getHeader(String key) {
            return null;
        }

        public String getContentType() {
            return "text/html";
        }
    }
}

