/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.ssl.SSLEncryptionParameters;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;

public class SOLRAPIClientFactory {
    private static Map<String, SOLRAPIClient> clientsPerAlfresco = new HashMap<String, SOLRAPIClient>();
    private String secureCommsType;
    private String sslKeyStoreType;
    private String sslKeyStoreProvider;
    private String sslKeyStoreLocation;
    private String sslKeyStorePasswordFileLocation;
    private String sslTrustStoreType;
    private String sslTrustStoreProvider;
    private String sslTrustStoreLocation;
    private String sslTrustStorePasswordFileLocation;
    private String alfrescoHost;
    private int alfrescoPort;
    private int alfrescoPortSSL;
    private String baseUrl;
    private int maxTotalConnections = 40;
    private int maxHostConnections = 40;
    private int socketTimeout = 120000;

    public static void close() {
        for (SOLRAPIClient client : clientsPerAlfresco.values()) {
            client.close();
        }
    }

    private SOLRAPIClient getCachedClient(String alfrescoHost, int alfrescoPort, int alfrescoPortSSL) {
        String key = this.constructKey(alfrescoHost, alfrescoPort, alfrescoPortSSL);
        return clientsPerAlfresco.get(key);
    }

    private String constructKey(String alfrescoHost, int alfrescoPort, int alfrescoPortSSL) {
        return alfrescoHost + alfrescoPort + alfrescoPortSSL;
    }

    private void setCachedClient(String alfrescoHost, int alfrescoPort, int alfrescoPortSSL, SOLRAPIClient client) {
        String key = this.constructKey(alfrescoHost, alfrescoPort, alfrescoPortSSL);
        clientsPerAlfresco.put(key, client);
    }

    public SOLRAPIClient getSOLRAPIClient(Properties props, KeyResourceLoader keyResourceLoader, DictionaryService dictionaryService, NamespaceDAO namespaceDAO) {
        if (Boolean.parseBoolean(System.getProperty("alfresco.test", "false"))) {
            return new SOLRAPIQueueClient(namespaceDAO);
        }
        this.alfrescoHost = props.getProperty("alfresco.host", "localhost");
        this.alfrescoPort = Integer.parseInt(props.getProperty("alfresco.port", "8080"));
        this.alfrescoPortSSL = Integer.parseInt(props.getProperty("alfresco.port.ssl", "8443"));
        SOLRAPIClient client = this.getCachedClient(this.alfrescoHost, this.alfrescoPort, this.alfrescoPortSSL);
        if (client == null) {
            this.baseUrl = props.getProperty("alfresco.baseUrl", "/alfresco");
            this.secureCommsType = props.getProperty("alfresco.secureComms", "none");
            if (this.secureCommsType.equals("https")) {
                this.sslKeyStoreType = this.getProperty(props, "alfresco.encryption.ssl.keystore.type", "JCEKS");
                this.sslKeyStoreProvider = this.getProperty(props, "alfresco.encryption.ssl.keystore.provider", "");
                this.sslKeyStoreLocation = this.getProperty(props, "alfresco.encryption.ssl.keystore.location", "ssl.repo.client.keystore");
                this.sslKeyStorePasswordFileLocation = this.getProperty(props, "alfresco.encryption.ssl.keystore.passwordFileLocation", "ssl-keystore-passwords.properties");
                this.sslTrustStoreType = this.getProperty(props, "alfresco.encryption.ssl.truststore.type", "JCEKS");
                this.sslTrustStoreProvider = this.getProperty(props, "alfresco.encryption.ssl.truststore.provider", "");
                this.sslTrustStoreLocation = this.getProperty(props, "alfresco.encryption.ssl.truststore.location", "ssl.repo.client.truststore");
                this.sslTrustStorePasswordFileLocation = this.getProperty(props, "alfresco.encryption.ssl.truststore.passwordFileLocation", "ssl-truststore-passwords.properties");
            }
            this.maxTotalConnections = Integer.parseInt(props.getProperty("alfresco.maxTotalConnections", "40"));
            this.maxHostConnections = Integer.parseInt(props.getProperty("alfresco.maxHostConnections", "40"));
            this.socketTimeout = Integer.parseInt(props.getProperty("alfresco.socketTimeout", "60000"));
            client = new SOLRAPIClient(this.getRepoClient(keyResourceLoader), dictionaryService, namespaceDAO);
            this.setCachedClient(this.alfrescoHost, this.alfrescoPort, this.alfrescoPortSSL, client);
        }
        return client;
    }

    protected AlfrescoHttpClient getRepoClient(KeyResourceLoader keyResourceLoader) {
        PlainHttpClientFactory httpClientFactory = null;
        if (this.secureCommsType.equals("https")) {
            KeyStoreParameters keyStoreParameters = new KeyStoreParameters("SSL Key Store", this.sslKeyStoreType, this.sslKeyStoreProvider, this.sslKeyStorePasswordFileLocation, this.sslKeyStoreLocation);
            KeyStoreParameters trustStoreParameters = new KeyStoreParameters("SSL Trust Store", this.sslTrustStoreType, this.sslTrustStoreProvider, this.sslTrustStorePasswordFileLocation, this.sslTrustStoreLocation);
            SSLEncryptionParameters sslEncryptionParameters = new SSLEncryptionParameters(keyStoreParameters, trustStoreParameters);
            httpClientFactory = new HttpClientFactory(HttpClientFactory.SecureCommsType.getType((String)this.secureCommsType), sslEncryptionParameters, keyResourceLoader, null, null, this.alfrescoHost, this.alfrescoPort, this.alfrescoPortSSL, this.maxTotalConnections, this.maxHostConnections, this.socketTimeout);
        } else {
            httpClientFactory = new PlainHttpClientFactory(this.alfrescoHost, this.alfrescoPort, this.maxTotalConnections, this.maxHostConnections);
        }
        AlfrescoHttpClient repoClient = httpClientFactory.getRepoClient(this.alfrescoHost, this.alfrescoPortSSL);
        repoClient.setBaseUrl(this.baseUrl);
        return repoClient;
    }

    private String getProperty(Properties props, String key, String defaultValue) {
        String value = System.getProperties().getProperty(key);
        if (value == null) {
            value = props.getProperty(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    class PlainHttpClientFactory
    extends HttpClientFactory {
        public PlainHttpClientFactory(String host, int port, int maxTotalConnections, int maxHostConnections) {
            this.setSecureCommsType("none");
            this.setHost(host);
            this.setPort(port);
            this.setMaxTotalConnections(maxTotalConnections);
            this.setMaxHostConnections(maxHostConnections);
            this.init();
        }

        public void init() {
            DefaultHttpParams.setHttpParamsFactory((HttpParamsFactory)new HttpClientFactory.NonBlockingHttpParamsFactory());
        }
    }
}

