/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;

public class BoundedDeque<T>
implements Iterable<T> {
    private LinkedBlockingDeque<T> deque;
    private int max = 10;

    public BoundedDeque(int max) {
        this.max = max;
        this.setDeque(new LinkedBlockingDeque());
    }

    public int size() {
        return this.getDeque().size();
    }

    public void add(T add) {
        while (this.getDeque().size() > this.max - 1) {
            this.getDeque().removeLast();
        }
        this.getDeque().addFirst(add);
    }

    public T getLast() {
        return this.getDeque().getFirst();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getDeque().iterator();
    }

    public LinkedBlockingDeque<T> getDeque() {
        return this.deque;
    }

    public void setDeque(LinkedBlockingDeque<T> deque) {
        this.deque = deque;
    }
}

