/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.image.impl.DefaultProcessDiagramGenerator;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.DefaultWorkflowPropertyHandler;
import org.alfresco.repo.workflow.WorkflowAuthorityManager;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowNodeConverter;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.WorkflowPackageImpl;
import org.alfresco.repo.workflow.WorkflowPropertyHandler;
import org.alfresco.repo.workflow.WorkflowPropertyHandlerRegistry;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.repo.workflow.activiti.ActivitiNodeConverter;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.ActivitiUtil;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.content.FileBinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.Processes;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.rest.workflow.api.impl.RestVariableHelper;
import org.alfresco.rest.workflow.api.impl.TypeDefinitionContext;
import org.alfresco.rest.workflow.api.impl.WorkflowRestImpl;
import org.alfresco.rest.workflow.api.model.Item;
import org.alfresco.rest.workflow.api.model.ProcessInfo;
import org.alfresco.rest.workflow.api.model.Variable;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;

public class ProcessesImpl
extends WorkflowRestImpl
implements Processes {
    protected static String PROCESS_STATUS_ANY = "any";
    protected static String PROCESS_STATUS_ACTIVE = "active";
    protected static String PROCESS_STATUS_COMPLETED = "completed";
    protected static String PROCESS_STATUS_DELETED = "deleted";
    protected static final Set<String> PROCESS_STATUS_LIST = new HashSet<String>(Arrays.asList(PROCESS_STATUS_ANY, PROCESS_STATUS_ACTIVE, PROCESS_STATUS_COMPLETED, PROCESS_STATUS_DELETED));
    protected static final Set<String> PROCESS_COLLECTION_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("processDefinitionId", "businessKey", "processDefinitionKey", "startUserId", "status", "includeVariables"));
    protected static final Set<String> PROCESS_COLLECTION_GREATERTHAN_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("startedAt", "endedAt"));
    protected static final Set<String> PROCESS_COLLECTION_LESSTHAN_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("startedAt", "endedAt"));
    protected static final Set<String> PROCESS_COLLECTION_SORT_PROPERTIES = new HashSet<String>(Arrays.asList("processDefinitionId", "businessKey", "id", "startedAt", "endedAt", "durationInMillis"));
    protected WorkflowPackageImpl workflowPackageComponent;
    protected ServiceRegistry serviceRegistry;
    protected AuthorityDAO authorityDAO;
    protected PersonService personService;
    protected MessageService messageService;
    protected String engineId;
    protected Repository repositoryHelper;
    protected RestVariableHelper restVariableHelper;
    protected ActivitiNodeConverter nodeConverter;
    protected ActivitiUtil activitiUtil;
    protected DefaultWorkflowPropertyHandler defaultPropertyHandler;
    protected WorkflowQNameConverter qNameConverter;
    protected QName defaultStartTaskType = WorkflowModel.TYPE_ACTIVTI_START_TASK;
    protected WorkflowObjectFactory workflowFactory;
    protected WorkflowPropertyHandlerRegistry handlerRegistry;
    protected WorkflowAuthorityManager authorityManager;
    protected ActivitiPropertyConverter propertyConverter;

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setWorkflowPackageComponent(WorkflowPackageImpl workflowPackageComponent) {
        this.workflowPackageComponent = workflowPackageComponent;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public void setRestVariableHelper(RestVariableHelper restVariableHelper) {
        this.restVariableHelper = restVariableHelper;
    }

    protected ActivitiNodeConverter getNodeConverter() {
        if (this.nodeConverter == null) {
            this.nodeConverter = new ActivitiNodeConverter(this.serviceRegistry);
        }
        return this.nodeConverter;
    }

    protected DefaultWorkflowPropertyHandler getDefaultPropertyHandler() {
        if (this.defaultPropertyHandler == null) {
            this.defaultPropertyHandler = new DefaultWorkflowPropertyHandler();
            this.defaultPropertyHandler.setMessageService(this.messageService);
            this.defaultPropertyHandler.setNodeConverter((WorkflowNodeConverter)this.getNodeConverter());
        }
        return this.defaultPropertyHandler;
    }

    protected ActivitiUtil getActivitiUtil() {
        if (this.activitiUtil == null) {
            this.activitiUtil = new ActivitiUtil(this.activitiProcessEngine, this.deployWorkflowsInTenant);
        }
        return this.activitiUtil;
    }

    protected WorkflowQNameConverter getQNameConverter() {
        if (this.qNameConverter == null) {
            this.qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)this.namespaceService);
        }
        return this.qNameConverter;
    }

    protected WorkflowObjectFactory getWorkflowFactory() {
        if (this.workflowFactory == null) {
            this.workflowFactory = new WorkflowObjectFactory(this.getQNameConverter(), this.tenantService, this.messageService, this.dictionaryService, this.engineId, this.defaultStartTaskType);
        }
        return this.workflowFactory;
    }

    protected WorkflowPropertyHandlerRegistry getHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new WorkflowPropertyHandlerRegistry((WorkflowPropertyHandler)this.getDefaultPropertyHandler(), this.getQNameConverter());
        }
        return this.handlerRegistry;
    }

    protected WorkflowAuthorityManager getAuthorityManager() {
        if (this.authorityManager == null) {
            this.authorityManager = new WorkflowAuthorityManager(this.authorityDAO);
        }
        return this.authorityManager;
    }

    protected ActivitiPropertyConverter getPropertyConverter() {
        if (this.propertyConverter == null) {
            this.propertyConverter = new ActivitiPropertyConverter(this.getActivitiUtil(), this.getWorkflowFactory(), this.getHandlerRegistry(), this.getAuthorityManager(), this.messageService, (WorkflowNodeConverter)this.getNodeConverter());
        }
        return this.propertyConverter;
    }

    @Override
    public CollectionWithPagingInfo<ProcessInfo> getProcesses(Parameters parameters) {
        List<MapBasedQueryWalker.QueryVariableHolder> variableProperties;
        Paging paging = parameters.getPaging();
        MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(PROCESS_COLLECTION_EQUALS_QUERY_PROPERTIES, null);
        propertyWalker.setSupportedGreaterThanParameters(PROCESS_COLLECTION_GREATERTHAN_QUERY_PROPERTIES);
        propertyWalker.setSupportedLessThanParameters(PROCESS_COLLECTION_LESSTHAN_QUERY_PROPERTIES);
        propertyWalker.enableVariablesSupport(this.namespaceService, this.dictionaryService);
        if (parameters.getQuery() != null) {
            QueryHelper.walk(parameters.getQuery(), propertyWalker);
        }
        String status = propertyWalker.getProperty("status", 8);
        String processDefinitionId = propertyWalker.getProperty("processDefinitionId", 8);
        String businessKey = propertyWalker.getProperty("businessKey", 8);
        String processDefinitionKey = propertyWalker.getProperty("processDefinitionKey", 8);
        String startUserId = propertyWalker.getProperty("startUserId", 8);
        Date startedAtGreaterThan = propertyWalker.getProperty("startedAt", 10, Date.class);
        Date startedAtLessThan = propertyWalker.getProperty("startedAt", 18, Date.class);
        Date endedAtGreaterThan = propertyWalker.getProperty("endedAt", 10, Date.class);
        Date endedAtLessThan = propertyWalker.getProperty("endedAt", 18, Date.class);
        Boolean includeVariables = propertyWalker.getProperty("includeVariables", 8, Boolean.class);
        if (status != null && !PROCESS_STATUS_LIST.contains(status)) {
            throw new InvalidArgumentException("Invalid status parameter: " + status);
        }
        List<SortColumn> sortList = parameters.getSorting();
        SortColumn sortColumn = null;
        if (sortList != null && sortList.size() > 0) {
            if (sortList.size() != 1) {
                throw new InvalidArgumentException("Only one order by parameter is supported");
            }
            sortColumn = sortList.get(0);
        }
        HistoricProcessInstanceQuery query = this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery();
        if (processDefinitionId != null) {
            query.processDefinitionId(processDefinitionId);
        }
        if (businessKey != null) {
            query.processInstanceBusinessKey(businessKey);
        }
        if (processDefinitionKey != null) {
            if (this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
                if (processDefinitionKey.startsWith("@" + TenantUtil.getCurrentDomain() + "@")) {
                    query.processDefinitionKey(processDefinitionKey);
                } else {
                    query.processDefinitionKey("@" + TenantUtil.getCurrentDomain() + "@" + processDefinitionKey);
                }
            } else {
                query.processDefinitionKey(processDefinitionKey);
            }
        }
        if (startUserId != null) {
            query.startedBy(startUserId);
        }
        if (startedAtGreaterThan != null) {
            query.startedAfter(startedAtGreaterThan);
        }
        if (startedAtLessThan != null) {
            query.startedBefore(startedAtLessThan);
        }
        if (endedAtGreaterThan != null) {
            query.finishedAfter(endedAtGreaterThan);
        }
        if (endedAtLessThan != null) {
            query.finishedBefore(endedAtLessThan);
        }
        if (status == null || PROCESS_STATUS_ACTIVE.equals(status)) {
            query.unfinished();
        } else if (PROCESS_STATUS_COMPLETED.equals(status)) {
            query.finished();
            query.notDeleted();
        } else if (PROCESS_STATUS_DELETED.equals(status)) {
            query.deleted();
        }
        if (includeVariables != null && includeVariables.booleanValue()) {
            query.includeProcessVariables();
        }
        if ((variableProperties = propertyWalker.getVariableProperties()) != null) {
            for (MapBasedQueryWalker.QueryVariableHolder queryVariableHolder : variableProperties) {
                if (queryVariableHolder.getOperator() == 8) {
                    query.variableValueEquals(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 10) {
                    query.variableValueGreaterThan(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 11) {
                    query.variableValueGreaterThanOrEqual(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 18) {
                    query.variableValueLessThan(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 19) {
                    query.variableValueLessThanOrEqual(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 20) {
                    if (!(queryVariableHolder.getPropertyValue() instanceof String)) {
                        throw new InvalidArgumentException("the matches operator can only be used with a String value for property " + queryVariableHolder.getPropertyName());
                    }
                    if (((String)queryVariableHolder.getPropertyValue()).startsWith("(?i)")) {
                        query.variableValueLikeIgnoreCase(queryVariableHolder.getPropertyName(), ((String)queryVariableHolder.getPropertyValue()).substring("(?i)".length()).toLowerCase());
                        continue;
                    }
                    query.variableValueLike(queryVariableHolder.getPropertyName(), (String)queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 21) {
                    query.variableValueNotEquals(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                throw new InvalidArgumentException("variable " + queryVariableHolder.getPropertyName() + " can only be used with an =, >, >=, <=, <, not, matches comparison type");
            }
        }
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getRunAsUser())) {
            if (this.tenantService.isEnabled()) {
                query.variableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
            }
        } else {
            query.involvedUser(AuthenticationUtil.getRunAsUser());
        }
        if (sortColumn != null) {
            if (PROCESS_COLLECTION_SORT_PROPERTIES.contains(sortColumn.column)) {
                if ("processDefinitionId".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessDefinitionId();
                } else if ("id".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessInstanceId();
                } else if ("businessKey".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessInstanceBusinessKey();
                } else if ("startedAt".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessInstanceStartTime();
                } else if ("endedAt".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessInstanceEndTime();
                } else if ("durationInMillis".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessInstanceDuration();
                }
            } else {
                throw new InvalidArgumentException("sort " + sortColumn.column + " is not supported, supported items are " + Arrays.toString(PROCESS_COLLECTION_SORT_PROPERTIES.toArray()));
            }
            if (sortColumn.asc) {
                query.asc();
            } else {
                query.desc();
            }
        } else {
            query.orderByProcessInstanceStartTime().desc();
        }
        List processInstances = query.listPage(paging.getSkipCount(), paging.getMaxItems());
        int totalCount = (int)query.count();
        ArrayList<ProcessInfo> page = new ArrayList<ProcessInfo>(processInstances.size());
        HashMap<String, TypeDefinition> definitionTypeMap = new HashMap<String, TypeDefinition>();
        for (HistoricProcessInstance processInstance : processInstances) {
            ProcessInfo processInfo = this.createProcessInfo(processInstance);
            if (includeVariables != null && includeVariables.booleanValue()) {
                StartFormData startFormData;
                if (!definitionTypeMap.containsKey(processInfo.getProcessDefinitionId()) && (startFormData = this.activitiProcessEngine.getFormService().getStartFormData(processInfo.getProcessDefinitionId())) != null) {
                    String formKey = startFormData.getFormKey();
                    definitionTypeMap.put(processInfo.getProcessDefinitionId(), this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, true));
                }
                if (definitionTypeMap.containsKey(processInfo.getProcessDefinitionId())) {
                    List<Variable> resultingVariables = this.restVariableHelper.getVariables(processInstance.getProcessVariables(), (TypeDefinition)definitionTypeMap.get(processInfo.getProcessDefinitionId()));
                    processInfo.setProcessVariables(resultingVariables);
                }
            }
            page.add(processInfo);
        }
        return CollectionWithPagingInfo.asPaged(paging, page, page.size() + paging.getSkipCount() < totalCount, totalCount);
    }

    @Override
    public ProcessInfo getProcess(String processId) {
        if (processId == null) {
            throw new InvalidArgumentException("processId is required to get the process info");
        }
        this.validateIfUserAllowedToWorkWithProcess(processId);
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processId).singleResult();
        if (processInstance == null) {
            throw new EntityNotFoundException(processId);
        }
        return this.createProcessInfo(processInstance);
    }

    @Override
    public ProcessInfo create(ProcessInfo process) {
        ProcessInstance processInstance;
        if (process == null) {
            throw new InvalidArgumentException("post body expected when starting a new process instance");
        }
        boolean definitionExistingChecked = false;
        RuntimeService runtimeService = this.activitiProcessEngine.getRuntimeService();
        String processDefinitionId = null;
        if (process.getProcessDefinitionId() != null) {
            processDefinitionId = process.getProcessDefinitionId();
        } else if (process.getProcessDefinitionKey() != null) {
            ProcessDefinition definition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(this.getProcessDefinitionKey(process.getProcessDefinitionKey())).latestVersion().singleResult();
            if (definition == null) {
                throw new InvalidArgumentException("No workflow definition could be found with key '" + process.getProcessDefinitionKey() + "'.");
            }
            processDefinitionId = definition.getId();
            definitionExistingChecked = true;
        } else {
            throw new InvalidArgumentException("Either processDefinitionId or processDefinitionKey is required");
        }
        if (!definitionExistingChecked) {
            ProcessDefinitionQuery query = this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processDefinitionId);
            if (this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
                query.processDefinitionKeyLike("@" + TenantUtil.getCurrentDomain() + "@%");
            }
            if (query.count() == 0L) {
                throw new InvalidArgumentException("No workflow definition could be found with id '" + processDefinitionId + "'.");
            }
        }
        HashMap<QName, Serializable> startParams = new HashMap<QName, Serializable>();
        StartFormData startFormData = this.activitiProcessEngine.getFormService().getStartFormData(processDefinitionId);
        if (startFormData != null && !CollectionUtils.isEmpty(process.getVariables())) {
            TypeDefinition startTaskType = this.getWorkflowFactory().getTaskFullTypeDefinition(startFormData.getFormKey(), true);
            Map taskProperties = startTaskType.getProperties();
            HashMap<String, Object> propNameMap = new HashMap<String, Object>();
            for (Object key : taskProperties.keySet()) {
                propNameMap.put(key.getPrefixString().replace(':', '_'), key);
            }
            Map taskAssociations = startTaskType.getAssociations();
            for (QName key : taskAssociations.keySet()) {
                propNameMap.put(key.getPrefixString().replace(':', '_'), key);
            }
            for (String variableName : process.getVariables().keySet()) {
                PropertyDefinition propDef;
                DataTypeDefinition propDataType;
                if (!propNameMap.containsKey(variableName)) continue;
                Object variableValue = process.getVariables().get(variableName);
                if (taskAssociations.containsKey(propNameMap.get(variableName))) {
                    AssociationDefinition associationDef = (AssociationDefinition)taskAssociations.get(propNameMap.get(variableName));
                    variableValue = this.convertAssociationDefinitionValue(associationDef, variableName, variableValue);
                } else if (taskProperties.containsKey(propNameMap.get(variableName)) && "java.util.Date".equalsIgnoreCase((propDataType = (propDef = (PropertyDefinition)taskProperties.get(propNameMap.get(variableName))).getDataType()).getJavaClassName())) {
                    variableValue = ISO8601DateFormat.parse((String)((String)variableValue));
                }
                if (!(variableValue instanceof Serializable)) continue;
                startParams.put((QName)propNameMap.get(variableName), (Serializable)variableValue);
            }
        }
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        Authentication.setAuthenticatedUserId((String)currentUserName);
        NodeRef workflowPackageNodeRef = null;
        try {
            workflowPackageNodeRef = this.workflowPackageComponent.createPackage(null);
            startParams.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)workflowPackageNodeRef);
        }
        catch (Exception e) {
            throw new ApiException("couldn't create workflow package: " + e.getMessage(), e);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(process.getItems())) {
            try {
                for (String item : process.getItems()) {
                    NodeRef itemNodeRef = this.getNodeRef(item);
                    QName workflowPackageItemId = QName.createQName((String)"wpi", (String)itemNodeRef.toString());
                    this.nodeService.addChild(workflowPackageNodeRef, itemNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, workflowPackageItemId);
                }
            }
            catch (Exception e) {
                throw new ApiException("Error while adding items to package: " + e.getMessage(), e);
            }
        }
        Map variables = this.getPropertyConverter().getStartVariables(processDefinitionId, startParams);
        variables.put("cancelled", Boolean.FALSE);
        Object companyHome = this.getNodeConverter().convertNode(this.repositoryHelper.getCompanyHome());
        variables.put("companyhome", companyHome);
        NodeRef initiator = this.getPersonNodeRef(currentUserName);
        if (initiator != null) {
            variables.put("initiator", this.nodeConverter.convertNode(initiator));
            NodeRef initiatorHome = (NodeRef)this.nodeService.getProperty(initiator, ContentModel.PROP_HOMEFOLDER);
            if (initiatorHome != null) {
                variables.put("initiatorhome", this.nodeConverter.convertNode(initiatorHome));
            }
        }
        if (this.tenantService.isEnabled()) {
            variables.put("_tenant_domain", TenantUtil.getCurrentDomain());
        }
        if (!(processInstance = runtimeService.startProcessInstanceById(processDefinitionId, process.getBusinessKey(), variables)).isEnded()) {
            runtimeService.setVariable(processInstance.getProcessInstanceId(), "_startTaskCompleted", (Object)new Date());
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        return this.createProcessInfo(historicProcessInstance);
    }

    @Override
    public void deleteProcess(String id) {
        this.validateIfUserAllowedToWorkWithProcess(id);
        ProcessInstance processInstance = (ProcessInstance)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(id).singleResult();
        if (processInstance == null) {
            throw new EntityNotFoundException(id);
        }
        this.activitiProcessEngine.getRuntimeService().deleteProcessInstance(id, "deleted through REST API call");
    }

    @Override
    public CollectionWithPagingInfo<Item> getItems(String processId, Paging paging) {
        if (processId == null) {
            throw new InvalidArgumentException("processId is required to get the attached items of a process instance");
        }
        this.validateIfUserAllowedToWorkWithProcess(processId);
        return this.getItemsFromProcess(processId, paging);
    }

    @Override
    public Item getItem(String processId, String itemId) {
        if (processId == null) {
            throw new InvalidArgumentException("processId is required to get the attached item of a process instance");
        }
        if (itemId == null) {
            throw new InvalidArgumentException("itemId is required to get an attached item");
        }
        this.validateIfUserAllowedToWorkWithProcess(processId);
        return this.getItemFromProcess(itemId, processId);
    }

    @Override
    public Item createItem(String processId, Item item) {
        if (processId == null) {
            throw new InvalidArgumentException("processId is required to add an attached item to a process instance");
        }
        if (item == null || item.getId() == null) {
            throw new InvalidArgumentException("itemId is required to add an attached item");
        }
        this.validateIfUserAllowedToWorkWithProcess(processId);
        return this.createItemInProcess(item.getId(), processId);
    }

    @Override
    public void deleteItem(String processId, String itemId) {
        if (processId == null) {
            throw new InvalidArgumentException("processId is required to delete an attached item to a process instance");
        }
        if (itemId == null) {
            throw new InvalidArgumentException("itemId is required to delete an attached item");
        }
        this.validateIfUserAllowedToWorkWithProcess(processId);
        this.deleteItemFromProcess(itemId, processId);
    }

    @Override
    public CollectionWithPagingInfo<Variable> getVariables(String processId, Paging paging) {
        CollectionWithPagingInfo<Variable> result = null;
        List<HistoricVariableInstance> variableInstances = this.validateIfUserAllowedToWorkWithProcess(processId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (HistoricVariableInstance variable : variableInstances) {
            variables.put(variable.getVariableName(), variable.getValue());
        }
        ProcessInstance processInstance = (ProcessInstance)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processId).singleResult();
        String processDefinitionId = null;
        if (processInstance != null) {
            processDefinitionId = processInstance.getProcessDefinitionId();
        } else {
            HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processId).singleResult();
            if (historicInstance == null) {
                throw new EntityNotFoundException(processId);
            }
            processDefinitionId = historicInstance.getProcessDefinitionId();
        }
        String formKey = null;
        StartFormData startFormData = this.activitiProcessEngine.getFormService().getStartFormData(processDefinitionId);
        if (startFormData != null) {
            formKey = startFormData.getFormKey();
        }
        TypeDefinition startTaskTypeDefinition = this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, true);
        List<Variable> resultingVariables = this.restVariableHelper.getVariables(variables, startTaskTypeDefinition);
        result = CollectionWithPagingInfo.asPaged(paging, resultingVariables);
        return result;
    }

    @Override
    public Variable updateVariable(String processId, Variable variable) {
        this.validateIfUserAllowedToWorkWithProcess(processId);
        ProcessInstance processInstance = (ProcessInstance)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processId).singleResult();
        if (processInstance == null) {
            throw new EntityNotFoundException(processId);
        }
        return this.updateVariableInProcess(processId, processInstance.getProcessDefinitionId(), variable);
    }

    @Override
    public List<Variable> updateVariables(String processId, List<Variable> variables) {
        this.validateIfUserAllowedToWorkWithProcess(processId);
        ProcessInstance processInstance = (ProcessInstance)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processId).singleResult();
        if (processInstance == null) {
            throw new EntityNotFoundException(processId);
        }
        ArrayList<Variable> updatedVariables = new ArrayList<Variable>();
        if (variables != null) {
            for (Variable variable : variables) {
                updatedVariables.add(this.updateVariableInProcess(processId, processInstance.getProcessDefinitionId(), variable));
            }
        }
        return updatedVariables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Variable updateVariableInProcess(String processId, String processDefinitionId, Variable variable) {
        if (variable.getName() == null) {
            throw new InvalidArgumentException("Variable name is required.");
        }
        String formKey = null;
        StartFormData startFormData = this.activitiProcessEngine.getFormService().getStartFormData(processDefinitionId);
        if (startFormData != null) {
            formKey = startFormData.getFormKey();
        }
        DataTypeDefinition dataTypeDefinition = null;
        TypeDefinition startTaskTypeDefinition = this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, true);
        TypeDefinitionContext context = new TypeDefinitionContext(startTaskTypeDefinition, this.getQNameConverter());
        if (context.getPropertyDefinition(variable.getName()) != null) {
            dataTypeDefinition = context.getPropertyDefinition(variable.getName()).getDataType();
            if (variable.getType() != null && !dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService).equals(variable.getType())) {
                throw new InvalidArgumentException("type of variable " + variable.getName() + " should be " + dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
            }
        } else if (context.getAssociationDefinition(variable.getName()) != null) {
            dataTypeDefinition = this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF);
        }
        if (dataTypeDefinition == null && variable.getType() != null) {
            try {
                QName dataType = QName.createQName((String)variable.getType(), (NamespacePrefixResolver)this.namespaceService);
                dataTypeDefinition = this.dictionaryService.getDataType(dataType);
            }
            catch (InvalidQNameException iqne) {
                throw new InvalidArgumentException("Unsupported type of variable: '" + variable.getType() + "'.");
            }
        } else if (dataTypeDefinition == null) {
            dataTypeDefinition = this.dictionaryService.getDataType(this.restVariableHelper.extractTypeFromValue(variable.getValue()));
        }
        if (dataTypeDefinition == null) {
            throw new InvalidArgumentException("Unsupported type of variable: '" + variable.getType() + "'.");
        }
        Object actualValue = null;
        if ("java.util.Date".equalsIgnoreCase(dataTypeDefinition.getJavaClassName())) {
            actualValue = ISO8601DateFormat.parse((String)((String)variable.getValue()));
        } else if (variable.getName().equals("initiator")) {
            NodeRef initiator = this.getNodeRef((String)variable.getValue());
            if (!this.nodeService.exists(initiator)) throw new InvalidArgumentException("Variable value should be a valid person NodeRef.");
            actualValue = this.getNodeConverter().convertNode(initiator);
            NodeRef initiatorHome = (NodeRef)this.nodeService.getProperty(initiator, ContentModel.PROP_HOMEFOLDER);
            if (initiatorHome != null) {
                Variable initiatorHomeVar = new Variable();
                initiatorHomeVar.setName("initiatorhome");
                initiatorHomeVar.setValue(initiatorHome);
                this.updateVariableInProcess(processId, processDefinitionId, initiatorHomeVar);
            }
        } else {
            actualValue = context.getAssociationDefinition(variable.getName()) != null ? this.convertAssociationDefinitionValue(context.getAssociationDefinition(variable.getName()), variable.getName(), variable.getValue()) : DefaultTypeConverter.INSTANCE.convert(dataTypeDefinition, variable.getValue());
        }
        this.activitiProcessEngine.getRuntimeService().setVariable(processId, variable.getName(), actualValue);
        if (actualValue instanceof ActivitiScriptNode) {
            variable.setValue(((ActivitiScriptNode)actualValue).getNodeRef());
        } else {
            variable.setValue(actualValue);
        }
        variable.setType(dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        return variable;
    }

    @Override
    public void deleteVariable(String processId, String variableName) {
        this.validateIfUserAllowedToWorkWithProcess(processId);
        if (variableName == null) {
            throw new InvalidArgumentException("Variable name is required.");
        }
        try {
            if (!this.activitiProcessEngine.getRuntimeService().hasVariable(processId, variableName)) {
                throw new EntityNotFoundException(variableName);
            }
            this.activitiProcessEngine.getRuntimeService().removeVariable(processId, variableName);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new EntityNotFoundException(processId);
        }
    }

    @Override
    public BinaryResource getProcessImage(String processId) {
        this.validateIfUserAllowedToWorkWithProcess(processId);
        ProcessInstance processInstance = (ProcessInstance)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processId).singleResult();
        if (processInstance == null) {
            throw new EntityNotFoundException(processId);
        }
        try {
            BpmnModel model = this.activitiProcessEngine.getRepositoryService().getBpmnModel(processInstance.getProcessDefinitionId());
            if (model != null && model.getLocationMap().size() > 0) {
                List activeActivities = this.activitiProcessEngine.getRuntimeService().getActiveActivityIds(processId);
                DefaultProcessDiagramGenerator generator = new DefaultProcessDiagramGenerator();
                InputStream generateDiagram = generator.generateDiagram(model, "png", activeActivities);
                File file = TempFileProvider.createTempFile((String)(processId + UUID.randomUUID()), (String)".png");
                FileOutputStream fos = new FileOutputStream(file);
                IOUtils.copy((InputStream)generateDiagram, (OutputStream)fos);
                fos.close();
                return new FileBinaryResource(file);
            }
            throw new EntityNotFoundException(processId + "/image");
        }
        catch (IOException error) {
            throw new ApiException("Error while getting process image.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convertAssociationDefinitionValue(AssociationDefinition associationDef, String variableName, Object variableValue) {
        if (variableValue != null && ContentModel.TYPE_PERSON.equals((Object)associationDef.getTargetClass().getName())) {
            if (associationDef.isTargetMany()) {
                if (!(variableValue instanceof List)) throw new InvalidArgumentException(variableName + " should have an array value");
                ArrayList<NodeRef> personList = new ArrayList<NodeRef>();
                List values = (List)variableValue;
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    NodeRef personRef = this.getPersonNodeRef(value.toString());
                    if (personRef == null) {
                        throw new InvalidArgumentException(value.toString() + " is not a valid person user id");
                    }
                    personList.add(personRef);
                }
                return personList;
            }
            NodeRef personRef = this.getPersonNodeRef(variableValue.toString());
            if (personRef != null) return personRef;
            throw new InvalidArgumentException(variableValue.toString() + " is not a valid person user id");
        }
        if (variableValue == null) return variableValue;
        if (!ContentModel.TYPE_AUTHORITY_CONTAINER.equals((Object)associationDef.getTargetClass().getName())) return variableValue;
        if (associationDef.isTargetMany()) {
            if (!(variableValue instanceof List)) throw new InvalidArgumentException(variableName + " should have an array value");
            ArrayList<NodeRef> authorityList = new ArrayList<NodeRef>();
            List values = (List)variableValue;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                NodeRef authorityRef = this.authorityService.getAuthorityNodeRef(value.toString());
                if (authorityRef == null) {
                    throw new InvalidArgumentException(value.toString() + " is not a valid authority id");
                }
                authorityList.add(authorityRef);
            }
            return authorityList;
        }
        NodeRef authorityRef = this.authorityService.getAuthorityNodeRef(variableValue.toString());
        if (authorityRef != null) return authorityRef;
        throw new InvalidArgumentException(variableValue.toString() + " is not a valid authority id");
    }

    protected String getProcessDefinitionKey(String paramProcessDefinitionKey) {
        Object processDefinitionKey = null;
        processDefinitionKey = this.tenantService.isEnabled() && this.deployWorkflowsInTenant ? "@" + TenantUtil.getCurrentDomain() + "@" + paramProcessDefinitionKey : paramProcessDefinitionKey;
        return processDefinitionKey;
    }

    protected String getLocalProcessDefinitionKey(String key) {
        String processDefKey = null;
        processDefKey = this.tenantService.isEnabled() && this.deployWorkflowsInTenant ? key.substring(key.lastIndexOf("@") + 1) : key;
        return processDefKey;
    }

    protected NodeRef getPersonNodeRef(String name) {
        NodeRef authority = null;
        if (name != null && this.personService.personExists(name)) {
            authority = this.personService.getPerson(name);
        }
        return authority;
    }

    protected ProcessInfo createProcessInfo(HistoricProcessInstance processInstance) {
        ProcessInfo processInfo = new ProcessInfo(processInstance);
        ProcessDefinition definitionEntity = this.activitiProcessEngine.getRepositoryService().getProcessDefinition(processInstance.getProcessDefinitionId());
        processInfo.setProcessDefinitionKey(this.getLocalProcessDefinitionKey(definitionEntity.getKey()));
        return processInfo;
    }
}

