/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters.where;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;

public abstract class QueryHelper {
    private static final String SINGLE_QUOTE = "'";

    public static void walk(Query query, WalkerCallback callback) {
        CommonTree tree = query.getTree();
        if (tree != null) {
            LinkedList<CommonTree> stack = new LinkedList<CommonTree>();
            stack.push(tree);
            QueryHelper.callbackTree((Tree)tree, callback, false);
        }
    }

    protected static void callbackTree(Tree tree, WalkerCallback callback, boolean negated) {
        if (tree != null) {
            switch (tree.getType()) {
                case 9: {
                    if (23 != tree.getChild(0).getType()) break;
                    callback.exists(tree.getChild(0).getText(), negated);
                    return;
                }
                case 20: {
                    if (23 != tree.getChild(0).getType()) break;
                    callback.matches(tree.getChild(0).getText(), QueryHelper.stripQuotes(tree.getChild(1).getText()), negated);
                    return;
                }
                case 16: {
                    if (23 != tree.getChild(0).getType()) break;
                    List<Tree> children = QueryHelper.getChildren(tree);
                    String[] inVals = new String[children.size() - 1];
                    for (int i = 1; i < children.size(); ++i) {
                        inVals[i - 1] = QueryHelper.stripQuotes(children.get(i).getText());
                    }
                    callback.in(tree.getChild(0).getText(), negated, inVals);
                    return;
                }
                case 5: {
                    if (23 != tree.getChild(0).getType()) break;
                    callback.between(tree.getChild(0).getText(), QueryHelper.stripQuotes(tree.getChild(1).getText()), QueryHelper.stripQuotes(tree.getChild(2).getText()), negated);
                    return;
                }
                case 8: 
                case 10: 
                case 11: 
                case 18: 
                case 19: {
                    if (23 != tree.getChild(0).getType() || 24 != tree.getChild(1).getType()) break;
                    callback.comparison(tree.getType(), tree.getChild(0).getText(), QueryHelper.stripQuotes(tree.getChild(1).getText()), negated);
                    return;
                }
                case 21: {
                    QueryHelper.callbackTree(tree.getChild(0), callback, true);
                    return;
                }
                case 22: {
                    callback.or();
                    List<Tree> children = QueryHelper.getChildren(tree);
                    for (Tree child : children) {
                        QueryHelper.callbackTree(child, callback, negated);
                    }
                    return;
                }
                case 4: {
                    callback.and();
                    List<Tree> childrenOfAnd = QueryHelper.getChildren(tree);
                    for (Tree child : childrenOfAnd) {
                        QueryHelper.callbackTree(child, callback, negated);
                    }
                    return;
                }
            }
            QueryHelper.callbackTree(tree.getChild(0), callback, negated);
        }
    }

    public static List<Tree> getChildren(Tree tree) {
        if (tree != null && tree.getChildCount() > 0) {
            ArrayList<Tree> children = new ArrayList<Tree>(tree.getChildCount());
            for (int i = 0; i < tree.getChildCount(); ++i) {
                Tree child = tree.getChild(i);
                children.add(child);
            }
            return children;
        }
        return Collections.emptyList();
    }

    public static String stripQuotes(String toBeStripped) {
        if (StringUtils.isNotEmpty((CharSequence)toBeStripped) && toBeStripped.startsWith(SINGLE_QUOTE) && toBeStripped.endsWith(SINGLE_QUOTE)) {
            return toBeStripped.substring(1, toBeStripped.length() - 1);
        }
        return toBeStripped;
    }

    public static interface WalkerCallback {
        public void exists(String var1, boolean var2);

        public void between(String var1, String var2, String var3, boolean var4);

        public void comparison(int var1, String var2, String var3, boolean var4);

        public void in(String var1, boolean var2, String ... var3);

        public void matches(String var1, String var2, boolean var3);

        public void and();

        public void or();
    }

    public static class WalkerCallbackAdapter
    implements WalkerCallback {
        private static final String UNSUPPORTED_TEXT = "Unsupported Predicate";
        protected static final InvalidQueryException UNSUPPORTED = new InvalidQueryException((Object)"Unsupported Predicate");

        @Override
        public void exists(String propertyName, boolean negated) {
            throw UNSUPPORTED;
        }

        @Override
        public void between(String propertyName, String firstValue, String secondValue, boolean negated) {
            throw UNSUPPORTED;
        }

        @Override
        public void comparison(int type, String propertyName, String propertyValue, boolean negated) {
            throw UNSUPPORTED;
        }

        @Override
        public void in(String propertyName, boolean negated, String ... propertyValues) {
            throw UNSUPPORTED;
        }

        @Override
        public void matches(String property, String value, boolean negated) {
            throw UNSUPPORTED;
        }

        @Override
        public void and() {
            throw UNSUPPORTED;
        }

        @Override
        public void or() {
            throw UNSUPPORTED;
        }
    }
}

