/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.query.PagingResults;
import org.alfresco.rest.framework.resource.SerializablePagedCollection;
import org.alfresco.rest.framework.resource.parameters.ArrayListPage;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.Experimental;
import org.alfresco.util.Pair;

@Experimental
public interface ListPage<E>
extends List<E>,
PagingResults<E>,
SerializablePagedCollection<E> {
    default public List<E> getPage() {
        return this;
    }

    default public Pair<Integer, Integer> getTotalResultCount() {
        return new Pair((Object)this.getTotalItems(), (Object)this.getTotalItems());
    }

    @Override
    default public Collection<E> getCollection() {
        return this;
    }

    public static <E> CollectionWithPagingInfo<E> of(List<? extends E> list, Paging paging) {
        if (list == null) {
            return CollectionWithPagingInfo.asPaged(paging, Collections.emptyList());
        }
        return CollectionWithPagingInfo.from(new ArrayListPage<E>(list, paging));
    }
}

