/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.rest.api.search.context.SearchContext;
import org.alfresco.rest.framework.resource.parameters.ListPage;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.Experimental;

@Experimental
public class ArrayListPage<E>
extends ArrayList<E>
implements ListPage<E> {
    private final Paging paging;
    private final int totalItems;
    private final boolean hasMore;

    public ArrayListPage(List<? extends E> list) {
        super(list != null ? list : Collections.emptyList());
        this.paging = null;
        this.totalItems = this.size();
        this.hasMore = false;
    }

    public ArrayListPage(List<? extends E> list, Paging paging) {
        super(ArrayListPage.sublistFrom(list, paging));
        this.paging = paging;
        if (list != null) {
            this.totalItems = list.size();
            if (paging != null) {
                int start = paging.getSkipCount();
                int end = paging.getMaxItems() == 0 ? list.size() : Math.min(list.size(), start + paging.getMaxItems());
                this.hasMore = list.size() != end;
            } else {
                this.hasMore = false;
            }
        } else {
            this.totalItems = 0;
            this.hasMore = false;
        }
    }

    @Override
    public Paging getPaging() {
        return this.paging;
    }

    @Override
    public Integer getTotalItems() {
        return this.totalItems;
    }

    @Override
    public boolean hasMoreItems() {
        return this.hasMore;
    }

    public String getQueryExecutionId() {
        return null;
    }

    @Override
    public Object getSourceEntity() {
        return null;
    }

    @Override
    public SearchContext getContext() {
        return null;
    }

    private static <E> List<? extends E> sublistFrom(List<? extends E> list, Paging paging) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (paging == null) {
            return list;
        }
        int start = paging.getSkipCount();
        int end = paging.getMaxItems() == 0 ? list.size() : Math.min(list.size(), start + paging.getMaxItems());
        return list.subList(Math.min(start, end), end);
    }
}

