/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search.context;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;

public class FacetFieldContext {
    private final String label;
    private final List<Bucket> buckets;

    public FacetFieldContext(String label, List<Bucket> buckets) {
        this.label = label;
        this.buckets = buckets;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public static class Bucket {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final String label;
        private final String filterQuery;
        private final int count;
        private final Object display;

        public Bucket(String label, String filterQuery, int count, Object display) {
            this.label = label;
            this.filterQuery = filterQuery;
            this.count = count;
            this.display = display;
        }

        public String getFilterQuery() {
            return this.filterQuery;
        }

        public Object getDisplay() {
            return this.display;
        }

        public String getLabel() {
            return this.label;
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket = (Bucket)o;
            if (this.count != bucket.count) {
                return false;
            }
            if (this.label != null ? !this.label.equals(bucket.label) : bucket.label != null) {
                return false;
            }
            if (this.filterQuery != null ? !this.filterQuery.equals(bucket.filterQuery) : bucket.filterQuery != null) {
                return false;
            }
            return !(this.display != null ? !this.display.equals(bucket.display) : bucket.display != null);
        }

        public int hashCode() {
            int result = this.label != null ? this.label.hashCode() : 0;
            result = 31 * result + (this.filterQuery != null ? this.filterQuery.hashCode() : 0);
            result = 31 * result + this.count;
            result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Bucket{label='" + this.label + "', filterQuery='" + this.filterQuery + "', count=" + this.count + ", display=" + this.display + "}";
        }
    }
}

