/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model.rules;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.alfresco.rest.api.model.rules.InclusionType;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.NodeRef;

@Experimental
public class RuleSet {
    public static final String DEFAULT_ID = "-default-";
    private String id;
    private NodeRef owningFolder;
    private InclusionType inclusionType;
    private List<NodeRef> inheritedBy;
    private List<NodeRef> linkedToBy;
    private Boolean isInherited;
    private Boolean isLinkedTo;
    private List<String> ruleIds;

    public static RuleSet of(String id) {
        return RuleSet.builder().id(id).create();
    }

    public static boolean isNotDefaultId(String id) {
        return !RuleSet.isDefaultId(id);
    }

    public static boolean isDefaultId(String id) {
        return DEFAULT_ID.equals(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NodeRef getOwningFolder() {
        return this.owningFolder;
    }

    public void setOwningFolder(NodeRef owningFolder) {
        this.owningFolder = owningFolder;
    }

    public InclusionType getInclusionType() {
        return this.inclusionType;
    }

    public void setInclusionType(InclusionType inclusionType) {
        this.inclusionType = inclusionType;
    }

    public List<NodeRef> getInheritedBy() {
        return this.inheritedBy;
    }

    public void setInheritedBy(List<NodeRef> inheritedBy) {
        this.inheritedBy = inheritedBy;
    }

    public List<NodeRef> getLinkedToBy() {
        return this.linkedToBy;
    }

    public void setLinkedToBy(List<NodeRef> linkedToBy) {
        this.linkedToBy = linkedToBy;
    }

    public void setIsInherited(Boolean inherited) {
        this.isInherited = inherited;
    }

    public Boolean getIsInherited() {
        return this.isInherited;
    }

    public void setIsLinkedTo(Boolean isLinkedTo) {
        this.isLinkedTo = isLinkedTo;
    }

    public Boolean getIsLinkedTo() {
        return this.isLinkedTo;
    }

    public List<String> getRuleIds() {
        return this.ruleIds;
    }

    public void setRuleIds(List<String> ruleIds) {
        this.ruleIds = ruleIds;
    }

    public String toString() {
        return "RuleSet{" + new StringJoiner(", ").add("id='" + this.id + "'").add("owningFolder='" + this.owningFolder + "'").add("inclusionType='" + this.inclusionType + "'").add("inheritedBy='" + this.inheritedBy + "'").add("linkedToBy='" + this.linkedToBy + "'").add("isInherited='" + this.isInherited + "'").add("isLinkedTo='" + this.isLinkedTo + "'").add("ruleIds='" + this.ruleIds + "'").toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSet ruleSet = (RuleSet)o;
        return Objects.equals(this.id, ruleSet.id) && Objects.equals(this.owningFolder, ruleSet.owningFolder) && this.inclusionType == ruleSet.inclusionType && Objects.equals(this.inheritedBy, ruleSet.inheritedBy) && Objects.equals(this.linkedToBy, ruleSet.linkedToBy) && Objects.equals(this.isInherited, ruleSet.isInherited) && Objects.equals(this.isLinkedTo, ruleSet.isLinkedTo) && Objects.equals(this.ruleIds, ruleSet.ruleIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.owningFolder, this.inclusionType, this.inheritedBy, this.linkedToBy, this.isInherited, this.isLinkedTo, this.ruleIds});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private NodeRef owningFolder;
        private InclusionType inclusionType;
        private List<NodeRef> inheritedBy;
        private List<NodeRef> linkedToBy;
        private Boolean isInherited;
        private Boolean isLinkedTo;
        private List<String> ruleIds;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder owningFolder(NodeRef owningFolder) {
            this.owningFolder = owningFolder;
            return this;
        }

        public Builder inclusionType(InclusionType inclusionType) {
            this.inclusionType = inclusionType;
            return this;
        }

        public Builder inheritedBy(List<NodeRef> inheritedBy) {
            this.inheritedBy = inheritedBy;
            return this;
        }

        public Builder linkedToBy(List<NodeRef> linkedToBy) {
            this.linkedToBy = linkedToBy;
            return this;
        }

        public Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        public Builder isLinkedTo(Boolean isLinkedTo) {
            this.isLinkedTo = isLinkedTo;
            return this;
        }

        public Builder ruleIds(List<String> ruleIds) {
            this.ruleIds = ruleIds;
            return this;
        }

        public RuleSet create() {
            RuleSet ruleSet = new RuleSet();
            ruleSet.setId(this.id);
            ruleSet.setOwningFolder(this.owningFolder);
            ruleSet.setInclusionType(this.inclusionType);
            ruleSet.setInheritedBy(this.inheritedBy);
            ruleSet.setLinkedToBy(this.linkedToBy);
            ruleSet.setIsInherited(this.isInherited);
            ruleSet.setIsLinkedTo(this.isLinkedTo);
            ruleSet.setRuleIds(this.ruleIds);
            return ruleSet;
        }
    }
}

