/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.site.SiteVisibility;

public class SiteUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    private String description;
    private SiteVisibility visibility;
    private Map<String, Boolean> setFields = new HashMap<String, Boolean>(3);
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String VISIBILITY = "visibility";

    public SiteUpdate() {
    }

    public SiteUpdate(String title, String description, SiteVisibility visibility) {
        this.setTitle(title);
        this.setDescription(description);
        this.setVisibility(visibility);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setFields.put(TITLE, true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setFields.put(DESCRIPTION, true);
    }

    public SiteVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(SiteVisibility visibility) {
        this.visibility = visibility;
        this.setFields.put(VISIBILITY, true);
    }

    public boolean wasSet(String fieldName) {
        Boolean b = this.setFields.get(fieldName);
        return b != null ? b : false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteUpdate that = (SiteUpdate)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return this.visibility == that.visibility;
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SiteUpdate{title='" + this.title + "', description='" + this.description + "', visibility=" + this.visibility + "}";
    }
}

