/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;

public class Site
implements Comparable<Site> {
    protected String id;
    protected String guid;
    protected String title;
    protected String description;
    protected SiteVisibility visibility;
    protected String preset;
    protected String role;
    private Map<String, Boolean> setFields = new HashMap<String, Boolean>(7);
    public static final String ID = "id";
    public static final String GUID = "guid";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String VISIBILITY = "visibility";
    public static final String PRESET = "preset";
    public static final String ROLE = "role";

    public Site() {
    }

    public Site(SiteInfo siteInfo, String role) {
        if (siteInfo == null) {
            throw new IllegalArgumentException("Must provide siteInfo");
        }
        this.setId(siteInfo.getShortName());
        this.setGuid(siteInfo.getNodeRef().getId());
        this.setTitle(siteInfo.getTitle());
        this.setDescription(siteInfo.getDescription());
        this.setVisibility(siteInfo.getVisibility());
        this.setPreset(siteInfo.getSitePreset());
        this.setRole(role);
    }

    @UniqueId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.setFields.put(ID, true);
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
        this.setFields.put(GUID, true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setFields.put(TITLE, true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setFields.put(DESCRIPTION, true);
    }

    public SiteVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(SiteVisibility visibility) {
        this.visibility = visibility;
        this.setFields.put(VISIBILITY, true);
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
        this.setFields.put(PRESET, true);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
        this.setFields.put(ROLE, true);
    }

    public boolean wasSet(String fieldName) {
        Boolean b = this.setFields.get(fieldName);
        return b != null ? b : false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Site other = (Site)obj;
        return this.id.equals(other.id);
    }

    @Override
    public int compareTo(Site site) {
        return this.id.compareTo(site.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public String toString() {
        return "Site [id=" + this.id + ", guid=" + this.guid + ", title=" + this.title + ", description=" + this.description + ", visibility=" + this.visibility + "]";
    }
}

