/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.Date;
import java.util.List;
import org.alfresco.rest.api.model.Network;
import org.alfresco.rest.api.model.Quota;
import org.alfresco.rest.framework.resource.UniqueId;

public class PersonNetwork
implements Network,
Comparable<PersonNetwork> {
    private Boolean homeNetwork;
    private Network network;

    public PersonNetwork() {
    }

    public PersonNetwork(Boolean homeNetwork, Network network) {
        this.homeNetwork = homeNetwork;
        this.network = network;
    }

    @Override
    @UniqueId
    public String getId() {
        return this.network.getId();
    }

    @Override
    public Date getCreatedAt() {
        return this.network.getCreatedAt();
    }

    @Override
    public List<Quota> getQuotas() {
        return this.network.getQuotas();
    }

    @Override
    public Boolean getIsEnabled() {
        return this.network.getIsEnabled();
    }

    @Override
    public String getSubscriptionLevel() {
        return this.network.getSubscriptionLevel();
    }

    @Override
    public Boolean getPaidNetwork() {
        return this.network.getPaidNetwork();
    }

    @Override
    public int compareTo(PersonNetwork member) {
        int ret = this.getId().compareTo(member.getId());
        return ret;
    }

    public Boolean getHomeNetwork() {
        return this.homeNetwork;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersonNetwork other = (PersonNetwork)obj;
        return !(this.network == null ? other.network != null : !this.network.equals(other.network));
    }

    public String toString() {
        return "PersonNetwork [homeNetwork=" + this.homeNetwork + ", network=" + this.network + "]";
    }
}

