/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.model.Company;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class Person
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String userName;
    protected Boolean enabled;
    protected NodeRef avatarId;
    protected String firstName;
    protected String lastName;
    protected String displayName;
    protected String jobTitle;
    protected String location;
    protected String telephone;
    protected String mobile;
    protected String email;
    protected String skypeId;
    protected String instantMessageId;
    protected String userStatus;
    protected Date statusUpdatedAt;
    protected String googleId;
    protected Long quota;
    protected Long quotaUsed;
    protected Boolean emailNotificationsEnabled;
    protected String description;
    protected transient Company company;
    protected String password;
    protected String oldPassword;
    protected transient Map<String, Object> properties;
    protected transient List<String> aspectNames;
    protected Map<String, Boolean> capabilities;
    private Map<QName, Boolean> setFields = new HashMap<QName, Boolean>(7);
    public static final QName PROP_PERSON_DESCRIPTION = QName.createQName((String)"RestApi", (String)"description");
    public static final QName PROP_PERSON_COMPANY = QName.createQName((String)"RestApi", (String)"company");
    public static final QName PROP_PERSON_AVATAR_ID = QName.createQName((String)"RestApi", (String)"avatarId");
    public static final QName PROP_PERSON_OLDPASSWORD = QName.createQName((String)"RestApi", (String)"oldPassword");
    public static final QName PROP_PERSON_PASSWORD = QName.createQName((String)"RestApi", (String)"password");

    public Person() {
    }

    public Person(String userName, Boolean enabled, NodeRef avatarId, String firstName, String lastName, String jobTitle, String location, String telephone, String mobile, String email, String skypeId, String instantMessageId, String userStatus, Date statusUpdatedAt, String googleId, Long quota, Long quotaUsed, Boolean emailNotificationsEnabled, String description, Company company) {
        this.setUserName(userName);
        this.setEnabled(enabled);
        this.setAvatarId(avatarId);
        this.setFirstName(firstName);
        this.setLastName(lastName);
        this.setJobTitle(jobTitle);
        this.setLocation(location);
        this.setTelephone(telephone);
        this.setMobile(mobile);
        if (email != null) {
            this.setEmail(email);
        }
        this.setSkypeId(skypeId);
        this.setInstantMessageId(instantMessageId);
        this.setUserStatus(userStatus);
        this.setGoogleId(googleId);
        this.setEmailNotificationsEnabled(emailNotificationsEnabled);
        this.setDescription(description);
        this.setCompany(company);
        this.setStatusUpdatedAt(statusUpdatedAt);
        this.setQuota(quota);
        this.updateDisplayName();
        if (quotaUsed != null) {
            this.setQuotaUsed(quotaUsed);
        }
    }

    public Person(NodeRef nodeRef, Map<QName, Serializable> nodeProps, boolean enabled) {
        this.mapProperties(nodeProps);
        this.enabled = enabled;
        this.updateDisplayName();
    }

    protected void mapProperties(Map<QName, Serializable> nodeProps) {
        nodeProps.remove(ContentModel.PROP_CONTENT);
        this.setUserName((String)((Object)nodeProps.get(ContentModel.PROP_USERNAME)));
        this.setFirstName((String)((Object)nodeProps.get(ContentModel.PROP_FIRSTNAME)));
        this.setLastName((String)((Object)nodeProps.get(ContentModel.PROP_LASTNAME)));
        this.setJobTitle((String)((Object)nodeProps.get(ContentModel.PROP_JOBTITLE)));
        this.setLocation((String)((Object)nodeProps.get(ContentModel.PROP_LOCATION)));
        this.setTelephone((String)((Object)nodeProps.get(ContentModel.PROP_TELEPHONE)));
        this.setMobile((String)((Object)nodeProps.get(ContentModel.PROP_MOBILE)));
        this.setEmail((String)((Object)nodeProps.get(ContentModel.PROP_EMAIL)));
        String organization = (String)((Object)nodeProps.get(ContentModel.PROP_ORGANIZATION));
        String companyAddress1 = (String)((Object)nodeProps.get(ContentModel.PROP_COMPANYADDRESS1));
        String companyAddress2 = (String)((Object)nodeProps.get(ContentModel.PROP_COMPANYADDRESS2));
        String companyAddress3 = (String)((Object)nodeProps.get(ContentModel.PROP_COMPANYADDRESS3));
        String companyPostcode = (String)((Object)nodeProps.get(ContentModel.PROP_COMPANYPOSTCODE));
        String companyTelephone = (String)((Object)nodeProps.get(ContentModel.PROP_COMPANYTELEPHONE));
        String companyFax = (String)((Object)nodeProps.get(ContentModel.PROP_COMPANYFAX));
        String companyEmail = (String)((Object)nodeProps.get(ContentModel.PROP_COMPANYEMAIL));
        this.setCompany(new Company(organization, companyAddress1, companyAddress2, companyAddress3, companyPostcode, companyTelephone, companyFax, companyEmail));
        this.setSkypeId((String)((Object)nodeProps.get(ContentModel.PROP_SKYPE)));
        this.setInstantMessageId((String)((Object)nodeProps.get(ContentModel.PROP_INSTANTMSG)));
        this.setUserStatus((String)((Object)nodeProps.get(ContentModel.PROP_USER_STATUS)));
        this.setGoogleId((String)((Object)nodeProps.get(ContentModel.PROP_GOOGLEUSERNAME)));
        Boolean bool = (Boolean)nodeProps.get(ContentModel.PROP_EMAIL_FEED_DISABLED);
        this.setEmailNotificationsEnabled(bool == null ? Boolean.TRUE : bool == false);
        this.setDescription((String)((Object)nodeProps.get(PROP_PERSON_DESCRIPTION)));
        this.setStatusUpdatedAt((Date)nodeProps.get(ContentModel.PROP_USER_STATUS_TIME));
        this.setQuota((Long)nodeProps.get(ContentModel.PROP_SIZE_QUOTA));
        this.setQuotaUsed((Long)nodeProps.get(ContentModel.PROP_SIZE_CURRENT));
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
        this.setFields.put(PROP_PERSON_COMPANY, true);
    }

    public String getInstantMessageId() {
        return this.instantMessageId;
    }

    public void setInstantMessageId(String instantMessageId) {
        this.instantMessageId = instantMessageId;
        this.setFields.put(ContentModel.PROP_INSTANTMSG, true);
    }

    public String getGoogleId() {
        return this.googleId;
    }

    public void setGoogleId(String googleId) {
        this.googleId = googleId;
        this.setFields.put(ContentModel.PROP_GOOGLEUSERNAME, true);
    }

    public Long getQuota() {
        return this.quota;
    }

    protected void setQuota(Long quota) {
        this.quota = quota;
        this.setFields.put(ContentModel.PROP_SIZE_QUOTA, true);
    }

    public Long getQuotaUsed() {
        return this.quotaUsed;
    }

    protected void setQuotaUsed(Long quotaUsed) {
        this.quotaUsed = quotaUsed;
        this.setFields.put(ContentModel.PROP_SIZE_CURRENT, true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setFields.put(PROP_PERSON_DESCRIPTION, true);
    }

    @JsonProperty(value="id")
    @UniqueId
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.setFields.put(ContentModel.PROP_USERNAME, true);
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
        this.setFields.put(ContentModel.PROP_ENABLED, true);
    }

    public void setAvatarId(NodeRef avatarId) {
        this.avatarId = avatarId;
        this.setFields.put(PROP_PERSON_AVATAR_ID, true);
    }

    public void setPassword(String password) {
        this.password = password;
        this.setFields.put(PROP_PERSON_PASSWORD, true);
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
        this.setFields.put(PROP_PERSON_OLDPASSWORD, true);
    }

    public NodeRef getAvatarId() {
        return this.avatarId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.setFields.put(ContentModel.PROP_FIRSTNAME, true);
        this.updateDisplayName();
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.setFields.put(ContentModel.PROP_LASTNAME, true);
        this.updateDisplayName();
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        this.setFields.put(ContentModel.PROP_JOBTITLE, true);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.setFields.put(ContentModel.PROP_LOCATION, true);
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
        this.setFields.put(ContentModel.PROP_TELEPHONE, true);
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
        this.setFields.put(ContentModel.PROP_MOBILE, true);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.setFields.put(ContentModel.PROP_EMAIL, true);
    }

    public String getSkypeId() {
        return this.skypeId;
    }

    public void setSkypeId(String skypeId) {
        this.skypeId = skypeId;
        this.setFields.put(ContentModel.PROP_SKYPE, true);
    }

    public String getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(String userStatus) {
        this.userStatus = userStatus;
        this.setFields.put(ContentModel.PROP_USER_STATUS, true);
    }

    public Date getStatusUpdatedAt() {
        return this.statusUpdatedAt;
    }

    protected void setStatusUpdatedAt(Date statusUpdatedAt) {
        this.statusUpdatedAt = statusUpdatedAt;
        this.setFields.put(ContentModel.PROP_USER_STATUS_TIME, true);
    }

    public Boolean isEmailNotificationsEnabled() {
        return this.emailNotificationsEnabled;
    }

    public void setEmailNotificationsEnabled(Boolean emailNotificationsEnabled) {
        this.emailNotificationsEnabled = emailNotificationsEnabled;
        this.setFields.put(ContentModel.PROP_EMAIL_FEED_DISABLED, true);
    }

    public String getPassword() {
        return this.password;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<String> getAspectNames() {
        return this.aspectNames;
    }

    public void setAspectNames(List<String> aspectNames) {
        this.aspectNames = aspectNames;
    }

    public Map<String, Boolean> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Map<String, Boolean> capabilities) {
        this.capabilities = capabilities;
    }

    public boolean wasSet(QName fieldName) {
        Boolean b = this.setFields.get(fieldName);
        return b != null ? b : false;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "Person [userName=" + this.userName + ", enabled=" + this.enabled + ", avatarId=" + this.avatarId + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", jobTitle=" + this.jobTitle + ", location=" + this.location + ", telephone=" + this.telephone + ", mobile=" + this.mobile + ", email=" + this.email + ", skypeId=" + this.skypeId + ", instantMessageId=" + this.instantMessageId + ", userStatus=" + this.userStatus + ", statusUpdatedAt=" + this.statusUpdatedAt + ", googleId=" + this.googleId + ", quota=" + this.quota + ", quotaUsed=" + this.quotaUsed + ", emailNotificationsEnabled=" + this.emailNotificationsEnabled + ", description=" + this.description + ", company=" + this.company + "]";
    }

    public Map<QName, Serializable> toProperties() {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        this.populateProps(props);
        return props;
    }

    private void addToMap(Map<QName, Serializable> properties, QName name, Serializable value) {
        Boolean b;
        if (name != null && Boolean.TRUE.equals(b = this.setFields.get(name))) {
            properties.put(name, value);
        }
    }

    private void populateProps(Map<QName, Serializable> properties) {
        this.addToMap(properties, ContentModel.PROP_USERNAME, (Serializable)((Object)this.getUserName()));
        this.addToMap(properties, ContentModel.PROP_FIRSTNAME, (Serializable)((Object)this.getFirstName()));
        this.addToMap(properties, ContentModel.PROP_LASTNAME, (Serializable)((Object)this.getLastName()));
        this.addToMap(properties, ContentModel.PROP_JOBTITLE, (Serializable)((Object)this.getJobTitle()));
        this.addToMap(properties, ContentModel.PROP_LOCATION, (Serializable)((Object)this.getLocation()));
        this.addToMap(properties, ContentModel.PROP_TELEPHONE, (Serializable)((Object)this.getTelephone()));
        this.addToMap(properties, ContentModel.PROP_MOBILE, (Serializable)((Object)this.getMobile()));
        if (this.wasSet(ContentModel.PROP_EMAIL)) {
            this.addToMap(properties, ContentModel.PROP_EMAIL, (Serializable)((Object)this.getEmail()));
        }
        if (this.wasSet(PROP_PERSON_COMPANY)) {
            Company company = this.getCompany();
            int setCount = 0;
            if (company != null) {
                if (company.wasSet(ContentModel.PROP_ORGANIZATION)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_ORGANIZATION, (Serializable)((Object)company.getOrganization()));
                }
                if (company.wasSet(ContentModel.PROP_COMPANYADDRESS1)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_COMPANYADDRESS1, (Serializable)((Object)company.getAddress1()));
                }
                if (company.wasSet(ContentModel.PROP_COMPANYADDRESS2)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_COMPANYADDRESS2, (Serializable)((Object)company.getAddress2()));
                }
                if (company.wasSet(ContentModel.PROP_COMPANYADDRESS3)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_COMPANYADDRESS3, (Serializable)((Object)company.getAddress3()));
                }
                if (company.wasSet(ContentModel.PROP_COMPANYPOSTCODE)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_COMPANYPOSTCODE, (Serializable)((Object)company.getPostcode()));
                }
                if (company.wasSet(ContentModel.PROP_COMPANYTELEPHONE)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_COMPANYTELEPHONE, (Serializable)((Object)company.getTelephone()));
                }
                if (company.wasSet(ContentModel.PROP_COMPANYFAX)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_COMPANYFAX, (Serializable)((Object)company.getFax()));
                }
                if (company.wasSet(ContentModel.PROP_COMPANYEMAIL)) {
                    ++setCount;
                    properties.put(ContentModel.PROP_COMPANYEMAIL, (Serializable)((Object)company.getEmail()));
                }
            }
            if (setCount == 0) {
                properties.put(ContentModel.PROP_ORGANIZATION, null);
                properties.put(ContentModel.PROP_COMPANYADDRESS1, null);
                properties.put(ContentModel.PROP_COMPANYADDRESS2, null);
                properties.put(ContentModel.PROP_COMPANYADDRESS3, null);
                properties.put(ContentModel.PROP_COMPANYPOSTCODE, null);
                properties.put(ContentModel.PROP_COMPANYTELEPHONE, null);
                properties.put(ContentModel.PROP_COMPANYFAX, null);
                properties.put(ContentModel.PROP_COMPANYEMAIL, null);
            }
        }
        this.addToMap(properties, ContentModel.PROP_SKYPE, (Serializable)((Object)this.getSkypeId()));
        this.addToMap(properties, ContentModel.PROP_INSTANTMSG, (Serializable)((Object)this.getInstantMessageId()));
        this.addToMap(properties, ContentModel.PROP_USER_STATUS, (Serializable)((Object)this.getUserStatus()));
        this.addToMap(properties, ContentModel.PROP_USER_STATUS_TIME, this.getStatusUpdatedAt());
        this.addToMap(properties, ContentModel.PROP_GOOGLEUSERNAME, (Serializable)((Object)this.getGoogleId()));
        this.addToMap(properties, ContentModel.PROP_SIZE_QUOTA, this.getQuota());
        if (this.wasSet(ContentModel.PROP_SIZE_CURRENT)) {
            this.addToMap(properties, ContentModel.PROP_SIZE_CURRENT, this.getQuotaUsed());
        }
        this.addToMap(properties, ContentModel.PROP_PERSONDESC, (Serializable)((Object)this.getDescription()));
        this.addToMap(properties, ContentModel.PROP_ENABLED, this.isEnabled());
        Boolean isEmailNotificationsEnabled = this.isEmailNotificationsEnabled();
        this.addToMap(properties, ContentModel.PROP_EMAIL_FEED_DISABLED, isEmailNotificationsEnabled == null ? null : Boolean.valueOf(isEmailNotificationsEnabled == false));
    }

    private void updateDisplayName() {
        this.displayName = ((String)(this.firstName != null ? this.firstName + " " : "") + (this.lastName != null ? this.lastName : "")).trim();
    }
}

