/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;

public class CustomModelNamedValue
implements Comparable<CustomModelNamedValue> {
    private String name;
    private String simpleValue = null;
    private List<String> listValue = null;

    public CustomModelNamedValue() {
    }

    public CustomModelNamedValue(String name, Object value) {
        this.name = name;
        if (value instanceof List) {
            List values = (List)value;
            this.listValue = new ArrayList<String>(values.size());
            for (Object val : values) {
                this.listValue.add(this.convertToString(val));
            }
        } else {
            this.simpleValue = this.convertToString(value);
        }
    }

    private String convertToString(Object value) {
        try {
            return (String)DefaultTypeConverter.INSTANCE.convert(String.class, value);
        }
        catch (TypeConversionException e) {
            throw new InvalidArgumentException("Cannot convert to string '" + value + "'.");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSimpleValue() {
        return this.simpleValue;
    }

    public void setSimpleValue(String simpleValue) {
        this.simpleValue = simpleValue;
    }

    public List<String> getListValue() {
        return this.listValue;
    }

    public void setListValue(List<String> listValue) {
        this.listValue = listValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelNamedValue)) {
            return false;
        }
        CustomModelNamedValue other = (CustomModelNamedValue)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(CustomModelNamedValue other) {
        return this.name.compareTo(other.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(120);
        builder.append("CustomModelNamedValue [name=").append(this.name).append(", simpleValue=").append(this.simpleValue).append(", listValue=").append(this.listValue).append(']');
        return builder.toString();
    }
}

