/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.rest.api.Rules;
import org.alfresco.rest.api.impl.rules.ActionPermissionValidator;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.impl.rules.RuleLoader;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.Rule;
import org.alfresco.rest.api.model.rules.RuleExecution;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.ListPage;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.GUID;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class RulesImpl
implements Rules {
    private static final Logger LOGGER = LoggerFactory.getLogger(RulesImpl.class);
    private static final String MUST_HAVE_AT_LEAST_ONE_ACTION = "A rule must have at least one action";
    private ActionService actionService;
    private RuleService ruleService;
    private NodeValidator validator;
    private RuleLoader ruleLoader;
    private ActionPermissionValidator actionPermissionValidator;
    private RestModelMapper<Rule, org.alfresco.service.cmr.rule.Rule> ruleMapper;

    @Override
    public CollectionWithPagingInfo<Rule> getRules(String folderNodeId, String ruleSetId, List<String> includes, Paging paging) {
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, false);
        NodeRef ruleSetNode = this.validator.validateRuleSetNode(ruleSetId, folderNodeRef);
        NodeRef owningFolder = this.ruleService.getOwningNodeRef(ruleSetNode);
        List rules = this.ruleService.getRules(owningFolder, false).stream().map(ruleModel -> this.ruleLoader.loadRule((org.alfresco.service.cmr.rule.Rule)ruleModel, includes)).collect(Collectors.toList());
        return ListPage.of(rules, paging);
    }

    @Override
    public Rule getRuleById(String folderNodeId, String ruleSetId, String ruleId, List<String> includes) {
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, false);
        NodeRef ruleSetNodeRef = this.validator.validateRuleSetNode(ruleSetId, folderNodeRef);
        NodeRef ruleNodeRef = this.validator.validateRuleNode(ruleId, ruleSetNodeRef);
        return this.ruleLoader.loadRule(this.ruleService.getRule(ruleNodeRef), includes);
    }

    @Override
    public List<Rule> createRules(String folderNodeId, String ruleSetId, List<Rule> rules, List<String> includes) {
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, true);
        if (RuleSet.isNotDefaultId(ruleSetId)) {
            this.validator.validateRuleSetNode(ruleSetId, folderNodeRef);
        }
        return rules.stream().map(this::mapToServiceModelAndValidateActions).map(rule -> this.ruleService.saveRule(folderNodeRef, rule)).map(rule -> this.ruleLoader.loadRule((org.alfresco.service.cmr.rule.Rule)rule, includes)).collect(Collectors.toList());
    }

    @Override
    public Rule updateRuleById(String folderNodeId, String ruleSetId, String ruleId, Rule rule, List<String> includes) {
        LOGGER.debug("Updating rule in folder {}, rule set {}, rule {} to {}", new Object[]{folderNodeId, ruleSetId, ruleId, rule});
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, true);
        NodeRef ruleSetNodeRef = this.validator.validateRuleSetNode(ruleSetId, folderNodeRef);
        this.validator.validateRuleNode(ruleId, ruleSetNodeRef);
        return this.ruleLoader.loadRule(this.ruleService.saveRule(folderNodeRef, this.mapToServiceModelAndValidateActions(rule)), includes);
    }

    @Override
    public void deleteRuleById(String folderNodeId, String ruleSetId, String ruleId) {
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, true);
        NodeRef ruleSetNodeRef = this.validator.validateRuleSetNode(ruleSetId, folderNodeRef);
        NodeRef ruleNodeRef = this.validator.validateRuleNode(ruleId, ruleSetNodeRef);
        org.alfresco.service.cmr.rule.Rule rule = this.ruleService.getRule(ruleNodeRef);
        this.ruleService.removeRule(folderNodeRef, rule);
    }

    @Override
    public RuleExecution executeRules(String folderNodeId, boolean eachSubFolderIncluded) {
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, false);
        HashMap<String, Boolean> parameterValues = new HashMap<String, Boolean>();
        parameterValues.put("run-all-rules-on-children", eachSubFolderIncluded);
        parameterValues.put("execute-inherited-rules", true);
        ActionImpl action = new ActionImpl(null, GUID.generate(), "execute-all-rules");
        action.setNodeRef(folderNodeRef);
        action.setParameterValues(parameterValues);
        ActionAccessRestriction.setActionContext((Action)action, (String)"v1");
        this.actionService.executeAction((Action)action, folderNodeRef, true, false);
        return RuleExecution.builder().eachSubFolderIncluded(eachSubFolderIncluded).create();
    }

    private org.alfresco.service.cmr.rule.Rule mapToServiceModelAndValidateActions(Rule rule) {
        if (CollectionUtils.isEmpty(rule.getActions())) {
            throw new InvalidArgumentException(MUST_HAVE_AT_LEAST_ONE_ACTION);
        }
        org.alfresco.service.cmr.rule.Rule serviceModelRule = this.ruleMapper.toServiceModel(rule);
        return this.actionPermissionValidator.validateRulePermissions(serviceModelRule);
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setValidator(NodeValidator validator) {
        this.validator = validator;
    }

    public void setRuleLoader(RuleLoader ruleLoader) {
        this.ruleLoader = ruleLoader;
    }

    public void setActionPermissionValidator(ActionPermissionValidator actionPermissionValidator) {
        this.actionPermissionValidator = actionPermissionValidator;
    }

    public void setRuleMapper(RestModelMapper<Rule, org.alfresco.service.cmr.rule.Rule> ruleMapper) {
        this.ruleMapper = ruleMapper;
    }
}

