/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.rest.api.RuleSets;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.impl.rules.RuleSetLoader;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.rest.api.model.rules.RuleSetLink;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.ListPage;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class RuleSetsImpl
implements RuleSets {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSetsImpl.class);
    private RuleSetLoader ruleSetLoader;
    private RuleService ruleService;
    private NodeValidator validator;
    private NodeService nodeService;
    private RuntimeRuleService runtimeRuleService;

    @Override
    public CollectionWithPagingInfo<RuleSet> getRuleSets(String folderNodeId, List<String> includes, Paging paging) {
        NodeRef folderNode = this.validator.validateFolderNode(folderNodeId, false);
        List ruleSets = this.ruleService.getNodesSupplyingRuleSets(folderNode).stream().map(supplyingNode -> this.loadRuleSet((NodeRef)supplyingNode, folderNode, includes)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return ListPage.of(ruleSets, paging);
    }

    private RuleSet loadRuleSet(NodeRef supplyingNode, NodeRef folderNode, List<String> includes) {
        NodeRef ruleSetNode = this.ruleService.getRuleSetNode(supplyingNode);
        if (ruleSetNode == null) {
            return null;
        }
        try {
            return this.ruleSetLoader.loadRuleSet(ruleSetNode, folderNode, includes);
        }
        catch (AccessDeniedException e) {
            LOGGER.debug("User does not have permission to view rule set with id {}.", (Object)ruleSetNode, (Object)e);
            return null;
        }
    }

    @Override
    public RuleSet getRuleSetById(String folderNodeId, String ruleSetId, List<String> includes) {
        NodeRef folderNode = this.validator.validateFolderNode(folderNodeId, false);
        NodeRef ruleSetNode = this.validator.validateRuleSetNode(ruleSetId, folderNode);
        return this.ruleSetLoader.loadRuleSet(ruleSetNode, folderNode, includes);
    }

    @Override
    public RuleSet updateRuleSet(String folderNodeId, RuleSet ruleSet, List<String> includes) {
        NodeRef folderNode = this.validator.validateFolderNode(folderNodeId, false);
        NodeRef ruleSetNode = this.validator.validateRuleSetNode(ruleSet.getId(), folderNode);
        RuleSet returnedRuleSet = this.ruleSetLoader.loadRuleSet(ruleSetNode, folderNode, includes);
        List<String> suppliedRuleIds = ruleSet.getRuleIds();
        if (!CollectionUtils.isEmpty(suppliedRuleIds)) {
            HashSet<String> suppliedRuleIdSet = new HashSet<String>(suppliedRuleIds);
            HashSet<String> existingRuleIds = new HashSet<String>(this.ruleSetLoader.loadRuleIds(folderNode));
            if (suppliedRuleIdSet.size() != suppliedRuleIds.size() || !suppliedRuleIdSet.equals(existingRuleIds)) {
                throw new InvalidArgumentException("Unexpected set of rule ids - received " + suppliedRuleIds + " but expected " + existingRuleIds);
            }
            IntStream.range(0, suppliedRuleIds.size()).forEach(index -> {
                NodeRef ruleNode = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, (String)suppliedRuleIds.get(index));
                this.ruleService.setRulePosition(folderNode, ruleNode, index);
            });
            if (includes.contains("ruleIds")) {
                returnedRuleSet.setRuleIds(suppliedRuleIds);
            }
        }
        return returnedRuleSet;
    }

    @Override
    public RuleSetLink linkToRuleSet(String folderNodeId, String linkToNodeId) {
        NodeRef linkToNodeRef;
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, true);
        boolean isRuleSetNode = this.validator.isRuleSetNode(linkToNodeId);
        NodeRef nodeRef = linkToNodeRef = isRuleSetNode ? this.validator.validateRuleSetNode(linkToNodeId, false) : this.validator.validateFolderNode(linkToNodeId, false);
        if (!this.ruleService.hasRules(linkToNodeRef)) {
            throw new InvalidArgumentException("The target node has no rules to link.");
        }
        if (this.ruleService.hasRules(folderNodeRef)) {
            throw new InvalidArgumentException("Unable to link to a rule set because the folder has pre-existing rules or is already linked to a rule set.");
        }
        NodeRef ruleSetNodeRef = this.runtimeRuleService.getSavedRuleFolderAssoc(linkToNodeRef).getChildRef();
        this.nodeService.addChild(folderNodeRef, ruleSetNodeRef, RuleModel.ASSOC_RULE_FOLDER, RuleModel.ASSOC_RULE_FOLDER);
        RuleSetLink ruleSetLink = new RuleSetLink();
        ruleSetLink.setId(ruleSetNodeRef.getId());
        return ruleSetLink;
    }

    @Override
    public void unlinkRuleSet(String folderNodeId, String ruleSetId) {
        NodeRef folderNodeRef = this.validator.validateFolderNode(folderNodeId, true);
        NodeRef ruleSetNodeRef = this.validator.validateRuleSetNode(ruleSetId, folderNodeRef);
        if (!this.ruleService.isLinkedToRuleNode(folderNodeRef)) {
            throw new InvalidArgumentException("The folder is not linked to a rule set.");
        }
        this.nodeService.removeAspect(folderNodeRef, RuleModel.ASPECT_RULES);
    }

    public void setRuleSetLoader(RuleSetLoader ruleSetLoader) {
        this.ruleSetLoader = ruleSetLoader;
    }

    public void setValidator(NodeValidator validator) {
        this.validator = validator;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuntimeRuleService(RuntimeRuleService runtimeRuleService) {
        this.runtimeRuleService = runtimeRuleService;
    }
}

