/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.rules.ActionParameterConverter;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.api.model.rules.CompositeCondition;
import org.alfresco.rest.api.model.rules.Rule;
import org.alfresco.rest.api.model.rules.RuleTrigger;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Experimental
public class RestRuleModelMapper
implements RestModelMapper<Rule, org.alfresco.service.cmr.rule.Rule> {
    private static Log log = LogFactory.getLog(RestRuleModelMapper.class);
    private final RestModelMapper<CompositeCondition, ActionCondition> compositeConditionMapper;
    private final RestModelMapper<Action, org.alfresco.service.cmr.action.Action> actionMapper;
    private final Nodes nodes;
    private final ActionParameterConverter actionParameterConverter;

    public RestRuleModelMapper(RestModelMapper<CompositeCondition, ActionCondition> compositeConditionMapper, RestModelMapper<Action, org.alfresco.service.cmr.action.Action> actionMapper, Nodes nodes, ActionParameterConverter actionParameterConverter) {
        this.compositeConditionMapper = compositeConditionMapper;
        this.actionMapper = actionMapper;
        this.nodes = nodes;
        this.actionParameterConverter = actionParameterConverter;
    }

    @Override
    public Rule toRestModel(org.alfresco.service.cmr.rule.Rule serviceRule) {
        if (serviceRule == null) {
            return null;
        }
        Rule.Builder builder = Rule.builder().name(serviceRule.getTitle()).description(serviceRule.getDescription()).isEnabled(!serviceRule.getRuleDisabled()).isInheritable(serviceRule.isAppliedToChildren()).isAsynchronous(serviceRule.getExecuteAsynchronously());
        if (serviceRule.getNodeRef() != null) {
            builder.id(serviceRule.getNodeRef().getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)serviceRule.getRuleTypes())) {
            builder.triggers(serviceRule.getRuleTypes().stream().map(RuleTrigger::of).collect(Collectors.toList()));
        }
        if (serviceRule.getAction() != null) {
            builder.conditions(this.compositeConditionMapper.toRestModel(serviceRule.getAction().getActionConditions()));
            if (serviceRule.getAction().getCompensatingAction() != null && serviceRule.getAction().getCompensatingAction().getParameterValue("script-ref") != null) {
                String errorScript = this.actionParameterConverter.convertParamFromServiceModel(serviceRule.getAction().getCompensatingAction().getParameterValue("script-ref")).toString();
                builder.errorScript(errorScript);
            }
            if (serviceRule.getAction() instanceof CompositeAction && ((CompositeAction)serviceRule.getAction()).getActions() != null) {
                builder.actions(((CompositeAction)serviceRule.getAction()).getActions().stream().map(this.actionMapper::toRestModel).collect(Collectors.toList()));
            } else {
                log.warn((Object)("Rule Action should be of 'CompositeAction' type but found: " + serviceRule.getAction().getClass()));
            }
        }
        return builder.create();
    }

    @Override
    public org.alfresco.service.cmr.rule.Rule toServiceModel(Rule restRuleModel) {
        org.alfresco.service.cmr.rule.Rule serviceRule = new org.alfresco.service.cmr.rule.Rule();
        NodeRef nodeRef = restRuleModel.getId() != null ? this.nodes.validateOrLookupNode(restRuleModel.getId(), null) : null;
        serviceRule.setNodeRef(nodeRef);
        serviceRule.setTitle(restRuleModel.getName());
        serviceRule.setDescription(restRuleModel.getDescription());
        serviceRule.setRuleDisabled(!restRuleModel.getIsEnabled());
        serviceRule.applyToChildren(restRuleModel.getIsInheritable());
        serviceRule.setExecuteAsynchronously(restRuleModel.getIsAsynchronous());
        serviceRule.setRuleTypes(restRuleModel.getTriggers());
        serviceRule.setAction(this.actionMapper.toServiceModel(restRuleModel.getActions()));
        if (restRuleModel.getErrorScript() != null) {
            ActionImpl compensatingAction = new ActionImpl(null, GUID.generate(), "script");
            Map<String, Serializable> scriptParam = this.actionParameterConverter.getConvertedParams(Map.of("script-ref", restRuleModel.getErrorScript()), compensatingAction.getActionDefinitionName());
            compensatingAction.setParameterValues(scriptParam);
            serviceRule.getAction().setCompensatingAction((org.alfresco.service.cmr.action.Action)compensatingAction);
        }
        if (restRuleModel.getConditions() != null) {
            this.compositeConditionMapper.toServiceModels(restRuleModel.getConditions()).forEach(condition -> serviceRule.getAction().addActionCondition(condition));
        }
        return serviceRule;
    }
}

