/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.activities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.rest.api.impl.activities.ActivitySummaryProcessor;
import org.alfresco.rest.api.impl.activities.ActivitySummaryProcessorRegistry;
import org.alfresco.rest.api.impl.activities.BaseActivitySummaryProcessor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class ActivitySummaryParser
implements ActivitySummaryProcessorRegistry {
    private final Log logger = LogFactory.getLog(ActivitySummaryParser.class);
    private static String REGEXP_ISO8061 = "^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})(.([0-9]){3})?(Z|[\\+\\-]([0-9]{2}):([0-9]{2}))$";
    private static Pattern matcherISO8601 = Pattern.compile(REGEXP_ISO8061);
    private static final Pattern nodeRefPattern = Pattern.compile("^[a-zA-Z]+://.+/.+");
    private NamedObjectRegistry<ActivitySummaryProcessor> processors;
    private boolean autoConvertISO8601 = true;

    public void setProcessors(NamedObjectRegistry<ActivitySummaryProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public void register(String activityType, ActivitySummaryProcessor processor) {
        ActivitySummaryProcessor existingProcessor = (ActivitySummaryProcessor)this.processors.getNamedObject(activityType);
        if (existingProcessor != null) {
            this.logger.warn((Object)("Activity summary processor " + existingProcessor + " is being overridden by " + processor + " for activity type " + activityType));
        }
        this.processors.register(activityType, (Object)processor);
    }

    private void processActivitySummary(String activityType, Map<String, Object> entries) {
        ActivitySummaryProcessor processor = (ActivitySummaryProcessor)this.processors.getNamedObject(activityType);
        if (processor == null) {
            processor = new BaseActivitySummaryProcessor();
        }
        processor.process(entries);
    }

    public Map<String, Object> parse(String activityType, String activitySummary) throws JSONException {
        JSONObject json = (JSONObject)JSONValue.parse((String)activitySummary);
        Map<String, Object> map = this.convertJSONObjectToMap(json);
        this.processActivitySummary(activityType, map);
        return map;
    }

    private boolean isNodeRef(String nodeRef) {
        Matcher matcher = nodeRefPattern.matcher(nodeRef);
        return matcher.matches();
    }

    Map<String, Object> convertJSONObjectToMap(JSONObject jo) throws JSONException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        for (Object key : jo.keySet()) {
            Object value = jo.get(key);
            if (value instanceof JSONObject) {
                model.put((String)key, this.convertJSONObjectToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                model.put((String)key, this.convertJSONArrayToList((JSONArray)value));
                continue;
            }
            if (value == null) {
                model.put((String)key, null);
                continue;
            }
            if (value instanceof String && this.autoConvertISO8601 && matcherISO8601.matcher((String)value).matches()) {
                value = ISO8601DateFormat.parse((String)((String)value));
            }
            if (value instanceof String && this.isNodeRef((String)value)) {
                try {
                    value = new NodeRef((String)value);
                }
                catch (AlfrescoRuntimeException e) {
                    this.logger.warn((Object)("Cannot convert activity summary NodeRef string " + value + " to a NodeRef"));
                }
            }
            model.put((String)key, value);
        }
        return model;
    }

    List<Object> convertJSONArrayToList(JSONArray ja) throws JSONException {
        ArrayList<Object> model = new ArrayList<Object>();
        for (int i = 0; i < ja.size(); ++i) {
            Object o = ja.get(i);
            if (o instanceof JSONArray) {
                model.add(this.convertJSONArrayToList((JSONArray)o));
                continue;
            }
            if (o instanceof JSONObject) {
                model.add(this.convertJSONObjectToMap((JSONObject)o));
                continue;
            }
            if (o == null) {
                model.add(null);
                continue;
            }
            if (o instanceof String && this.autoConvertISO8601 && matcherISO8601.matcher((String)o).matches()) {
                o = ISO8601DateFormat.parse((String)((String)o));
            }
            model.add(o);
        }
        return model;
    }
}

