/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.rest.api.ClassDefinitionMapper;
import org.alfresco.rest.api.Types;
import org.alfresco.rest.api.impl.AbstractClassImpl;
import org.alfresco.rest.api.model.Type;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;

public class TypesImpl
extends AbstractClassImpl<Type>
implements Types {
    private DictionaryService dictionaryService;
    private NamespacePrefixResolver namespaceService;
    private ClassDefinitionMapper classDefinitionMapper;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespacePrefixResolver namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setClassDefinitionMapper(ClassDefinitionMapper classDefinitionMapper) {
        this.classDefinitionMapper = classDefinitionMapper;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"classDefinitionMapper", (Object)this.classDefinitionMapper);
    }

    TypesImpl(DictionaryService dictionaryService, NamespacePrefixResolver namespaceService, ClassDefinitionMapper classDefinitionMapper) {
        super(dictionaryService, namespaceService, classDefinitionMapper);
    }

    @Override
    public CollectionWithPagingInfo<Type> listTypes(Parameters params) {
        Paging paging = params.getPaging();
        AbstractClassImpl.ModelApiFilter query = this.getQuery(params.getQuery());
        Stream<Object> typeStream = null;
        if (query != null && query.getModelIds() != null) {
            this.validateListParam(query.getModelIds(), PARAM_MODEL_IDS);
            Set<Pair<QName, Boolean>> modelsFilter = this.parseModelIds(query.getModelIds(), PARAM_INCLUDE_SUBTYPES);
            typeStream = modelsFilter.stream().map(this::getModelTypes).flatMap(Collection::stream);
        } else if (query != null && query.getParentIds() != null) {
            this.validateListParam(query.getParentIds(), PARAM_PARENT_IDS);
            typeStream = query.getParentIds().stream().map(this::getChildTypes).flatMap(Collection::stream);
        } else {
            typeStream = this.dictionaryService.getAllTypes().stream();
        }
        List allTypes = typeStream.filter(qName -> this.filterByNamespace(query, (QName)qName)).filter(TypesImpl.distinctByKey(QName::getPrefixString)).map(qName -> this.convertToType(this.dictionaryService.getType(qName), params.getInclude())).collect(Collectors.toList());
        return this.createPagedResult(allTypes, paging);
    }

    @Override
    public Type getType(String typeId) {
        if (typeId == null) {
            throw new InvalidArgumentException("Invalid parameter: unknown scheme specified");
        }
        TypeDefinition typeDefinition = null;
        try {
            typeDefinition = this.dictionaryService.getType(QName.createQName((String)typeId, (NamespacePrefixResolver)this.namespaceService));
        }
        catch (NamespaceException exception) {
            throw new EntityNotFoundException(typeId);
        }
        if (typeDefinition == null) {
            throw new EntityNotFoundException(typeId);
        }
        return this.convertToType(typeDefinition, ALL_PROPERTIES);
    }

    public Type convertToType(TypeDefinition typeDefinition, List<String> includes) {
        try {
            Type type = new Type(typeDefinition, (MessageLookup)this.dictionaryService);
            this.constructFromFilters(type, (ClassDefinition)typeDefinition, includes);
            return type;
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("Failed to parse Type: " + typeDefinition.getName() + " . " + ex.getMessage());
        }
    }

    private Collection<QName> getModelTypes(Pair<QName, Boolean> model) {
        ModelDefinition modelDefinition = null;
        try {
            modelDefinition = this.dictionaryService.getModel((QName)model.getFirst());
        }
        catch (Exception exception) {
            throw new InvalidArgumentException(exception.getMessage());
        }
        if (modelDefinition == null) {
            throw new EntityNotFoundException("model");
        }
        Collection aspects = this.dictionaryService.getTypes(modelDefinition.getName());
        if (!((Boolean)model.getSecond()).booleanValue()) {
            return aspects;
        }
        Stream aspectStream = aspects.stream();
        Stream childrenStream = aspects.stream().map(aspect -> this.dictionaryService.getSubTypes(aspect, false)).flatMap(Collection::stream);
        return Stream.concat(aspectStream, childrenStream).collect(Collectors.toList());
    }

    private Collection<QName> getChildTypes(String typeId) {
        Collection subTypes = null;
        try {
            QName parentType = QName.createQName((String)typeId, (NamespacePrefixResolver)this.namespaceService);
            subTypes = this.dictionaryService.getSubTypes(parentType, true);
        }
        catch (NamespaceException exception) {
            throw new InvalidArgumentException(exception.getMessage());
        }
        return subTypes;
    }
}

