/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.text.Collator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PageDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropBoolean;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.repo.site.SiteMembershipComparator;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.impl.SiteImportPackageHandler;
import org.alfresco.rest.api.impl.SiteSurfConfig;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.FavouriteSite;
import org.alfresco.rest.api.model.MemberOfSite;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.model.SiteContainer;
import org.alfresco.rest.api.model.SiteGroup;
import org.alfresco.rest.api.model.SiteMember;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalkerOrSupported;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteMemberInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterContentCache;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SitesImpl
implements Sites {
    private static final Log logger = LogFactory.getLog(SitesImpl.class);
    private static final String FAVOURITE_SITES_PREFIX = "org.alfresco.share.sites.favourites.";
    private static final int FAVOURITE_SITES_PREFIX_LENGTH = "org.alfresco.share.sites.favourites.".length();
    private static final int SITE_MAXLEN_ID = 72;
    private static final int SITE_MAXLEN_TITLE = 256;
    private static final int SITE_MAXLEN_DESCRIPTION = 512;
    private static final String SITE_ID_VALID_CHARS_PARTIAL_REGEX = "A-Za-z0-9\\-";
    private static final String DEFAULT_SITE_PRESET = "site-dashboard";
    private static final String PARAM_IS_MEMBER_OF_GROUP = "isMemberOfGroup";
    private static final Map<String, QName> SORT_PARAMS_TO_QNAMES;
    private static final Map<String, SiteService.SortFields> SORT_SITE_MEMBERSHIP;
    private static final Set<String> LIST_SITES_EQUALS_QUERY_PROPERTIES;
    protected Nodes nodes;
    protected People people;
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected SiteService siteService;
    protected FavouritesService favouritesService;
    protected PreferenceService preferenceService;
    protected ImporterService importerService;
    protected SiteSurfConfig siteSurfConfig;
    protected PermissionService permissionService;
    protected SiteServiceImpl siteServiceImpl;
    protected AuthorityService authorityService;

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setFavouritesService(FavouritesService favouritesService) {
        this.favouritesService = favouritesService;
    }

    public void setPeople(People people) {
        this.people = people;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setSiteSurfConfig(SiteSurfConfig siteSurfConfig) {
        this.siteSurfConfig = siteSurfConfig;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setSiteServiceImpl(SiteServiceImpl siteServiceImpl) {
        this.siteServiceImpl = siteServiceImpl;
    }

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    public SiteInfo validateSite(NodeRef guid) {
        SiteInfo siteInfo = null;
        if (guid == null) {
            throw new InvalidArgumentException("guid is null");
        }
        this.nodes.validateNode(guid);
        QName type = this.nodeService.getType(guid);
        boolean isSiteNodeRef = this.dictionaryService.isSubClass(type, SiteModel.TYPE_SITE);
        if (isSiteNodeRef) {
            siteInfo = this.siteService.getSite(guid);
            if (siteInfo == null) {
                throw new InvalidArgumentException(guid.getId() + " is not a site");
            }
        } else {
            throw new EntityNotFoundException(guid.getId());
        }
        return siteInfo;
    }

    @Override
    public SiteInfo validateSite(String siteId) {
        if (siteId == null) {
            throw new InvalidArgumentException("siteId is null");
        }
        SiteInfo siteInfo = this.siteService.getSite(siteId);
        return siteInfo;
    }

    @Override
    public CollectionWithPagingInfo<SiteMember> getSiteMembers(String siteId, Parameters parameters) {
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        siteId = siteInfo.getShortName();
        Paging paging = parameters.getPaging();
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        pagingRequest.setRequestTotalCountMax(100);
        MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(new HashSet<String>(Collections.singletonList(PARAM_IS_MEMBER_OF_GROUP)), null);
        QueryHelper.walk(parameters.getQuery(), propertyWalker);
        Boolean expandGroups = propertyWalker.getProperty(PARAM_IS_MEMBER_OF_GROUP, 8, Boolean.class);
        if (expandGroups == null) {
            expandGroups = true;
        }
        ArrayList<Pair> sort = new ArrayList<Pair>();
        sort.add(new Pair((Object)SiteService.SortFields.LastName, (Object)Boolean.TRUE));
        sort.add(new Pair((Object)SiteService.SortFields.FirstName, (Object)Boolean.TRUE));
        sort.add(new Pair((Object)SiteService.SortFields.Role, (Object)Boolean.TRUE));
        sort.add(new Pair((Object)SiteService.SortFields.Username, (Object)Boolean.TRUE));
        PagingResults pagedResults = this.siteService.listMembersPaged(siteId, expandGroups.booleanValue(), sort, pagingRequest);
        List ret = pagedResults.getPage().stream().map(siteMembership -> new SiteMember(siteMembership.getPersonId(), siteMembership.getRole(), siteMembership.isMemberOfGroup())).collect(Collectors.toList());
        return CollectionWithPagingInfo.asPaged(paging, ret, pagedResults.hasMoreItems(), (Integer)pagedResults.getTotalResultCount().getFirst());
    }

    @Override
    public String getSiteRole(String siteId) {
        String personId = AuthenticationUtil.getFullyAuthenticatedUser();
        return this.getSiteRole(siteId, personId);
    }

    @Override
    public String getSiteRole(String siteId, String personId) {
        return this.siteService.getMembersRole(siteId, personId);
    }

    @Override
    public Site getSite(String siteId) {
        return this.getSite(siteId, true);
    }

    public Site getSite(String siteId, boolean includeRole) {
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        return this.getSite(siteInfo, includeRole);
    }

    private Site getSite(SiteInfo siteInfo, boolean includeRole) {
        String siteId = siteInfo.getShortName();
        String role = null;
        if (includeRole) {
            role = this.getSiteRole(siteId);
        }
        return new Site(siteInfo, role);
    }

    @Override
    public MemberOfSite getMemberOfSite(String personId, String siteId) {
        MemberOfSite siteMember = null;
        personId = this.people.validatePerson(personId);
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(personId, siteId);
        }
        siteId = siteInfo.getShortName();
        String roleStr = this.siteService.getMembersRole(siteInfo.getShortName(), personId);
        if (roleStr == null) {
            throw new RelationshipResourceNotFoundException(personId, siteId);
        }
        Site site = new Site(siteInfo, roleStr);
        siteMember = new MemberOfSite(site.getId(), siteInfo.getNodeRef(), roleStr);
        return siteMember;
    }

    @Override
    public SiteMember getSiteMember(String personId, String siteId) {
        SiteMember siteMember = null;
        personId = this.people.validatePerson(personId);
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            logger.debug((Object)("Site does not exist: " + siteId));
            throw new RelationshipResourceNotFoundException(personId, siteId);
        }
        siteId = siteInfo.getShortName();
        logger.debug((Object)("Getting member role for " + siteId + " person " + personId));
        String role = this.siteService.getMembersRole(siteId, personId);
        if (role == null) {
            logger.debug((Object)"Getting member role but role is null");
            throw new RelationshipResourceNotFoundException(personId, siteId);
        }
        siteMember = new SiteMember(personId, role);
        return siteMember;
    }

    @Override
    public SiteMember addSiteMember(String siteId, SiteMember siteMember) {
        String personId = this.people.validatePerson(siteMember.getPersonId());
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            logger.debug((Object)("addSiteMember:  site does not exist " + siteId + " person " + personId));
            throw new EntityNotFoundException(siteId);
        }
        siteId = siteInfo.getShortName();
        String role = siteMember.getRole();
        if (role == null) {
            logger.debug((Object)("addSiteMember:  Must provide a role " + siteMember));
            throw new InvalidArgumentException("Must provide a role");
        }
        if (this.siteService.isMember(siteId, personId)) {
            logger.debug((Object)("addSiteMember:  " + personId + " is already a member of site " + siteId));
            throw new ConstraintViolatedException(personId + " is already a member of site " + siteId);
        }
        if (!this.siteService.canAddMember(siteId, personId, role)) {
            logger.debug((Object)("addSiteMember:  PermissionDeniedException " + siteId + " person " + personId + " role " + role));
            throw new PermissionDeniedException();
        }
        try {
            this.siteService.setMembership(siteId, personId, role);
        }
        catch (UnknownAuthorityException e) {
            logger.debug((Object)("addSiteMember:  UnknownAuthorityException " + siteId + " person " + personId + " role " + role));
            throw new InvalidArgumentException("Unknown role '" + role + "'");
        }
        return siteMember;
    }

    @Override
    public void removeSiteMember(String personId, String siteId) {
        personId = this.people.validatePerson(personId);
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(personId, siteId);
        }
        siteId = siteInfo.getShortName();
        boolean isMember = this.siteService.isMember(siteId, personId);
        if (!isMember) {
            throw new InvalidArgumentException();
        }
        String role = this.siteService.getMembersRole(siteId, personId);
        if (role != null) {
            if (role.equals("SiteManager")) {
                int numAuthorities = this.siteService.countAuthoritiesWithRole(siteId, "SiteManager");
                if (numAuthorities <= 1) {
                    throw new InvalidArgumentException("Can't remove last manager of site " + siteId);
                }
                this.siteService.removeMembership(siteId, personId);
            } else {
                this.siteService.removeMembership(siteId, personId);
            }
        } else {
            throw new AlfrescoRuntimeException("Unable to determine role of site member");
        }
    }

    @Override
    public SiteMember updateSiteMember(String siteId, SiteMember siteMember) {
        String siteMemberId = siteMember.getPersonId();
        if (siteMemberId == null) {
            throw new InvalidArgumentException("Member id is null");
        }
        siteMemberId = this.people.validatePerson(siteMemberId);
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        siteId = siteInfo.getShortName();
        String siteRole = siteMember.getRole();
        if (siteRole == null) {
            throw new InvalidArgumentException("Must provide a role");
        }
        if (!this.siteService.isMember(siteId, siteMember.getPersonId())) {
            throw new InvalidArgumentException("User is not a member of the site");
        }
        try {
            this.siteService.setMembership(siteId, siteMember.getPersonId(), siteRole);
        }
        catch (UnknownAuthorityException e) {
            throw new InvalidArgumentException("Unknown role '" + siteRole + "'");
        }
        return siteMember;
    }

    @Override
    public CollectionWithPagingInfo<MemberOfSite> getSites(String personId, Parameters parameters) {
        Paging paging = parameters.getPaging();
        personId = this.people.validatePerson(personId);
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        ArrayList<Pair> sortPairs = new ArrayList<Pair>(parameters.getSorting().size());
        List<SortColumn> sortCols = parameters.getSorting();
        if (sortCols != null && sortCols.size() > 0) {
            for (SortColumn sortCol : sortCols) {
                SiteService.SortFields sortProp = SORT_SITE_MEMBERSHIP.get(sortCol.column);
                if (sortProp == null) {
                    throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
                }
                sortPairs.add(new Pair((Object)sortProp, (Object)(sortCol.asc ? CannedQuerySortDetails.SortOrder.ASCENDING : CannedQuerySortDetails.SortOrder.DESCENDING)));
            }
        } else {
            sortPairs.add(new Pair((Object)SiteService.SortFields.SiteTitle, (Object)CannedQuerySortDetails.SortOrder.ASCENDING));
        }
        List siteMembers = this.siteService.listSiteMemberships(personId, 0);
        int totalSize = siteMembers.size();
        ArrayList sortedSiteMembers = new ArrayList(siteMembers);
        Collections.sort(sortedSiteMembers, new SiteMembershipComparator(sortPairs, SiteMembershipComparator.Type.SITES));
        PageDetails pageDetails = PageDetails.getPageDetails((PagingRequest)pagingRequest, (int)totalSize);
        ArrayList<MemberOfSite> ret = new ArrayList<MemberOfSite>(totalSize);
        List<FilterProp> filterProps = this.getFilterPropListOfSites(parameters);
        int totalItems = 0;
        Iterator it = sortedSiteMembers.iterator();
        int counter = 0;
        while (it.hasNext()) {
            SiteMembership siteMember = (SiteMembership)it.next();
            if (filterProps != null && !this.includeFilter(siteMember, filterProps)) continue;
            if (counter < pageDetails.getSkipCount()) {
                ++totalItems;
                ++counter;
                continue;
            }
            if (counter <= pageDetails.getEnd() - 1) {
                SiteInfo siteInfo = siteMember.getSiteInfo();
                MemberOfSite memberOfSite = new MemberOfSite(siteInfo.getShortName(), siteInfo.getNodeRef(), siteMember.getRole());
                ret.add(memberOfSite);
                ++counter;
            }
            ++totalItems;
        }
        return CollectionWithPagingInfo.asPaged(paging, ret, counter < totalItems, totalItems);
    }

    @Override
    public SiteContainer getSiteContainer(String siteId, String containerId) {
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(siteId, containerId);
        }
        siteId = siteInfo.getShortName();
        NodeRef containerNodeRef = this.siteService.getContainer(siteId, containerId);
        if (containerNodeRef == null) {
            throw new RelationshipResourceNotFoundException(siteId, containerId);
        }
        SiteInfo testSiteInfo = this.siteService.getSite(containerNodeRef);
        if (testSiteInfo == null) {
            throw new RelationshipResourceNotFoundException(siteId, containerId);
        }
        if (!testSiteInfo.getShortName().equals(siteId)) {
            throw new RelationshipResourceNotFoundException(siteId, containerId);
        }
        String folderId = (String)((Object)this.nodeService.getProperty(containerNodeRef, SiteModel.PROP_COMPONENT_ID));
        SiteContainer siteContainer = new SiteContainer(folderId, containerNodeRef);
        return siteContainer;
    }

    @Override
    public PagingResults<SiteContainer> getSiteContainers(String siteId, Paging paging) {
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        final PagingResults pagingResults = this.siteService.listContainers(siteInfo.getShortName(), Util.getPagingRequest(paging));
        List containerFileInfos = pagingResults.getPage();
        final ArrayList<SiteContainer> siteContainers = new ArrayList<SiteContainer>(containerFileInfos.size());
        for (FileInfo containerFileInfo : containerFileInfos) {
            NodeRef nodeRef = containerFileInfo.getNodeRef();
            String containerId = (String)((Object)this.nodeService.getProperty(nodeRef, SiteModel.PROP_COMPONENT_ID));
            SiteContainer siteContainer = new SiteContainer(containerId, nodeRef);
            siteContainers.add(siteContainer);
        }
        return new PagingResults<SiteContainer>(){

            public List<SiteContainer> getPage() {
                return siteContainers;
            }

            public boolean hasMoreItems() {
                return pagingResults.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return pagingResults.getTotalResultCount();
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    @Override
    public CollectionWithPagingInfo<Site> getSites(Parameters parameters) {
        final BeanPropertiesFilter filter = parameters.getFilter();
        Paging paging = parameters.getPaging();
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        ArrayList<Pair> sortProps = new ArrayList<Pair>();
        List<SortColumn> sortCols = parameters.getSorting();
        if (sortCols != null && sortCols.size() > 0) {
            for (SortColumn sortCol : sortCols) {
                QName sortPropQName = SORT_PARAMS_TO_QNAMES.get(sortCol.column);
                if (sortPropQName == null) {
                    throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
                }
                sortProps.add(new Pair((Object)sortPropQName, (Object)(sortCol.asc ? Boolean.TRUE : Boolean.FALSE)));
            }
        } else {
            sortProps.add(new Pair((Object)ContentModel.PROP_TITLE, (Object)Boolean.TRUE));
        }
        List<FilterProp> filterProps = this.getFilterPropListOfSites(parameters);
        PagingResults pagingResult = this.siteService.listSites(filterProps, sortProps, pagingRequest);
        final List sites = pagingResult.getPage();
        int totalItems = (Integer)pagingResult.getTotalResultCount().getFirst();
        final String personId = AuthenticationUtil.getFullyAuthenticatedUser();
        AbstractList<Site> page = new AbstractList<Site>(){

            @Override
            public Site get(int index) {
                SiteInfo siteInfo = (SiteInfo)sites.get(index);
                String role = null;
                if (filter.isAllowed("role")) {
                    role = SitesImpl.this.siteService.getMembersRole(siteInfo.getShortName(), personId);
                }
                return new Site(siteInfo, role);
            }

            @Override
            public int size() {
                return sites.size();
            }
        };
        return CollectionWithPagingInfo.asPaged(paging, page, pagingResult.hasMoreItems(), totalItems);
    }

    private SiteVisibility getSiteVisibilityFromParam(String siteVisibilityStr) {
        SiteVisibility visibility;
        try {
            visibility = SiteVisibility.valueOf((String)siteVisibilityStr);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException("Site visibility is invalid (expected eg. PUBLIC, PRIVATE, MODERATED)");
        }
        return visibility;
    }

    private List<FilterProp> getFilterPropListOfSites(Parameters parameters) {
        ArrayList<FilterProp> filterProps = new ArrayList<FilterProp>();
        Query q = parameters.getQuery();
        if (q != null) {
            String sitePreset;
            MapBasedQueryWalkerOrSupported propertyWalker = new MapBasedQueryWalkerOrSupported(LIST_SITES_EQUALS_QUERY_PROPERTIES, null);
            QueryHelper.walk(q, propertyWalker);
            String siteVisibilityStr = propertyWalker.getProperty("visibility", 8, String.class);
            if (siteVisibilityStr != null && !siteVisibilityStr.isEmpty()) {
                SiteVisibility siteVisibility = this.getSiteVisibilityFromParam(siteVisibilityStr);
                filterProps.add((FilterProp)new FilterPropString(SiteModel.PROP_SITE_VISIBILITY, siteVisibility.name(), FilterPropString.FilterTypeString.EQUALS));
            }
            if ((sitePreset = propertyWalker.getProperty("preset", 8, String.class)) != null && !sitePreset.isEmpty()) {
                filterProps.add((FilterProp)new FilterPropString(SiteModel.PROP_SITE_PRESET, sitePreset, FilterPropString.FilterTypeString.EQUALS));
            }
        }
        return filterProps.isEmpty() ? null : filterProps;
    }

    private boolean includeFilter(SiteMembership siteMembership, List<FilterProp> filterProps) {
        HashMap<QName, Serializable> propVals = new HashMap<QName, Serializable>();
        propVals.put(SiteModel.PROP_SITE_VISIBILITY, (Serializable)((Object)siteMembership.getSiteInfo().getVisibility().name()));
        propVals.put(SiteModel.PROP_SITE_PRESET, (Serializable)((Object)siteMembership.getSiteInfo().getSitePreset()));
        return this.includeFilter(propVals, filterProps);
    }

    private boolean includeFilter(Map<QName, Serializable> propVals, List<FilterProp> filterProps) {
        for (FilterProp filterProp : filterProps) {
            Object filter;
            Object val;
            Serializable propVal = propVals.get(filterProp.getPropName());
            if (propVal != null && filterProp instanceof FilterPropString && propVal instanceof String) {
                val = (String)((Object)propVal);
                filter = (String)((Object)filterProp.getPropVal());
                switch ((FilterPropString.FilterTypeString)filterProp.getFilterType()) {
                    case STARTSWITH: {
                        if (!((String)val).startsWith((String)filter)) break;
                        return true;
                    }
                    case STARTSWITH_IGNORECASE: {
                        if (!((String)val).toLowerCase().startsWith(((String)filter).toLowerCase())) break;
                        return true;
                    }
                    case EQUALS: {
                        if (!((String)val).equals(filter)) break;
                        return true;
                    }
                    case EQUALS_IGNORECASE: {
                        if (!((String)val).equalsIgnoreCase((String)filter)) break;
                        return true;
                    }
                    case ENDSWITH: {
                        if (!((String)val).endsWith((String)filter)) break;
                        return true;
                    }
                    case ENDSWITH_IGNORECASE: {
                        if (!((String)val).toLowerCase().endsWith(((String)filter).toLowerCase())) break;
                        return true;
                    }
                    case MATCHES: {
                        if (!((String)val).matches((String)filter)) break;
                        return true;
                    }
                    case MATCHES_IGNORECASE: {
                        if (!((String)val).toLowerCase().matches(((String)filter).toLowerCase())) break;
                        return true;
                    }
                }
            }
            if (!(filterProp instanceof FilterPropBoolean) || !(propVal instanceof Boolean)) continue;
            val = (Boolean)propVal;
            filter = (Boolean)filterProp.getPropVal();
            return val == filter;
        }
        return false;
    }

    @Override
    public FavouriteSite getFavouriteSite(String personId, String siteId) {
        personId = this.people.validatePerson(personId);
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(personId, siteId);
        }
        siteId = siteInfo.getShortName();
        NodeRef nodeRef = siteInfo.getNodeRef();
        if (this.favouritesService.isFavourite(personId, nodeRef)) {
            String role = this.getSiteRole(siteId, personId);
            return new FavouriteSite(siteInfo, role);
        }
        throw new RelationshipResourceNotFoundException(personId, siteId);
    }

    @Override
    public void addFavouriteSite(String personId, FavouriteSite favouriteSite) {
        boolean isFavouriteSite;
        personId = this.people.validatePerson(personId);
        String siteId = favouriteSite.getId();
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        siteId = siteInfo.getShortName();
        StringBuilder prefKey = new StringBuilder(FAVOURITE_SITES_PREFIX);
        prefKey.append(siteId);
        String value = (String)((Object)this.preferenceService.getPreference(personId, prefKey.toString()));
        boolean bl = isFavouriteSite = value != null && value.equalsIgnoreCase("true");
        if (isFavouriteSite) {
            throw new ConstraintViolatedException("Site " + siteId + " is already a favourite site");
        }
        prefKey = new StringBuilder(FAVOURITE_SITES_PREFIX);
        prefKey.append(siteId);
        HashMap<String, Boolean> preferences = new HashMap<String, Boolean>(1);
        preferences.put(prefKey.toString(), Boolean.TRUE);
        this.preferenceService.setPreferences(personId, preferences);
    }

    @Override
    public void removeFavouriteSite(String personId, String siteId) {
        boolean isFavouriteSite;
        personId = this.people.validatePerson(personId);
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(personId, siteId);
        }
        siteId = siteInfo.getShortName();
        StringBuilder prefKey = new StringBuilder(FAVOURITE_SITES_PREFIX);
        prefKey.append(siteId);
        String value = (String)((Object)this.preferenceService.getPreference(personId, prefKey.toString()));
        boolean bl = isFavouriteSite = value != null && value.equalsIgnoreCase("true");
        if (!isFavouriteSite) {
            throw new NotFoundException("Site " + siteId + " is not a favourite site");
        }
        this.preferenceService.clearPreferences(personId, prefKey.toString());
    }

    private PagingResults<SiteInfo> getFavouriteSites(String userName, PagingRequest pagingRequest) {
        final Collator collator = Collator.getInstance();
        final TreeSet<SiteInfo> sortedFavouriteSites = new TreeSet<SiteInfo>(new Comparator<SiteInfo>(){

            @Override
            public int compare(SiteInfo o1, SiteInfo o2) {
                return collator.compare(o1.getTitle(), o2.getTitle());
            }
        });
        Map prefs = this.preferenceService.getPreferences(userName, FAVOURITE_SITES_PREFIX);
        for (Map.Entry entry : prefs.entrySet()) {
            String siteShortName;
            SiteInfo siteInfo;
            boolean isFavourite = false;
            Serializable s = (Serializable)entry.getValue();
            if (s instanceof Boolean) {
                isFavourite = (Boolean)s;
            }
            if (!isFavourite || (siteInfo = this.siteService.getSite(siteShortName = ((String)entry.getKey()).substring(FAVOURITE_SITES_PREFIX_LENGTH).replace(".favourited", ""))) == null) continue;
            sortedFavouriteSites.add(siteInfo);
        }
        int totalSize = sortedFavouriteSites.size();
        final PageDetails pageDetails = PageDetails.getPageDetails((PagingRequest)pagingRequest, (int)totalSize);
        final ArrayList<SiteInfo> page = new ArrayList<SiteInfo>(pageDetails.getPageSize());
        Iterator it = sortedFavouriteSites.iterator();
        for (int counter = 0; counter < pageDetails.getEnd() && it.hasNext(); ++counter) {
            SiteInfo favouriteSite = (SiteInfo)it.next();
            if (counter < pageDetails.getSkipCount()) continue;
            if (counter > pageDetails.getEnd() - 1) break;
            page.add(favouriteSite);
        }
        return new PagingResults<SiteInfo>(){

            public List<SiteInfo> getPage() {
                return page;
            }

            public boolean hasMoreItems() {
                return pageDetails.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                Integer total = sortedFavouriteSites.size();
                return new Pair((Object)total, (Object)total);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    @Override
    public CollectionWithPagingInfo<FavouriteSite> getFavouriteSites(String personId, Parameters parameters) {
        personId = this.people.validatePerson(personId);
        Paging paging = parameters.getPaging();
        BeanPropertiesFilter filter = parameters.getFilter();
        PagingResults<SiteInfo> favouriteSites = this.getFavouriteSites(personId, Util.getPagingRequest(paging));
        ArrayList<FavouriteSite> favourites = new ArrayList<FavouriteSite>(favouriteSites.getPage().size());
        for (SiteInfo favouriteSite : favouriteSites.getPage()) {
            String role = null;
            if (filter.isAllowed("role")) {
                role = this.getSiteRole(favouriteSite.getShortName(), personId);
            }
            FavouriteSite favourite = new FavouriteSite(favouriteSite, role);
            favourites.add(favourite);
        }
        return CollectionWithPagingInfo.asPaged(paging, favourites, favouriteSites.hasMoreItems(), (Integer)favouriteSites.getTotalResultCount().getFirst());
    }

    @Override
    public void deleteSite(String siteId, Parameters parameters) {
        boolean isSiteAdmin = this.siteService.isSiteAdmin(AuthenticationUtil.getFullyAuthenticatedUser());
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        siteId = siteInfo.getShortName();
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        if (!isSiteAdmin && this.permissionService.hasPermission(siteNodeRef, "Delete") != AccessStatus.ALLOWED) {
            throw new AccessDeniedException("Cannot delete site: " + siteId);
        }
        boolean permanentDelete = Boolean.valueOf(parameters.getParameter("permanent"));
        if (permanentDelete) {
            this.nodeService.addAspect(siteNodeRef, ContentModel.ASPECT_TEMPORARY, null);
            this.siteServiceImpl.beforePurgeNode(siteNodeRef);
        }
        this.siteService.deleteSite(siteId);
    }

    protected SiteInfo createSite(Site site) {
        if (site.getPreset() != null) {
            throw new InvalidArgumentException("Site preset should not be set");
        }
        return this.siteService.createSite(DEFAULT_SITE_PRESET, site.getId(), site.getTitle(), site.getDescription(), site.getVisibility());
    }

    @Override
    public Site createSite(Site site, Parameters parameters) {
        site = this.validateSite(site);
        SiteInfo siteInfo = null;
        try {
            siteInfo = this.createSite(site);
        }
        catch (SiteServiceException sse) {
            if (sse.getMsgId().equals("site_service.unable_to_create")) {
                throw new ConstraintViolatedException(sse.getMessage());
            }
            throw sse;
        }
        String siteId = siteInfo.getShortName();
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        boolean skipShareSurfConfig = Boolean.valueOf(parameters.getParameter("skipConfiguration"));
        if (!skipShareSurfConfig) {
            this.importSite(siteId, siteNodeRef);
        }
        this.siteService.createContainer(siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        boolean skipAddToFavorites = Boolean.valueOf(parameters.getParameter("skipAddToFavorites"));
        if (!skipAddToFavorites) {
            String personId = AuthenticationUtil.getFullyAuthenticatedUser();
            this.favouritesService.addFavourite(personId, siteNodeRef);
        }
        return this.getSite(siteInfo, true);
    }

    @Override
    public Site updateSite(String siteId, SiteUpdate update, Parameters parameters) {
        SiteInfo siteInfo;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating site, ID: " + siteId + ", site data: " + update + ", parameters: " + parameters));
        }
        if ((siteInfo = this.validateSite(siteId)) == null) {
            throw new EntityNotFoundException(siteId);
        }
        if (update.wasSet("title")) {
            siteInfo.setTitle(update.getTitle());
        }
        if (update.wasSet("description")) {
            siteInfo.setDescription(update.getDescription());
        }
        if (update.wasSet("visibility")) {
            siteInfo.setVisibility(update.getVisibility());
        }
        this.validateSite(new Site(siteInfo, null));
        this.siteService.updateSite(siteInfo);
        return this.getSite(siteId);
    }

    protected Site validateSite(Site site) {
        String siteTitle = site.getTitle();
        if (siteTitle == null || siteTitle.isEmpty()) {
            throw new InvalidArgumentException("Site title is expected: " + siteTitle);
        }
        if (siteTitle.length() > 256) {
            throw new InvalidArgumentException("Site title exceeds max length of 256 characters");
        }
        SiteVisibility siteVisibility = site.getVisibility();
        if (siteVisibility == null) {
            throw new InvalidArgumentException("Site visibility is expected: " + siteTitle + " (eg. PUBLIC, PRIVATE, MODERATED)");
        }
        String siteId = site.getId();
        if (siteId == null) {
            siteId = siteTitle.trim().replaceAll("[^A-Za-z0-9\\- ]", "").replaceAll(" +", " ").replace(" ", "-").toLowerCase();
        } else if (!siteId.matches("^[A-Za-z0-9\\-]+")) {
            throw new InvalidArgumentException("Invalid site id - should consist of alphanumeric/dash characters");
        }
        if (siteId.length() > 72) {
            throw new InvalidArgumentException("Site id exceeds max length of 72 characters");
        }
        site.setId(siteId);
        String siteDescription = site.getDescription();
        if (siteDescription == null) {
            site.setDescription("");
        }
        if (siteDescription != null && siteDescription.length() > 512) {
            throw new InvalidArgumentException("Site description exceeds max length of 512 characters");
        }
        return site;
    }

    private void importSite(final String siteId, NodeRef siteNodeRef) {
        SiteImportPackageHandler acpHandler = new SiteImportPackageHandler(this.siteSurfConfig, siteId);
        Location location = new Location(siteNodeRef);
        ImporterBinding binding = new ImporterBinding(){

            public String getValue(String key) {
                if (key.equals("siteId")) {
                    return siteId;
                }
                return null;
            }

            public ImporterBinding.UUID_BINDING getUUIDBinding() {
                return ImporterBinding.UUID_BINDING.CREATE_NEW;
            }

            public QName[] getExcludedClasses() {
                return null;
            }

            public boolean allowReferenceWithinTransaction() {
                return false;
            }

            public ImporterContentCache getImportConentCache() {
                return null;
            }
        };
        this.importerService.importView((ImportPackageHandler)acpHandler, location, binding, null);
    }

    @Override
    public CollectionWithPagingInfo<SiteGroup> getSiteGroupMemberships(String siteId, Parameters parameters) {
        this.validateSite(siteId);
        PagingRequest pagingRequest = Util.getPagingRequest(parameters.getPaging());
        pagingRequest.setRequestTotalCountMax(100);
        PagingResults pagedResults = this.siteService.listGroupMembersPaged(siteId, new ArrayList(), pagingRequest);
        List groups = pagedResults.getPage().stream().map(siteMembership -> new SiteGroup(siteMembership.getId(), siteMembership.getRole())).collect(Collectors.toList());
        return CollectionWithPagingInfo.asPaged(parameters.getPaging(), groups, pagedResults.hasMoreItems(), (Integer)pagedResults.getTotalResultCount().getFirst());
    }

    @Override
    public SiteGroup addSiteGroupMembership(String siteId, SiteGroup group) {
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            logger.debug((Object)("Site does not exist: " + siteId));
            throw new EntityNotFoundException(siteId);
        }
        this.validateGroup(group.getId());
        SiteMemberInfo groupInfo = this.siteService.getMembersRoleInfo(siteId, group.getId());
        if (groupInfo != null) {
            logger.debug((Object)("addSiteGroupMembership:  " + group.getId() + " is already a member of site " + siteId));
            throw new ConstraintViolatedException(group.getId() + " is already a member of site " + siteId);
        }
        if (group.getRole() == null) {
            logger.debug((Object)"Getting member role but role is null");
            throw new RelationshipResourceNotFoundException(group.getId(), siteId);
        }
        this.siteService.setMembership(siteId, group.getId(), group.getRole());
        return group;
    }

    @Override
    public SiteGroup getSiteGroupMembership(String siteId, String groupId) {
        SiteMemberInfo groupInfo = this.isMemberOfSite(siteId, groupId);
        return new SiteGroup(groupId, groupInfo.getMemberRole());
    }

    @Override
    public SiteGroup updateSiteGroupMembership(String siteId, SiteGroup group) {
        this.isMemberOfSite(siteId, group.getId());
        this.siteService.setMembership(siteId, group.getId(), group.getRole());
        return group;
    }

    @Override
    public void removeSiteGroupMembership(String siteId, String groupId) {
        this.isMemberOfSite(siteId, groupId);
        String role = this.siteService.getMembersRole(siteId, groupId);
        if (role != null) {
            if (role.equals("SiteManager")) {
                int numAuthorities = this.siteService.countAuthoritiesWithRole(siteId, "SiteManager");
                if (numAuthorities <= 1) {
                    throw new InvalidArgumentException("Can't remove last manager of site " + siteId);
                }
                this.siteService.removeMembership(siteId, groupId);
            } else {
                this.siteService.removeMembership(siteId, groupId);
            }
        } else {
            throw new AlfrescoRuntimeException("Unable to determine role of site member");
        }
    }

    private SiteMemberInfo isMemberOfSite(String siteId, String id) {
        SiteInfo siteInfo = this.validateSite(siteId);
        if (siteInfo == null) {
            logger.debug((Object)("Site does not exist: " + siteId));
            throw new EntityNotFoundException(siteId);
        }
        this.validateGroup(id);
        SiteMemberInfo memberInfo = this.siteService.getMembersRoleInfo(siteId, id);
        if (memberInfo == null) {
            logger.debug((Object)"Given authority is not a member of the site");
            throw new InvalidArgumentException("Given authority is not a member of the site");
        }
        if (memberInfo.getMemberRole() == null) {
            logger.debug((Object)"Getting authority role but role is null");
            throw new RelationshipResourceNotFoundException(memberInfo.getMemberName(), siteId);
        }
        return memberInfo;
    }

    private void validateGroup(String groupId) throws EntityNotFoundException {
        String authorityName = this.authorityService.getName(AuthorityType.GROUP, groupId);
        if (authorityName == null) {
            logger.debug((Object)("AuthorityName does not exist: " + groupId));
            throw new EntityNotFoundException(groupId);
        }
    }

    static {
        HashMap<String, Object> aMap = new HashMap<String, Object>(3);
        aMap.put("title", ContentModel.PROP_TITLE);
        aMap.put("id", ContentModel.PROP_NAME);
        aMap.put("description", ContentModel.PROP_DESCRIPTION);
        SORT_PARAMS_TO_QNAMES = Collections.unmodifiableMap(aMap);
        aMap = new HashMap(3);
        aMap.put("title", SiteService.SortFields.SiteTitle);
        aMap.put(SiteService.SortFields.SiteTitle.toString(), SiteService.SortFields.SiteTitle);
        aMap.put("id", SiteService.SortFields.SiteShortName);
        aMap.put(SiteService.SortFields.SiteShortName.toString(), SiteService.SortFields.SiteShortName);
        aMap.put("role", SiteService.SortFields.Role);
        aMap.put(SiteService.SortFields.Role.toString(), SiteService.SortFields.Role);
        SORT_SITE_MEMBERSHIP = Collections.unmodifiableMap(aMap);
        LIST_SITES_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("visibility", "preset"));
    }
}

