/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.rest.api.Aspects;
import org.alfresco.rest.api.ClassDefinitionMapper;
import org.alfresco.rest.api.impl.AbstractClassImpl;
import org.alfresco.rest.api.model.Aspect;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;

public class AspectsImpl
extends AbstractClassImpl<Aspect>
implements Aspects {
    private DictionaryService dictionaryService;
    private NamespacePrefixResolver namespaceService;
    private ClassDefinitionMapper classDefinitionMapper;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespacePrefixResolver namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setClassDefinitionMapper(ClassDefinitionMapper classDefinitionMapper) {
        this.classDefinitionMapper = classDefinitionMapper;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"classDefinitionMapper", (Object)this.classDefinitionMapper);
    }

    AspectsImpl(DictionaryService dictionaryService, NamespacePrefixResolver namespaceService, ClassDefinitionMapper classDefinitionMapper) {
        super(dictionaryService, namespaceService, classDefinitionMapper);
    }

    @Override
    public CollectionWithPagingInfo<Aspect> listAspects(Parameters params) {
        Paging paging = params.getPaging();
        AbstractClassImpl.ModelApiFilter query = this.getQuery(params.getQuery());
        Stream<Object> aspectStream = null;
        if (query != null && query.getModelIds() != null) {
            this.validateListParam(query.getModelIds(), PARAM_MODEL_IDS);
            Set<Pair<QName, Boolean>> modelsFilter = this.parseModelIds(query.getModelIds(), PARAM_INCLUDE_SUBASPECTS);
            aspectStream = modelsFilter.stream().map(this::getModelAspects).flatMap(Collection::stream);
        } else if (query != null && query.getParentIds() != null) {
            this.validateListParam(query.getParentIds(), PARAM_PARENT_IDS);
            aspectStream = query.getParentIds().stream().map(this::getChildAspects).flatMap(Collection::stream);
        } else {
            aspectStream = this.dictionaryService.getAllAspects().stream();
        }
        List allAspects = aspectStream.filter(qName -> this.filterByNamespace(query, (QName)qName)).filter(AspectsImpl.distinctByKey(QName::getPrefixString)).map(qName -> this.convertToAspect(this.dictionaryService.getAspect(qName), params.getInclude())).collect(Collectors.toList());
        return this.createPagedResult(allAspects, paging);
    }

    @Override
    public Aspect getAspect(String aspectId) {
        if (aspectId == null) {
            throw new InvalidArgumentException("Invalid parameter: unknown scheme specified");
        }
        AspectDefinition aspectDefinition = null;
        try {
            aspectDefinition = this.dictionaryService.getAspect(QName.createQName((String)aspectId, (NamespacePrefixResolver)this.namespaceService));
        }
        catch (NamespaceException exception) {
            throw new EntityNotFoundException(aspectId);
        }
        if (aspectDefinition == null) {
            throw new EntityNotFoundException(aspectId);
        }
        return this.convertToAspect(aspectDefinition, ALL_PROPERTIES);
    }

    public Aspect convertToAspect(AspectDefinition aspectDefinition, List<String> includes) {
        try {
            Aspect aspect = new Aspect(aspectDefinition, (MessageLookup)this.dictionaryService);
            this.constructFromFilters(aspect, (ClassDefinition)aspectDefinition, includes);
            return aspect;
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("Failed to parse Aspect: " + aspectDefinition.getName() + " . " + ex.getMessage());
        }
    }

    private Collection<QName> getModelAspects(Pair<QName, Boolean> model) {
        ModelDefinition modelDefinition = null;
        try {
            modelDefinition = this.dictionaryService.getModel((QName)model.getFirst());
        }
        catch (Exception exception) {
            throw new InvalidArgumentException(exception.getMessage());
        }
        if (modelDefinition == null) {
            throw new EntityNotFoundException("model");
        }
        Collection aspects = this.dictionaryService.getAspects(modelDefinition.getName());
        if (!((Boolean)model.getSecond()).booleanValue()) {
            return aspects;
        }
        Stream aspectStream = aspects.stream();
        Stream childrenStream = aspects.stream().map(aspect -> this.dictionaryService.getSubAspects(aspect, false)).flatMap(Collection::stream);
        return Stream.concat(aspectStream, childrenStream).collect(Collectors.toList());
    }

    private Collection<QName> getChildAspects(String aspectId) {
        Collection subAspects = null;
        try {
            QName parentAspect = QName.createQName((String)aspectId, (NamespacePrefixResolver)this.namespaceService);
            subAspects = this.dictionaryService.getSubAspects(parentAspect, true);
        }
        catch (NamespaceException exception) {
            throw new InvalidArgumentException(exception.getMessage());
        }
        return subAspects;
    }
}

