/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.repo.action.constraint.FolderContentsParameterConstraint;
import org.alfresco.rest.api.Actions;
import org.alfresco.rest.api.impl.rules.ActionParameterConverter;
import org.alfresco.rest.api.model.Action;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.model.ActionParameterConstraint;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.extensions.webscripts.WebScriptException;

public class ActionsImpl
implements Actions {
    static final String CONSTRAINT_NOT_EXISTS = "Action parameter constraints for name %s do not exist.";
    private ActionService actionService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private NamespacePrefixResolver prefixResolver;
    private ActionParameterConverter actionParameterConverter;

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPrefixResolver(NamespacePrefixResolver prefixResolver) {
        this.prefixResolver = prefixResolver;
    }

    public void setActionParameterConverter(ActionParameterConverter actionParameterConverter) {
        this.actionParameterConverter = actionParameterConverter;
    }

    @Override
    public ActionDefinition getActionDefinitionById(String actionDefinitionId) {
        if (actionDefinitionId == null) {
            throw new IllegalArgumentException("Missing actionDefinitionId");
        }
        ActionDefinition result = null;
        try {
            result = this.getActionDefinition(this.actionService.getActionDefinition(actionDefinitionId));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (result == null) {
            throw new EntityNotFoundException(actionDefinitionId);
        }
        return result;
    }

    private ActionDefinition getActionDefinition(org.alfresco.service.cmr.action.ActionDefinition actionDefinitionId) {
        return this.mapFromServiceModel(actionDefinitionId);
    }

    @Override
    public CollectionWithPagingInfo<ActionDefinition> getActionDefinitions(NodeRef nodeRef, Parameters params) {
        return this.actionDefinitions(this.actionService.getActionDefinitions(nodeRef), params);
    }

    @Override
    public CollectionWithPagingInfo<ActionDefinition> getActionDefinitions(Parameters params) {
        return this.actionDefinitions(this.actionService.getActionDefinitions(), params);
    }

    private CollectionWithPagingInfo<ActionDefinition> actionDefinitions(List<org.alfresco.service.cmr.action.ActionDefinition> actionDefinitions, Parameters params) {
        Comparator<ActionDefinition> comparator;
        List<SortColumn> sorting = params.getSorting();
        Actions.SortKey sortKey = Actions.SortKey.NAME;
        Boolean sortAsc = true;
        if (sorting != null && !sorting.isEmpty()) {
            if (sorting.size() > 1) {
                throw new IllegalArgumentException("Only a single sort field ('name' or 'title') is supported.");
            }
            sortKey = Actions.SortKey.valueOf(sorting.get((int)0).column.toUpperCase());
            sortAsc = sorting.get((int)0).asc;
        }
        switch (sortKey) {
            case TITLE: {
                comparator = Comparator.comparing(ActionDefinition::getTitle, Comparator.nullsFirst(Comparator.naturalOrder()));
                break;
            }
            case NAME: {
                comparator = Comparator.comparing(ActionDefinition::getName, Comparator.nullsFirst(Comparator.naturalOrder()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid sort key, must be either 'title' or 'name'.");
            }
        }
        if (!sortAsc.booleanValue()) {
            comparator = comparator.reversed();
        }
        int maxItems = params.getPaging().getMaxItems();
        int skip = params.getPaging().getSkipCount();
        List sortedPage = actionDefinitions.stream().map(this::mapFromServiceModel).sorted(comparator).skip(skip).limit(maxItems).collect(Collectors.toList());
        boolean hasMoreItems = actionDefinitions.size() > skip + maxItems;
        return CollectionWithPagingInfo.asPaged(params.getPaging(), sortedPage, hasMoreItems, actionDefinitions.size());
    }

    @Override
    @Experimental
    public ActionDefinition getRuleActionDefinitionById(String actionDefinitionId) {
        if (actionDefinitionId == null) {
            throw new InvalidArgumentException("actionDefinitionId is null");
        }
        return this.actionService.getActionDefinitions().stream().filter(a -> actionDefinitionId.equals(a.getName())).map(this::mapFromServiceModel).findFirst().orElseThrow(() -> new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{actionDefinitionId}));
    }

    private ActionDefinition mapFromServiceModel(org.alfresco.service.cmr.action.ActionDefinition actionDefinition) {
        List<ActionDefinition.ParameterDefinition> paramDefs = actionDefinition.getParameterDefinitions().stream().map(this::toModel).collect(Collectors.toList());
        return new ActionDefinition(actionDefinition.getName(), actionDefinition.getName(), actionDefinition.getTitle(), actionDefinition.getDescription(), this.toShortQNames(actionDefinition.getApplicableTypes()), actionDefinition.getAdhocPropertiesAllowed(), actionDefinition.getTrackStatus(), paramDefs);
    }

    @Override
    public Action executeAction(Action action, Parameters parameters) {
        if (action == null) {
            throw new InvalidArgumentException("action is null");
        }
        if (action.getActionDefinitionId() == null || action.getActionDefinitionId().isEmpty()) {
            throw new InvalidArgumentException("action.actionDefinitionId is null or empty");
        }
        org.alfresco.service.cmr.action.ActionDefinition actionDef = null;
        try {
            actionDef = this.actionService.getActionDefinition(action.getActionDefinitionId());
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (actionDef == null) {
            throw new EntityNotFoundException(action.getActionDefinitionId());
        }
        NodeRef actionedUponNodeRef = null;
        if (action.getTargetId() != null && !action.getTargetId().isEmpty() && !this.nodeService.exists(actionedUponNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, action.getTargetId()))) {
            throw new EntityNotFoundException(action.getTargetId());
        }
        org.alfresco.service.cmr.action.Action cmrAction = action.getParams() != null && !action.getParams().isEmpty() ? this.actionService.createAction(action.getActionDefinitionId(), this.extractActionParams(actionDef, action.getParams())) : this.actionService.createAction(action.getActionDefinitionId());
        ActionAccessRestriction.setActionContext((org.alfresco.service.cmr.action.Action)cmrAction, (String)"v1");
        this.actionService.executeAction(cmrAction, actionedUponNodeRef, true, true);
        Action result = new Action();
        result.setId(cmrAction.getId());
        return result;
    }

    @Override
    @Experimental
    public ActionParameterConstraint getActionConstraint(String constraintName) {
        ParameterConstraint parameterConstraint = this.actionService.getParameterConstraint(constraintName);
        if (Objects.isNull(parameterConstraint)) {
            throw new NotFoundException(String.format(CONSTRAINT_NOT_EXISTS, constraintName));
        }
        return this.mapToActionConstraint(parameterConstraint);
    }

    @Experimental
    private ActionParameterConstraint mapToActionConstraint(ParameterConstraint parameterConstraint) {
        ActionParameterConstraint constraint = new ActionParameterConstraint();
        constraint.setConstraintName(parameterConstraint.getName());
        constraint.setConstraintValues(this.getConstraintDataList(parameterConstraint));
        return constraint;
    }

    @Experimental
    private List<ActionParameterConstraint.ConstraintData> getConstraintDataList(ParameterConstraint parameterConstraint) {
        Map constraintValues = parameterConstraint.getValues();
        if (parameterConstraint instanceof FolderContentsParameterConstraint) {
            return this.convertNodeRefConstraintValues(constraintValues).entrySet().stream().map(e -> new ActionParameterConstraint.ConstraintData((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
        return constraintValues.entrySet().stream().map(e -> new ActionParameterConstraint.ConstraintData((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Experimental
    private Map<String, String> convertNodeRefConstraintValues(Map<String, String> inputValues) {
        return inputValues.entrySet().stream().collect(Collectors.toMap(e -> this.actionParameterConverter.convertParamFromServiceModel((Serializable)new NodeRef((String)e.getKey())).toString(), Map.Entry::getValue));
    }

    private Map<String, Serializable> extractActionParams(org.alfresco.service.cmr.action.ActionDefinition actionDefinition, Map<String, ?> params) {
        HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>();
        try {
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                String propertyName = entry.getKey();
                Object propertyValue = entry.getValue();
                ParameterDefinition paramDef = actionDefinition.getParameterDefintion(propertyName);
                if (paramDef == null && !actionDefinition.getAdhocPropertiesAllowed()) {
                    throw new AlfrescoRuntimeException("Invalid parameter " + propertyName + " for action/condition " + actionDefinition.getName());
                }
                if (paramDef != null) {
                    QName typeQName = paramDef.getType();
                    Serializable value = this.convertValue(typeQName, propertyValue);
                    parameterValues.put(propertyName, value);
                    continue;
                }
                parameterValues.put(propertyName, (Serializable)((Object)propertyValue.toString()));
            }
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return parameterValues;
    }

    private Serializable convertValue(QName typeQName, Object propertyValue) throws JSONException {
        Serializable value;
        DataTypeDefinition typeDef = this.dictionaryService.getDataType(typeQName);
        if (typeDef == null) {
            throw new AlfrescoRuntimeException("Action property type definition " + typeQName.toPrefixString() + " is unknown.");
        }
        if (propertyValue instanceof JSONArray) {
            String javaClassName = typeDef.getJavaClassName();
            try {
                Class.forName(javaClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DictionaryException("Java class " + javaClassName + " of property type " + typeDef.getName() + " is invalid", (Throwable)e);
            }
            int length = ((JSONArray)propertyValue).length();
            ArrayList<Serializable> list = new ArrayList<Serializable>(length);
            for (int i = 0; i < length; ++i) {
                list.add(this.convertValue(typeQName, ((JSONArray)propertyValue).get(i)));
            }
            value = list;
        } else {
            value = typeQName.equals((Object)DataTypeDefinition.QNAME) && typeQName.toString().contains(":") ? QName.createQName((String)propertyValue.toString(), (NamespacePrefixResolver)this.namespaceService) : (Serializable)DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(typeQName), propertyValue);
        }
        return value;
    }

    private List<String> toShortQNames(Set<QName> types) {
        return types.stream().map(this::toShortQName).collect(Collectors.toList());
    }

    private String toShortQName(QName type) {
        return type.toPrefixString(this.prefixResolver);
    }

    private ActionDefinition.ParameterDefinition toModel(ParameterDefinition p) {
        return new ActionDefinition.ParameterDefinition(p.getName(), this.toShortQName(p.getType()), p.isMultiValued(), p.isMandatory(), p.getDisplayLabel(), p.getParameterConstraintName());
    }
}

