/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.HierarchicalMethod;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;

public class MoveMethod
extends HierarchicalMethod {
    protected boolean isMove() {
        return true;
    }

    @Override
    protected final void executeImpl() throws WebDAVServerException, Exception {
        NodeRef rootNodeRef = this.getRootNodeRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)((this.isMove() ? "Move" : "Copy") + " from " + this.getPath() + " to " + this.getDestinationPath()));
        }
        String sourcePath = this.getPath();
        FileInfo sourceInfo = null;
        try {
            sourceInfo = this.getNodeForPath(rootNodeRef, sourcePath);
        }
        catch (FileNotFoundException e) {
            throw new WebDAVServerException(404);
        }
        FileInfo sourceParentInfo = this.getDAVHelper().getParentNodeForPath(rootNodeRef, sourcePath);
        String destPath = this.getDestinationPath();
        FileInfo destParentInfo = null;
        try {
            if (destPath.endsWith("/")) {
                destPath = destPath.substring(0, destPath.length() - 1);
            }
            destParentInfo = this.getDAVHelper().getParentNodeForPath(rootNodeRef, destPath);
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Destination parent folder doesn't exist: " + destPath));
            }
            throw new WebDAVServerException(409);
        }
        FileInfo destInfo = null;
        boolean destNotHidden = false;
        try {
            destInfo = this.getDAVHelper().getNodeForPath(rootNodeRef, destPath);
            if (!destInfo.getNodeRef().equals((Object)sourceInfo.getNodeRef())) {
                boolean bl = destNotHidden = !this.getFileFolderService().isHidden(destInfo.getNodeRef());
                if (!this.hasOverWrite() && destNotHidden) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Destination exists but overwrite is not allowed");
                    }
                    throw new WebDAVServerException(412);
                }
                this.checkNode(destInfo);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        NodeRef sourceNodeRef = sourceInfo.getNodeRef();
        NodeRef sourceParentNodeRef = sourceParentInfo.getNodeRef();
        NodeRef destParentNodeRef = destParentInfo.getNodeRef();
        String name = this.getDAVHelper().splitPath(destPath)[1];
        this.moveOrCopy(sourceNodeRef, sourceParentNodeRef, destParentNodeRef, name);
        if (!destNotHidden) {
            this.m_response.setStatus(201);
        } else {
            this.m_response.setStatus(204);
        }
    }

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        super.parseRequestHeaders();
        this.parseIfHeader();
    }

    protected void moveOrCopy(NodeRef sourceNodeRef, NodeRef sourceParentNodeRef, NodeRef destParentNodeRef, String name) throws Exception {
        boolean isMove;
        FileInfo destFileInfo;
        String destPath;
        FileInfo sourceFileInfo;
        String sourcePath;
        FileFolderService fileFolderService;
        block22: {
            fileFolderService = this.getFileFolderService();
            NodeRef rootNodeRef = this.getRootNodeRef();
            sourcePath = this.getPath();
            List<String> sourcePathElements = this.getDAVHelper().splitAllPaths(sourcePath);
            sourceFileInfo = null;
            destPath = this.getDestinationPath();
            List<String> destPathElements = this.getDAVHelper().splitAllPaths(destPath);
            destFileInfo = null;
            isMove = this.isMove();
            try {
                sourceFileInfo = fileFolderService.resolveNamePath(rootNodeRef, sourcePathElements);
                destFileInfo = fileFolderService.resolveNamePath(rootNodeRef, destPathElements);
            }
            catch (FileNotFoundException e) {
                if (sourceFileInfo != null) break block22;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Source node not found: " + sourcePath));
                }
                throw new WebDAVServerException(404);
            }
        }
        LockInfo lockInfo = null;
        if (isMove) {
            lockInfo = this.checkNode(sourceFileInfo);
        }
        if (!sourceFileInfo.isFolder() && destFileInfo != null && !sourceFileInfo.equals(destFileInfo)) {
            this.copyContentOnly(sourceFileInfo, destFileInfo, fileFolderService);
            fileFolderService.setHidden(destFileInfo.getNodeRef(), false);
            if (isMove) {
                if (this.getDAVHelper().isRenameShuffle(destPath) && !this.getDAVHelper().isRenameShuffle(sourcePath)) {
                    fileFolderService.setHidden(sourceNodeRef, true);
                    this.unlock(sourceNodeRef, lockInfo);
                } else {
                    fileFolderService.delete(sourceNodeRef);
                }
            }
        } else if (!isMove) {
            if (this.hasOverWrite() && destFileInfo != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination exists and overwrite is allowed");
                }
                fileFolderService.delete(destFileInfo.getNodeRef());
            }
            fileFolderService.copy(sourceNodeRef, destParentNodeRef, name);
        } else if (!sourceFileInfo.isFolder() && this.getDAVHelper().isRenameShuffle(destPath) && !this.getDAVHelper().isRenameShuffle(sourcePath)) {
            destFileInfo = fileFolderService.create(destParentNodeRef, name, ContentModel.TYPE_CONTENT);
            this.copyContentOnly(sourceFileInfo, destFileInfo, fileFolderService);
            fileFolderService.setHidden(sourceNodeRef, true);
            this.unlock(sourceNodeRef, lockInfo);
        } else if (sourceParentNodeRef.equals((Object)destParentNodeRef)) {
            if (this.hasOverWrite() && destFileInfo != null && !sourceFileInfo.equals(destFileInfo)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination exists and overwrite is allowed");
                }
                fileFolderService.delete(destFileInfo.getNodeRef());
            }
            fileFolderService.rename(sourceNodeRef, name);
            if (!sourceFileInfo.isFolder() && this.getDAVHelper().isRenameShuffle(name)) {
                fileFolderService.setHidden(sourceFileInfo.getNodeRef(), true);
            }
            this.unlock(sourceNodeRef, lockInfo);
        } else {
            if (this.hasOverWrite() && destFileInfo != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination exists and overwrite is allowed");
                }
                fileFolderService.delete(destFileInfo.getNodeRef());
            }
            fileFolderService.moveFrom(sourceNodeRef, sourceParentNodeRef, destParentNodeRef, name);
            this.unlock(sourceNodeRef, lockInfo);
        }
    }

    private void copyContentOnly(FileInfo sourceFileInfo, FileInfo destFileInfo, FileFolderService fileFolderService) throws WebDAVServerException {
        ContentService contentService = this.getContentService();
        ContentReader reader = contentService.getReader(sourceFileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
        if (reader == null) {
            if (!sourceFileInfo.isFolder()) {
                logger.error((Object)("Unable to get ContentReader for source node " + sourceFileInfo.getNodeRef()));
                throw new WebDAVServerException(404);
            }
        } else {
            ContentWriter contentWriter = contentService.getWriter(destFileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
            contentWriter.putContent(reader);
        }
    }

    private void unlock(final NodeRef nodeRef, LockInfo lockInfo) {
        if (lockInfo != null && lockInfo.isLocked()) {
            if (lockInfo.isExpired()) {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        MoveMethod.this.getDAVHelper().getLockService().unlock(nodeRef);
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            } else {
                this.getDAVHelper().getLockService().unlock(nodeRef);
            }
        }
    }
}

