/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.util.json.ExceptionJsonSerializer;
import org.alfresco.util.json.JsonSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class TransferWebScript
extends AbstractWebScript {
    private static final Log log = LogFactory.getLog(TransferWebScript.class);
    private boolean enabled = true;
    private Map<String, CommandProcessor> processors = new TreeMap<String, CommandProcessor>();
    private JsonSerializer<Throwable, JSONObject> errorSerializer = new ExceptionJsonSerializer();

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCommandProcessors(Map<String, CommandProcessor> processors) {
        this.processors = new TreeMap<String, CommandProcessor>(processors);
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        if (this.enabled) {
            log.debug((Object)("Transfer webscript invoked by user: " + AuthenticationUtil.getFullyAuthenticatedUser() + " running as " + AuthenticationUtil.getRunAsAuthentication().getName()));
            this.processCommand((String)req.getServiceMatch().getTemplateVars().get("command"), req, res);
        } else {
            res.setStatus(404);
        }
    }

    private void processCommand(String command, WebScriptRequest req, WebScriptResponse res) {
        log.debug((Object)("Received request to process transfer command: " + command));
        if (command == null || (command = command.trim()).length() == 0) {
            log.warn((Object)"Empty or null command received by the transfer script. Returning \"Not Found\"");
            res.setStatus(404);
        } else {
            CommandProcessor processor = this.processors.get(command);
            if (processor != null) {
                log.debug((Object)("Found appropriate command processor: " + processor));
                try {
                    processor.process(req, res);
                    log.debug((Object)"command processed");
                }
                catch (TransferException ex) {
                    try {
                        log.debug((Object)"transfer exception caught", (Throwable)ex);
                        res.setStatus(500);
                        JSONObject errorObject = (JSONObject)this.errorSerializer.serialize((Object)ex);
                        String error = errorObject.toString();
                        res.setContentType("application/json");
                        res.setContentEncoding("UTF-8");
                        int length = error.getBytes("UTF-8").length;
                        res.addHeader("Content-Length", "" + length);
                        res.getWriter().write(error);
                    }
                    catch (Exception exception) {}
                }
            } else {
                log.warn((Object)("No processor found for requested command: " + command + ". Returning \"Not Found\""));
                res.setStatus(404);
            }
        }
    }
}

