/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.repo.index.shard.ShardStateBuilder;
import org.alfresco.repo.index.shard.ShardStateBuilderBase;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class TransactionsGet
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(TransactionsGet.class);
    private SearchTrackingComponent searchTrackingComponent;

    public void setSearchTrackingComponent(SearchTrackingComponent searchTrackingComponent) {
        this.searchTrackingComponent = searchTrackingComponent;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        Long maxTxnIdOnServer;
        String minTxnIdParam = req.getParameter("minTxnId");
        String fromCommitTimeParam = req.getParameter("fromCommitTime");
        String maxTxnIdParam = req.getParameter("maxTxnId");
        String toCommitTimeParam = req.getParameter("toCommitTime");
        String maxResultsParam = req.getParameter("maxResults");
        String baseUrl = req.getParameter("baseUrl");
        String hostName = req.getParameter("hostName");
        String template = req.getParameter("template");
        String instance = req.getParameter("instance");
        String numberOfShards = req.getParameter("numberOfShards");
        String port = req.getParameter("port");
        String stores = req.getParameter("stores");
        String isMaster = req.getParameter("isMaster");
        String hasContent = req.getParameter("hasContent");
        String shardMethod = req.getParameter("shardMethod");
        String lastUpdated = req.getParameter("lastUpdated");
        String lastIndexedChangeSetCommitTime = req.getParameter("lastIndexedChangeSetCommitTime");
        String lastIndexedChangeSetId = req.getParameter("lastIndexedChangeSetId");
        String lastIndexedTxCommitTime = req.getParameter("lastIndexedTxCommitTime");
        String lastIndexedTxId = req.getParameter("lastIndexedTxId");
        if (baseUrl != null) {
            ShardState shardState = ((ShardStateBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilderBase.ShardInstanceBuilderBase.ShardShardBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardBuilderBase.FlocFlocBuilder)((ShardStateBuilderBase.ShardInstanceBuilderBase.ShardShardBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilderBase.ShardInstanceShardInstanceBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)((ShardStateBuilder)ShardStateBuilder.shardState().withMaster(Boolean.valueOf(isMaster).booleanValue())).withLastUpdated(Long.valueOf(lastUpdated).longValue())).withLastIndexedChangeSetCommitTime(Long.valueOf(lastIndexedChangeSetCommitTime).longValue())).withLastIndexedChangeSetId(Long.valueOf(lastIndexedChangeSetId).longValue())).withLastIndexedTxCommitTime(Long.valueOf(lastIndexedTxCommitTime).longValue())).withLastIndexedTxId(Long.valueOf(lastIndexedTxId).longValue())).withShardInstance().withBaseUrl(baseUrl)).withPort(Integer.valueOf(port).intValue())).withHostName(hostName)).withShard().withInstance(Integer.valueOf(instance).intValue())).withFloc().withNumberOfShards(Integer.valueOf(numberOfShards).intValue())).withTemplate(template)).withHasContent(Boolean.valueOf(hasContent).booleanValue())).withShardMethod(ShardMethodEnum.getShardMethod((String)shardMethod))).endFloc()).endShard()).endShardInstance()).build();
            for (String store : stores.split(",")) {
                shardState.getShardInstance().getShard().getFloc().getStoreRefs().add(new StoreRef(store));
            }
            for (String pName : req.getParameterNames()) {
                String value;
                String key;
                if (pName.startsWith("floc.property.")) {
                    key = pName.substring("floc.property.".length());
                    value = req.getParameter(pName);
                    shardState.getShardInstance().getShard().getFloc().getPropertyBag().put(key, value);
                    continue;
                }
                if (!pName.startsWith("state.property.")) continue;
                key = pName.substring("state.property.".length());
                value = req.getParameter(pName);
                shardState.getPropertyBag().put(key, value);
            }
            this.searchTrackingComponent.registerShardState(shardState);
        }
        Long minTxnId = minTxnIdParam == null ? null : Long.valueOf(minTxnIdParam);
        Long fromCommitTime = fromCommitTimeParam == null ? null : Long.valueOf(fromCommitTimeParam);
        Long maxTxnId = maxTxnIdParam == null ? null : Long.valueOf(maxTxnIdParam);
        Long toCommitTime = toCommitTimeParam == null ? null : Long.valueOf(toCommitTimeParam);
        int maxResults = maxResultsParam == null ? 1024 : Integer.valueOf(maxResultsParam);
        List transactions = this.searchTrackingComponent.getTransactions(minTxnId, fromCommitTime, maxTxnId, toCommitTime, maxResults);
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("transactions", transactions);
        Long maxTxnCommitTime = this.searchTrackingComponent.getMaxTxnCommitTime();
        if (maxTxnCommitTime != null) {
            model.put("maxTxnCommitTime", maxTxnCommitTime);
        }
        if ((maxTxnIdOnServer = this.searchTrackingComponent.getMaxTxnId()) != null) {
            model.put("maxTxnId", maxTxnIdOnServer);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
        }
        return model;
    }
}

