/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.search.StatsParameters;
import org.alfresco.service.cmr.search.StatsProcessor;
import org.alfresco.service.cmr.search.StatsResultSet;
import org.alfresco.service.cmr.search.StatsService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.joda.time.LocalDate;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class StatsGet
extends DeclarativeWebScript {
    public static final String DATE_TIME_SUFFIX = "datetime";
    private StatsService stats;
    private SiteService siteService;
    private Map<String, String> facets;
    private Map<String, ? extends StatsProcessor> postProcessors;
    private String statsField;

    public void setFacets(Map<String, String> facets) {
        this.facets = facets;
    }

    public void setStatsField(String statsField) {
        this.statsField = statsField;
    }

    public void setStats(StatsService stats) {
        this.stats = stats;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setPostProcessors(Map<String, ? extends StatsProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(2, 1.0f);
        Map templateVars = req.getServiceMatch().getTemplateVars();
        SiteInfo siteInfo = null;
        String listFacets = req.getParameter("listFacets");
        if (listFacets != null) {
            model.put("facets", this.facets.keySet());
            model.put("resultSize", 0);
            return model;
        }
        if (templateVars != null && templateVars.containsKey("siteId") && (siteInfo = this.siteService.getSite((String)templateVars.get("siteId"))) == null) {
            throw new AccessDeniedException("No such site: " + (String)templateVars.get("siteId"));
        }
        String facetKey = req.getParameter("facet");
        if (facetKey == null) {
            facetKey = this.facets.entrySet().iterator().next().getKey();
        }
        QName propFacet = this.findFacet(facetKey);
        Pair<LocalDate, LocalDate> startAndEnd = StatsGet.getStartAndEndDates(req.getParameter("startDate"), req.getParameter("endDate"));
        String query = this.buildQuery(siteInfo, facetKey, startAndEnd);
        StatsParameters params = new StatsParameters("index-fts-alfresco", query, false);
        params.addStatsParameter("field", this.statsField);
        params.addStatsParameter("facet", "@" + propFacet.toString());
        StatsResultSet result = this.stats.query(params);
        if (this.postProcessors.containsKey(facetKey)) {
            StatsProcessor processor = this.postProcessors.get(facetKey);
            result = processor.process(result);
        }
        model.put("result", result);
        model.put("resultSize", result.getStats().size());
        return model;
    }

    private QName findFacet(String facetKey) {
        if (!this.facets.containsKey(facetKey)) {
            throw new AccessDeniedException("Invalid facet key:" + facetKey);
        }
        QName propFacet = QName.createQName((String)this.facets.get(facetKey));
        return propFacet;
    }

    protected String buildQuery(SiteInfo siteInfo, String facetKey, Pair<LocalDate, LocalDate> startEndDate) {
        StringBuilder luceneQuery = new StringBuilder();
        luceneQuery.append("TYPE:\"" + ContentModel.TYPE_CONTENT + "\"");
        if (startEndDate != null) {
            String dateFacet = ContentModel.PROP_CREATED.toString();
            luceneQuery.append(" AND " + dateFacet.toString() + ":(\"" + startEndDate.getFirst() + "\"..\"" + startEndDate.getSecond() + "\")");
        }
        if (siteInfo != null) {
            luceneQuery.append(" AND ANCESTOR:\"" + siteInfo.getNodeRef().toString() + "\"");
        }
        return luceneQuery.toString();
    }

    public static Pair<LocalDate, LocalDate> getStartAndEndDates(String start, String end) {
        if (start == null) {
            return null;
        }
        LocalDate startDate = LocalDate.parse((String)start);
        LocalDate endDate = end != null ? LocalDate.parse((String)end) : LocalDate.now();
        return new Pair((Object)startDate, (Object)endDate);
    }

    public void addFacet(String facetKey, String facetType) {
        this.facets.put(facetKey, facetType);
    }
}

